/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blocks;

import dev.imabad.theatrical.api.Support;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.ScheduledTick;
import org.jetbrains.annotations.Nullable;

public abstract class HangableBlock
extends HorizontalDirectionalBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty BROKEN = BooleanProperty.create((String)"broken");
    public static final DirectionProperty HANG_DIRECTION = DirectionProperty.create((String)"hang_direction");
    public static final BooleanProperty HANGING = BooleanProperty.create((String)"hanging");

    protected HangableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)BROKEN, (Comparable)Boolean.valueOf(false))).setValue((Property)HANG_DIRECTION, (Comparable)Direction.UP)).setValue((Property)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{BROKEN}).add(new Property[]{HANG_DIRECTION}).add(new Property[]{HANGING});
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return this.isHanging(levelReader, blockPos);
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        levelAccessor.getBlockTicks().schedule(new ScheduledTick((Object)this, blockPos, 3L, 0L));
        return super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public boolean isHanging(LevelReader levelReader, BlockPos pos) {
        BlockState blockState = levelReader.getBlockState(pos);
        if (!(blockState.getBlock() instanceof HangableBlock)) {
            return false;
        }
        if (!blockState.isAir() && ((Boolean)blockState.getValue((Property)HANGING)).booleanValue()) {
            BlockPos offset = pos.relative((Direction)blockState.getValue((Property)HANG_DIRECTION));
            return !levelReader.isEmptyBlock(offset) && levelReader.getBlockState(offset).getBlock() instanceof Support;
        }
        return false;
    }

    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)BROKEN)).booleanValue() || !this.canSurvive(blockState, (LevelReader)serverLevel, blockPos)) {
            // empty if block
        }
    }

    public abstract Direction getLightFacing(Direction var1, Player var2);
}

