/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blocks.light;

import dev.imabad.theatrical.blockentities.light.BaseDMXConsumerLightBlockEntity;
import dev.imabad.theatrical.blockentities.light.LightCollisionContext;
import dev.imabad.theatrical.blocks.HangableBlock;
import dev.imabad.theatrical.dmx.DMXNetwork;
import dev.imabad.theatrical.dmx.DMXNetworkData;
import dev.imabad.theatrical.items.Items;
import dev.imabad.theatrical.util.UUIDUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class BaseLightBlock
extends HangableBlock
implements EntityBlock {
    protected BaseLightBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public float getShadeBrightness(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        LightCollisionContext lcC;
        if (context instanceof LightCollisionContext && (lcC = (LightCollisionContext)context).getFromPos().equals((Object)pos)) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, level, pos, context);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity be;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide && (be = level.getBlockEntity(pos)) instanceof BaseDMXConsumerLightBlockEntity) {
            BaseDMXConsumerLightBlockEntity consumerLightBlockEntity = (BaseDMXConsumerLightBlockEntity)be;
            if (placer instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)placer;
                consumerLightBlockEntity.setNetworkId(DMXNetworkData.getInstance((Level)level.getServer().overworld()).getDefaultNetworkForPlayer((Player)player).id());
            }
        }
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!level.isClientSide() && be instanceof BaseDMXConsumerLightBlockEntity) {
            DMXNetwork network;
            BaseDMXConsumerLightBlockEntity consumerLightBlockEntity = (BaseDMXConsumerLightBlockEntity)be;
            if (!consumerLightBlockEntity.getNetworkId().equals(UUIDUtil.NULL) && (network = DMXNetworkData.getInstance((Level)level.getServer().overworld()).getNetwork(consumerLightBlockEntity.getNetworkId())) != null && !network.isMember(player.getUUID())) {
                return InteractionResult.FAIL;
            }
            if (player.getItemInHand(hand).getItem() == Items.CONFIGURATION_CARD.get()) {
                ItemStack itemInHand = player.getItemInHand(hand);
                CompoundTag tagData = itemInHand.getOrCreateTag();
                consumerLightBlockEntity.setNetworkId(tagData.getUUID("network"));
                if (tagData.getBoolean("universeEnabled")) {
                    consumerLightBlockEntity.setUniverse(tagData.getInt("dmxUniverse"));
                }
                if (tagData.getBoolean("addressEnabled")) {
                    consumerLightBlockEntity.setChannelStartPoint(tagData.getInt("dmxAddress"));
                }
                if (tagData.getBoolean("autoIncrement")) {
                    tagData.putInt("dmxAddress", tagData.getInt("dmxAddress") + consumerLightBlockEntity.getChannelCount());
                }
                itemInHand.save(tagData);
                DMXNetworkData instance = DMXNetworkData.getInstance((Level)level.getServer().overworld());
                player.sendSystemMessage((Component)Component.translatable((String)"item.configurationcard.success", (Object[])new Object[]{instance.getNetwork(consumerLightBlockEntity.getNetworkId()).name(), Integer.toString(consumerLightBlockEntity.getUniverse()), Integer.toString(consumerLightBlockEntity.getChannelStart()), Integer.toString(tagData.getInt("dmxAddress"))}));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return super.use(state, level, pos, player, hand, hit);
    }
}

