/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blocks.rigging;

import dev.imabad.theatrical.blocks.Blocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TankTrapBlock
extends Block {
    public static final BooleanProperty HAS_PIPE = BooleanProperty.create((String)"has_pipe");
    private final VoxelShape SIMPLE_BOX = Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0));
    private final VoxelShape PIPE = Shapes.create((AABB)new AABB(0.4, 0.0, 0.4, 0.6, 1.0, 0.6));

    public TankTrapBlock() {
        super(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(3.0f, 3.0f).noOcclusion().isValidSpawn(Blocks::neverAllowSpawn).mapColor(MapColor.METAL).sound(SoundType.METAL));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)HAS_PIPE, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HAS_PIPE) != false ? Shapes.or((VoxelShape)this.SIMPLE_BOX, (VoxelShape)this.PIPE) : this.SIMPLE_BOX;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HAS_PIPE});
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.isClientSide && player.getItemInHand(hand).is((Item)dev.imabad.theatrical.items.Items.PIPE.get()) && !((Boolean)state.getValue((Property)HAS_PIPE)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)HAS_PIPE, (Comparable)Boolean.valueOf(true)), 2);
            if (!player.isCreative()) {
                if (player.getItemInHand(hand).getCount() > 1) {
                    player.getItemInHand(hand).setCount(player.getItemInHand(hand).getCount() - 1);
                } else {
                    player.setItemInHand(hand, new ItemStack((ItemLike)Items.AIR));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(state, level, pos, player, hand, hit);
    }
}

