/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blocks.rigging;

import dev.imabad.theatrical.api.Support;
import dev.imabad.theatrical.blocks.Blocks;
import dev.imabad.theatrical.blocks.HangableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrussBlock
extends RotatedPillarBlock
implements SimpleWaterloggedBlock,
Support {
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public TrussBlock() {
        super(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(3.0f, 3.0f).noOcclusion().isValidSpawn(Blocks::neverAllowSpawn).mapColor(MapColor.METAL).sound(SoundType.METAL));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)AXIS, (Comparable)Direction.Axis.X)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState iFluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)context.getClickedFace().getAxis())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(iFluidState.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, BlockStateProperties.WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    @Override
    public float[] getHookTransforms(LevelReader levelReader, BlockPos pos, Direction facing) {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    public float getShadeBrightness(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockItem blockItem;
        Block block;
        Item item;
        if (!player.getItemInHand(hand).isEmpty() && (item = player.getItemInHand(hand).getItem()) instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof HangableBlock) {
            HangableBlock hangableBlock = (HangableBlock)block;
            BlockPos offset = hit.getDirection().getAxis() == Direction.Axis.Y ? pos.relative(player.getDirection().getOpposite()) : pos.relative(Direction.DOWN);
            if (!level.getBlockState(offset).isAir()) {
                return InteractionResult.FAIL;
            }
            Direction hangDirection = Direction.UP;
            if (hit.getDirection().getAxis() == Direction.Axis.Y) {
                hangDirection = player.getDirection();
            }
            level.setBlock(offset, (BlockState)((BlockState)((BlockState)hangableBlock.defaultBlockState().setValue((Property)HangableBlock.FACING, (Comparable)player.getDirection())).setValue((Property)HangableBlock.HANGING, (Comparable)Boolean.valueOf(true))).setValue((Property)HangableBlock.HANG_DIRECTION, (Comparable)hangDirection), 2);
            if (!player.isCreative()) {
                if (player.getItemInHand(hand).getCount() > 1) {
                    player.getItemInHand(hand).setCount(player.getItemInHand(hand).getCount() - 1);
                } else {
                    player.setItemInHand(hand, new ItemStack((ItemLike)Items.AIR));
                }
            }
            return InteractionResult.CONSUME;
        }
        return super.use(state, level, pos, player, hand, hit);
    }
}

