/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.Vec3;

public class LazyRenderers {
    private static final List<LazyRenderer> renderers = new ArrayList<LazyRenderer>();

    public static void addLazyRender(LazyRenderer renderer) {
        renderers.add(renderer);
    }

    public static void doRender(Camera camera, PoseStack poseStack, MultiBufferSource.BufferSource renderer, float partialTick) {
        if (!renderers.isEmpty()) {
            if (renderers.size() == 1) {
                LazyRenderer first = renderers.get(0);
                first.render(renderer, poseStack, camera, partialTick);
            } else {
                ArrayList<Tuple> distanced = new ArrayList<Tuple>();
                for (LazyRenderer lazyRenderer : renderers) {
                    distanced.add(new Tuple((Object)lazyRenderer, (Object)camera.getPosition().distanceToSqr(lazyRenderer.getPos(partialTick))));
                }
                distanced.sort(Comparator.comparingDouble(t -> -((Double)t.getB()).doubleValue()));
                for (Tuple lazyRendererDoubleTuple : distanced) {
                    LazyRenderer a = (LazyRenderer)lazyRendererDoubleTuple.getA();
                    a.render(renderer, poseStack, camera, partialTick);
                }
            }
            renderer.endBatch();
            renderers.clear();
        }
    }

    public static abstract class LazyRenderer {
        public abstract void render(MultiBufferSource.BufferSource var1, PoseStack var2, Camera var3, float var4);

        public abstract Vec3 getPos(float var1);
    }
}

