/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.gui.screen;

import dev.imabad.theatrical.TheatricalClient;
import dev.imabad.theatrical.client.gui.widgets.ArtNetUniverseConfigurationList;
import dev.imabad.theatrical.client.gui.widgets.LabeledEditBox;
import dev.imabad.theatrical.config.ConfigHandler;
import dev.imabad.theatrical.config.TheatricalConfig;
import dev.imabad.theatrical.config.UniverseConfig;
import dev.imabad.theatrical.util.UUIDUtil;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ArtNetConfigurationScreen
extends Screen {
    private int xCenter;
    private int yCenter;
    private EditBox ipAddressBox;
    private EditBox networkUniverse;
    private EditBox subnet;
    private EditBox universe;
    private Checkbox universeEnabled;
    private Button deleteConfig;
    private IntObjectMap<UniverseConfig> universeConfigs = new IntObjectHashMap();
    private String ipAddress;
    private boolean enabled;
    private UUID networkId;
    private Screen lastScreen;
    private GridLayout layout;
    private ArtNetUniverseConfigurationList configList;

    public ArtNetConfigurationScreen(Screen lastScreen) {
        super((Component)Component.translatable((String)"button.artnetconfig"));
        this.ipAddress = TheatricalConfig.INSTANCE.CLIENT.artNetIP;
        this.enabled = TheatricalConfig.INSTANCE.CLIENT.artnetEnabled;
        this.universeConfigs = new IntObjectHashMap();
        TheatricalConfig.INSTANCE.CLIENT.universes.forEach((integer, universeConfig) -> this.universeConfigs.put(integer, (Object)new UniverseConfig(universeConfig.subnet, universeConfig.universe, universeConfig.enabled)));
        this.networkId = TheatricalClient.getArtNetManager().getNetworkId();
        this.lastScreen = lastScreen;
    }

    protected void init() {
        super.init();
        this.layout = new GridLayout();
        this.layout.defaultCellSetting().alignHorizontallyCenter().padding(5);
        this.xCenter = this.width / 2;
        this.yCenter = this.height / 2;
        this.ipAddressBox = new LabeledEditBox(this.font, this.xCenter, this.yCenter, 100, 20, (Component)Component.translatable((String)"artneti.ipAddress")).color(0xFFFFFF).shadow(true);
        this.ipAddressBox.setValue(this.ipAddress);
        this.layout.addChild((LayoutElement)this.ipAddressBox, 1, 1, 1, 2);
        this.configList = new ArtNetUniverseConfigurationList(Minecraft.getInstance(), this, 150, 100, (Component)Component.literal((String)"test"));
        this.layout.addChild((LayoutElement)this.configList, 2, 1, 2, 1, LayoutSettings.defaults().alignHorizontallyCenter().paddingBottom(0));
        this.configList.setEntries((Map<Integer, UniverseConfig>)this.universeConfigs);
        this.layout.addChild((LayoutElement)new Button.Builder((Component)Component.literal((String)"Add"), b -> {
            this.universeConfigs.put(this.universeConfigs.size() + 1, (Object)new UniverseConfig(0, 0, false));
            this.refresh();
        }).width(150).build(), 4, 1, LayoutSettings.defaults().paddingTop(0).alignHorizontallyCenter());
        this.deleteConfig = new Button.Builder((Component)Component.literal((String)"Delete"), b -> {
            if (this.configList.getSelected() != null) {
                this.universeConfigs.remove(((ArtNetUniverseConfigurationList.Entry)this.configList.getSelected()).getNetworkUniverse());
                this.setSelected(null);
            }
            this.refresh();
        }).width(150).build();
        this.deleteConfig.active = false;
        this.deleteConfig.visible = false;
        this.layout.addChild((LayoutElement)this.deleteConfig, 4, 3, LayoutSettings.defaults().paddingTop(0).alignHorizontallyCenter());
        this.networkUniverse = new LabeledEditBox(this.font, this.xCenter, this.yCenter, 100, 20, (Component)Component.translatable((String)"screen.artnetconfig.networkUniverse")).color(0xFFFFFF).textOffsetY(-5).shadow(true);
        this.networkUniverse.visible = false;
        this.networkUniverse.active = false;
        this.layout.addChild((LayoutElement)this.networkUniverse, 2, 2);
        this.universeEnabled = new Checkbox(this.xCenter, this.yCenter, 150, 20, (Component)Component.translatable((String)"screen.artnetconfig.networkEnabled"), false);
        this.universeEnabled.visible = false;
        this.universeEnabled.active = false;
        this.layout.addChild((LayoutElement)this.universeEnabled, 2, 3);
        this.subnet = new LabeledEditBox(this.font, this.xCenter, this.yCenter, 100, 20, (Component)Component.translatable((String)"screen.artnetconfig.subnet")).color(0xFFFFFF).textOffsetY(-5).shadow(true);
        this.subnet.visible = false;
        this.subnet.active = false;
        this.layout.addChild((LayoutElement)this.subnet, 3, 2);
        this.universe = new LabeledEditBox(this.font, this.xCenter, this.yCenter, 100, 20, (Component)Component.translatable((String)"screen.artnetconfig.universe")).color(0xFFFFFF).textOffsetY(-5).shadow(true);
        this.universe.visible = false;
        this.universe.active = false;
        this.layout.addChild((LayoutElement)this.universe, 3, 3);
        this.layout.addChild((LayoutElement)new CycleButton.Builder(enabled -> Component.translatable((String)"screen.artnetconfig.enabled", (Object[])new Object[]{enabled != false ? "Yes" : "No"})).withValues(List.of(Boolean.valueOf(true), Boolean.valueOf(false))).displayOnlyValue().withInitialValue((Object)this.enabled).create(this.xCenter, this.yCenter, 150, 20, (Component)Component.translatable((String)"screen.artnetconfig.enabled"), (obj, val) -> {
            this.enabled = val;
        }), 5, 1);
        this.layout.addChild((LayoutElement)new CycleButton.Builder(networkId -> {
            if (TheatricalClient.getArtNetManager().getKnownNetworks().containsKey(networkId)) {
                return Component.literal((String)TheatricalClient.getArtNetManager().getKnownNetworks().get(networkId));
            }
            return Component.literal((String)"Unknown");
        }).withValues(CycleButton.ValueListSupplier.create((Collection)Stream.concat(Stream.of(UUIDUtil.NULL), TheatricalClient.getArtNetManager().getKnownNetworks().keySet().stream()).collect(Collectors.toList()))).displayOnlyValue().withInitialValue((Object)this.networkId).create(this.xCenter, this.yCenter, 150, 20, (Component)Component.translatable((String)"screen.artnetconfig.enabled"), (obj, val) -> {
            this.networkId = val;
        }), 5, 3);
        this.layout.addChild((LayoutElement)new Button.Builder((Component)Component.translatable((String)"artneti.save"), button -> this.update()).pos(this.xCenter + 40, this.yCenter + 200).size(150, 20).build(), 6, 3);
        this.layout.addChild((LayoutElement)new Button.Builder((Component)Component.translatable((String)"gui.back"), button -> this.minecraft.setScreen(this.lastScreen)).pos(this.xCenter + 40, this.yCenter + 200).size(150, 20).build(), 6, 1);
        this.layout.arrangeElements();
        this.repositionElements();
        this.addRenderableWidget((GuiEventListener)this.configList);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    protected void repositionElements() {
        FrameLayout.alignInRectangle((LayoutElement)this.layout, (int)0, (int)(this.height / 6 - 12), (int)this.width, (int)this.height, (float)0.5f, (float)0.0f);
    }

    protected void refresh() {
        this.configList.setEntries((Map<Integer, UniverseConfig>)this.universeConfigs);
    }

    private void saveCurrentSelection() {
        if (this.configList.getSelected() != null) {
            ((ArtNetUniverseConfigurationList.Entry)this.configList.getSelected()).getConfig().subnet = Integer.parseInt(this.subnet.getValue());
            ((ArtNetUniverseConfigurationList.Entry)this.configList.getSelected()).getConfig().universe = Integer.parseInt(this.universe.getValue());
            ((ArtNetUniverseConfigurationList.Entry)this.configList.getSelected()).getConfig().enabled = this.universeEnabled.selected();
            if (((ArtNetUniverseConfigurationList.Entry)this.configList.getSelected()).getNetworkUniverse() != Integer.parseInt(this.networkUniverse.getValue())) {
                int oldAddress = ((ArtNetUniverseConfigurationList.Entry)this.configList.getSelected()).getNetworkUniverse();
                int newAddress = Integer.parseInt(this.networkUniverse.getValue());
                this.universeConfigs.put(newAddress, (Object)((ArtNetUniverseConfigurationList.Entry)this.configList.getSelected()).getConfig());
                this.universeConfigs.remove(oldAddress);
                this.refresh();
            } else {
                this.universeConfigs.put(((ArtNetUniverseConfigurationList.Entry)this.configList.getSelected()).getNetworkUniverse(), (Object)((ArtNetUniverseConfigurationList.Entry)this.configList.getSelected()).getConfig());
            }
        }
    }

    public void setSelected(ArtNetUniverseConfigurationList.Entry entry) {
        if (entry != null) {
            this.saveCurrentSelection();
        }
        this.configList.setSelected((AbstractSelectionList.Entry)entry);
        if (entry != null) {
            this.networkUniverse.visible = true;
            this.networkUniverse.active = true;
            this.networkUniverse.setValue(Integer.toString(entry.getNetworkUniverse()));
            this.universe.visible = true;
            this.universe.active = true;
            this.universe.setValue(Integer.toString(entry.getConfig().getUniverse()));
            this.subnet.visible = true;
            this.subnet.active = true;
            this.subnet.setValue(Integer.toString(entry.getConfig().getSubnet()));
            this.universeEnabled.visible = true;
            this.universeEnabled.active = true;
            if (!this.universeEnabled.selected() && entry.getConfig().isEnabled()) {
                this.universeEnabled.onPress();
            } else if (this.universeEnabled.selected() && !entry.getConfig().isEnabled()) {
                this.universeEnabled.onPress();
            }
            this.deleteConfig.active = true;
            this.deleteConfig.visible = true;
        } else {
            this.networkUniverse.visible = false;
            this.networkUniverse.active = false;
            this.universe.visible = false;
            this.universe.active = false;
            this.subnet.visible = false;
            this.subnet.active = false;
            this.universeEnabled.visible = false;
            this.universeEnabled.active = false;
            this.deleteConfig.active = false;
            this.deleteConfig.visible = false;
        }
    }

    private void update() {
        try {
            boolean isInGame;
            this.saveCurrentSelection();
            boolean hasChangedIP = false;
            if (!Objects.equals(TheatricalConfig.INSTANCE.CLIENT.artNetIP, this.ipAddressBox.getValue()) && TheatricalConfig.INSTANCE.CLIENT.artNetIP != null) {
                hasChangedIP = true;
            }
            TheatricalConfig.INSTANCE.CLIENT.artNetIP = this.ipAddressBox.getValue();
            TheatricalConfig.INSTANCE.CLIENT.artnetEnabled = this.enabled;
            if (this.networkId != TheatricalClient.getArtNetManager().getNetworkId()) {
                TheatricalClient.getArtNetManager().setNetworkId(this.networkId);
            }
            TheatricalConfig.INSTANCE.CLIENT.universes = this.universeConfigs;
            ConfigHandler.INSTANCE.saveConfig(ConfigHandler.ConfigSide.CLIENT);
            boolean bl = isInGame = Minecraft.getInstance().level != null;
            if (isInGame) {
                if (!this.enabled) {
                    TheatricalClient.getArtNetManager().shutdownAll();
                } else {
                    if (hasChangedIP) {
                        TheatricalClient.getArtNetManager().shutdownAll();
                        TheatricalClient.getArtNetManager().getClient();
                    }
                    if (TheatricalClient.getArtNetManager().getClient() != null) {
                        TheatricalClient.getArtNetManager().getClient().refreshSubscriptions();
                    }
                }
            }
            this.minecraft.setScreen(this.lastScreen);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderLabels(guiGraphics);
    }

    private void renderLabels(GuiGraphics guiGraphics) {
        if (TheatricalConfig.INSTANCE.CLIENT.artnetEnabled) {
            if (TheatricalClient.getArtNetManager().getClient() != null && TheatricalClient.getArtNetManager().getClient().hasReceivedPacket()) {
                long inSeconds = Math.round((float)(System.currentTimeMillis() - TheatricalClient.getArtNetManager().getClient().getLastPacketMS()) / 1000.0f);
                this.renderLabel(guiGraphics, "artneti.lastReceived", -50, this.ipAddressBox.getY() + 5, inSeconds);
            } else {
                this.renderLabel(guiGraphics, "artneti.notConnected", -50, this.ipAddressBox.getY() + 5, new Object[0]);
            }
        }
    }

    private void renderLabel(GuiGraphics guiGraphics, String translationKey, int offSetX, int offSetY, Object ... replacements) {
        MutableComponent translatable = Component.translatable((String)translationKey, (Object[])replacements);
        guiGraphics.drawString(this.font, (Component)translatable, this.xCenter + this.font.width(translatable.getString()) / 2 + offSetX, offSetY, 0xFFFFFF, false);
    }

    public void tick() {
    }
}

