/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.gui.screen;

import dev.imabad.theatrical.blockentities.interfaces.ArtNetInterfaceBlockEntity;
import dev.imabad.theatrical.net.UpdateArtNetInterface;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ArtNetInterfaceScreen
extends Screen {
    private final ResourceLocation GUI = new ResourceLocation("theatrical", "textures/gui/blank.png");
    private int imageWidth = 176;
    private int imageHeight = 126;
    private int xCenter;
    private int yCenter;
    private EditBox dmxUniverse;
    private EditBox ipAddress;
    private ArtNetInterfaceBlockEntity be;

    public ArtNetInterfaceScreen(ArtNetInterfaceBlockEntity be) {
        super((Component)Component.translatable((String)"screen.artnetinterface"));
        this.be = be;
    }

    protected void init() {
        super.init();
        this.xCenter = (this.width - this.imageWidth) / 2;
        this.yCenter = (this.height - this.imageHeight) / 2;
        this.dmxUniverse = new EditBox(this.font, this.xCenter + 62, this.yCenter + 25, 50, 10, (Component)Component.translatable((String)"artneti.dmxUniverse"));
        this.dmxUniverse.setValue(Integer.toString(this.be.getUniverse()));
        this.addWidget((GuiEventListener)this.dmxUniverse);
        this.ipAddress = new EditBox(this.font, this.xCenter + 40, this.yCenter + 50, 100, 20, (Component)Component.translatable((String)"artneti.ipAddress"));
        this.ipAddress.setValue(this.be.getIp());
        this.addWidget((GuiEventListener)this.ipAddress);
    }

    private void update() {
        try {
            int dmx = Integer.parseInt(this.dmxUniverse.getValue());
            if (dmx > 512 || dmx < 0) {
                return;
            }
            new UpdateArtNetInterface(this.be.getBlockPos(), this.ipAddress.getValue(), dmx).sendToServer();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderWindow(guiGraphics);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.dmxUniverse.render(guiGraphics, mouseX, mouseY, partialTick);
        this.ipAddress.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderLabels(guiGraphics);
    }

    private void renderWindow(GuiGraphics guiGraphics) {
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
    }

    private void renderLabels(GuiGraphics guiGraphics) {
        this.renderLabel(guiGraphics, "block.theatrical.artnet_interface", 5, 5, new Object[0]);
        this.renderLabel(guiGraphics, "artneti.dmxUniverse", 0, 15, new Object[0]);
        this.renderLabel(guiGraphics, "artneti.ipAddress", 5, 40, new Object[0]);
        this.renderLabel(guiGraphics, "artneti.notAuthorized", 5, 75, new Object[0]);
    }

    private void renderLabel(GuiGraphics guiGraphics, String translationKey, int offSetX, int offSetY, Object ... replacements) {
        MutableComponent translatable = Component.translatable((String)translationKey, (Object[])replacements);
        guiGraphics.drawString(this.font, (Component)translatable, this.xCenter + this.imageWidth / 2 - this.font.width(translatable.getString()) / 2, this.yCenter + offSetY, 0x404040, false);
    }

    public void tick() {
    }
}

