/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.gui.screen;

import dev.imabad.theatrical.TheatricalClient;
import dev.imabad.theatrical.client.gui.widgets.BetterCheckbox;
import dev.imabad.theatrical.client.gui.widgets.BetterStringWidget;
import dev.imabad.theatrical.client.gui.widgets.LabeledEditBox;
import dev.imabad.theatrical.net.ConfigureConfigurationCard;
import dev.imabad.theatrical.util.UUIDUtil;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ConfigurationCardScreen
extends Screen {
    private final ResourceLocation GUI = new ResourceLocation("theatrical", "textures/gui/blank.png");
    protected final int imageWidth;
    protected final int imageHeight;
    protected int xCenter;
    protected int yCenter;
    protected GridLayout layout;
    private LabeledEditBox dmxAddress;
    private LabeledEditBox dmxUniverse;
    private Checkbox autoIncrement;
    private BetterCheckbox enableUniverse;
    private BetterCheckbox enableAddress;
    private UUID networkId = UUIDUtil.NULL;
    private CompoundTag itemData;

    public ConfigurationCardScreen(CompoundTag itemData) {
        super((Component)Component.translatable((String)"screen.configurationcard"));
        this.imageWidth = 176;
        this.imageHeight = 126;
        this.itemData = itemData;
        if (itemData.hasUUID("network")) {
            this.networkId = itemData.getUUID("network");
        }
    }

    protected void init() {
        super.init();
        this.layout = new GridLayout();
        this.layout.defaultCellSetting().alignHorizontallyCenter().padding(10);
        this.layout.addChild((LayoutElement)new BetterStringWidget((Component)Component.translatable((String)"screen.configurationcard"), this.font).setColor(0x404040).setShadow(false), 1, 1, 1, 4);
        this.dmxUniverse = new LabeledEditBox(this.font, this.xCenter, this.yCenter, 50, 10, (Component)Component.translatable((String)"artneti.dmxUniverse"));
        if (this.itemData.contains("dmxUniverse")) {
            this.dmxUniverse.setValue(Integer.toString(this.itemData.getInt("dmxUniverse")));
        } else {
            this.dmxUniverse.setValue("0");
        }
        this.layout.addChild((LayoutElement)this.dmxUniverse, 2, 1, 1, 4, LayoutSettings.defaults().alignHorizontallyCenter().alignVerticallyMiddle().padding(10));
        this.enableUniverse = new BetterCheckbox(this.xCenter, this.yCenter, 10, 10, (Component)Component.translatable((String)"artneti.dmxUniverse.enable"), this.itemData.getBoolean("universeEnabled"));
        this.dmxUniverse.active = this.enableUniverse.selected();
        this.enableUniverse.setOnChange(aBoolean -> {
            this.dmxUniverse.active = aBoolean;
        });
        this.layout.addChild((LayoutElement)this.enableUniverse, 2, 2, 1, 1, LayoutSettings.defaults().alignHorizontallyLeft().alignVerticallyMiddle());
        this.layout.addChild((LayoutElement)new CycleButton.Builder(networkId -> {
            if (TheatricalClient.getArtNetManager().getKnownNetworks().containsKey(networkId)) {
                return Component.literal((String)TheatricalClient.getArtNetManager().getKnownNetworks().get(networkId));
            }
            return Component.literal((String)"Unknown");
        }).withValues(CycleButton.ValueListSupplier.create((Collection)Stream.concat(Stream.of(UUIDUtil.NULL), TheatricalClient.getArtNetManager().getKnownNetworks().keySet().stream()).collect(Collectors.toList()))).displayOnlyValue().withInitialValue((Object)this.networkId).create(this.xCenter, this.yCenter, 150, 20, (Component)Component.translatable((String)"screen.artnetconfig.network"), (obj, val) -> {
            this.networkId = val;
        }), 3, 1, 1, 4);
        this.dmxAddress = new LabeledEditBox(this.font, this.xCenter, this.yCenter, 50, 10, (Component)Component.translatable((String)"fixture.dmxStart"));
        if (this.itemData.contains("dmxAddress")) {
            this.dmxAddress.setValue(Integer.toString(this.itemData.getInt("dmxAddress")));
        } else {
            this.dmxAddress.setValue("0");
        }
        this.layout.addChild((LayoutElement)this.dmxAddress, 4, 1, 1, 4, LayoutSettings.defaults().alignHorizontallyCenter().alignVerticallyMiddle().padding(10));
        this.enableAddress = new BetterCheckbox(this.xCenter, this.yCenter, 10, 10, (Component)Component.translatable((String)"artneti.dmxAddress.enable"), this.itemData.getBoolean("addressEnabled"));
        this.dmxAddress.active = this.enableAddress.selected();
        this.enableAddress.setOnChange(aBoolean -> {
            this.dmxAddress.active = aBoolean;
        });
        this.layout.addChild((LayoutElement)this.enableAddress, 4, 2, 1, 1, LayoutSettings.defaults().alignHorizontallyLeft().alignVerticallyMiddle());
        this.autoIncrement = new Checkbox(this.xCenter, this.yCenter, 150, 20, (Component)Component.translatable((String)"screen.configurationcard.autoincrement"), this.itemData.getBoolean("autoIncrement"));
        this.layout.addChild((LayoutElement)this.autoIncrement, 5, 1, 1, 4);
        this.layout.addChild((LayoutElement)new Button.Builder((Component)Component.translatable((String)"artneti.save"), button -> this.update()).pos(this.xCenter, this.yCenter).size(100, 20).build(), 6, 1, 1, 4);
        this.refreshLayout();
        this.repositionElements();
    }

    protected void refreshLayout() {
        if (this.layout == null) {
            return;
        }
        this.layout.arrangeElements();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    protected void repositionElements() {
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }

    protected void update() {
        try {
            int dmx = Integer.parseInt(this.dmxAddress.getValue());
            if (dmx > 512 || dmx < 0) {
                return;
            }
            int universe = Integer.parseInt(this.dmxUniverse.getValue());
            if (universe < 0) {
                return;
            }
            new ConfigureConfigurationCard(this.networkId, dmx, universe, this.autoIncrement.selected(), this.enableUniverse.selected(), this.enableAddress.selected()).sendToServer();
            Minecraft.getInstance().setScreen(null);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderWindow(guiGraphics);
    }

    private void renderWindow(GuiGraphics guiGraphics) {
        int layoutHeight = 0;
        if (this.layout != null) {
            layoutHeight = this.layout.getHeight();
        }
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - layoutHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, this.imageWidth, layoutHeight, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

