/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.gui.screen;

import dev.imabad.theatrical.TheatricalClient;
import dev.imabad.theatrical.api.dmx.DMXConsumer;
import dev.imabad.theatrical.client.gui.widgets.BetterStringWidget;
import dev.imabad.theatrical.client.gui.widgets.LabeledEditBox;
import dev.imabad.theatrical.net.UpdateDMXFixture;
import dev.imabad.theatrical.net.UpdateNetworkId;
import dev.imabad.theatrical.util.UUIDUtil;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class GenericDMXConfigurationScreen<T extends DMXConsumer>
extends Screen {
    private final ResourceLocation GUI = new ResourceLocation("theatrical", "textures/gui/blank.png");
    protected final int imageWidth;
    protected final int imageHeight;
    protected int xCenter;
    protected int yCenter;
    private LabeledEditBox dmxAddress;
    private LabeledEditBox dmxUniverse;
    private UUID networkId = UUIDUtil.NULL;
    private final T be;
    private final BlockPos blockPos;
    private final String titleTranslationKey;
    protected LinearLayout layout;

    public GenericDMXConfigurationScreen(T be, BlockPos pos, String titleTranslationKey) {
        super((Component)Component.translatable((String)titleTranslationKey));
        this.imageWidth = 176;
        this.imageHeight = 126;
        this.be = be;
        this.blockPos = pos;
        this.titleTranslationKey = titleTranslationKey;
        this.networkId = be.getNetworkId();
    }

    public void addExtraWidgetsToUI() {
    }

    protected void init() {
        super.init();
        this.layout = new LinearLayout(this.imageWidth, 156, LinearLayout.Orientation.VERTICAL);
        this.layout.defaultCellSetting().alignHorizontallyCenter().alignVerticallyMiddle().padding(10);
        this.layout.addChild((LayoutElement)new BetterStringWidget((Component)Component.translatable((String)this.titleTranslationKey), this.font).setColor(0x404040).setShadow(false));
        this.dmxAddress = new LabeledEditBox(this.font, this.xCenter, this.yCenter, 50, 10, (Component)Component.translatable((String)"fixture.dmxStart"));
        this.dmxAddress.setValue(Integer.toString(this.be.getChannelStart()));
        this.setFocused((GuiEventListener)this.dmxAddress);
        this.layout.addChild((LayoutElement)this.dmxAddress);
        this.dmxUniverse = new LabeledEditBox(this.font, this.xCenter, this.yCenter, 50, 10, (Component)Component.translatable((String)"artneti.dmxUniverse"));
        this.dmxUniverse.setValue(Integer.toString(this.be.getUniverse()));
        this.layout.addChild((LayoutElement)this.dmxUniverse);
        this.addExtraWidgetsToUI();
        this.layout.addChild((LayoutElement)new CycleButton.Builder(networkId -> {
            if (TheatricalClient.getArtNetManager().getKnownNetworks().containsKey(networkId)) {
                return Component.literal((String)TheatricalClient.getArtNetManager().getKnownNetworks().get(networkId));
            }
            return Component.literal((String)"Unknown");
        }).withValues(CycleButton.ValueListSupplier.create((Collection)Stream.concat(Stream.of(UUIDUtil.NULL), TheatricalClient.getArtNetManager().getKnownNetworks().keySet().stream()).collect(Collectors.toList()))).displayOnlyValue().withInitialValue((Object)this.networkId).create(this.xCenter, this.yCenter, 150, 20, (Component)Component.translatable((String)"screen.artnetconfig.network"), (obj, val) -> {
            this.networkId = val;
        }));
        this.layout.addChild((LayoutElement)new Button.Builder((Component)Component.translatable((String)"artneti.save"), button -> this.update()).pos(this.xCenter, this.yCenter).size(100, 20).build());
        this.refreshLayout();
        this.repositionElements();
    }

    protected void refreshLayout() {
        if (this.layout == null) {
            return;
        }
        this.layout.arrangeElements();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    protected void repositionElements() {
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }

    protected void update() {
        try {
            int dmx = Integer.parseInt(this.dmxAddress.getValue());
            if (dmx > 512 || dmx < 0) {
                return;
            }
            int universe = Integer.parseInt(this.dmxUniverse.getValue());
            if (universe < 0) {
                return;
            }
            new UpdateDMXFixture(this.blockPos, dmx, universe).sendToServer();
            new UpdateNetworkId(this.blockPos, this.networkId).sendToServer();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderWindow(guiGraphics);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderLabels(guiGraphics);
    }

    private void renderWindow(GuiGraphics guiGraphics) {
        int layoutHeight = 0;
        if (this.layout != null) {
            layoutHeight = this.layout.getHeight();
        }
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - layoutHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, this.imageWidth, layoutHeight, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void renderLabels(GuiGraphics guiGraphics) {
    }

    protected void renderLabel(GuiGraphics guiGraphics, String translationKey, int offSetX, int offSetY) {
        MutableComponent translatable = Component.translatable((String)translationKey);
        guiGraphics.drawString(this.font, (Component)translatable, this.xCenter + this.imageWidth / 2 - this.font.width(translatable.getString()) / 2, this.yCenter + offSetY, 0x404040, false);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

