/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.gui.widgets;

import dev.imabad.theatrical.client.gui.screen.ArtNetConfigurationScreen;
import dev.imabad.theatrical.config.UniverseConfig;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ArtNetUniverseConfigurationList
extends ObjectSelectionList<Entry>
implements LayoutElement {
    private ArtNetConfigurationScreen parent;

    public ArtNetUniverseConfigurationList(Minecraft minecraft, ArtNetConfigurationScreen screen, int width, int height, Component title) {
        super(minecraft, width, height, 32, height - 55 + 4, 30);
        this.parent = screen;
        this.setRenderBackground(true);
        this.setRenderHeader(false, 0);
    }

    public void setEntries(Map<Integer, UniverseConfig> configs) {
        this.clearEntries();
        configs.forEach((key, value) -> this.addEntry((AbstractSelectionList.Entry)new Entry(this.parent, (int)key, (UniverseConfig)value)));
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.getRowWidth() + 6;
    }

    public int getRowWidth() {
        return this.width - 10;
    }

    public void setX(int x) {
        this.setLeftPos(x);
    }

    public void setY(int y) {
        this.y0 = y;
        this.y1 = y + this.height;
    }

    public int getX() {
        return this.x0;
    }

    public int getY() {
        return this.y0;
    }

    public int getWidth() {
        return this.x1 - this.x0;
    }

    public int getHeight() {
        return this.height;
    }

    public void visitWidgets(Consumer<AbstractWidget> consumer) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements AutoCloseable {
        private final ArtNetConfigurationScreen parent;
        private UniverseConfig config;
        private int networkUniverse;

        public Entry(ArtNetConfigurationScreen parent, int networkUniverse, UniverseConfig config) {
            this.parent = parent;
            this.config = config;
            this.networkUniverse = networkUniverse;
        }

        public Component getNarration() {
            return Component.empty();
        }

        @Override
        public void close() {
        }

        public UniverseConfig getConfig() {
            return this.config;
        }

        public int getNetworkUniverse() {
            return this.networkUniverse;
        }

        public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            Font font = Minecraft.getInstance().font;
            guiGraphics.drawString(font, (Component)Component.translatable((String)"screen.artnetconfig.entry.universe", (Object[])new Object[]{this.networkUniverse}), left, top + 1, 0xFFFFFF);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            this.parent.setSelected(this);
            return false;
        }
    }
}

