/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.items;

import dev.imabad.theatrical.Theatrical;
import dev.imabad.theatrical.client.gui.screen.ConfigurationCardScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ConfigurationCard
extends Item {
    public ConfigurationCard() {
        super(new Item.Properties().arch$tab(Theatrical.TAB));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (player.isCrouching() && level.isClientSide()) {
            CompoundTag cardData = player.getItemInHand(usedHand).getOrCreateTag();
            ConfigurationCard.openUI(cardData);
            return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
        }
        return super.use(level, player, usedHand);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openUI(CompoundTag data) {
        Minecraft.getInstance().setScreen((Screen)new ConfigurationCardScreen(data));
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)Component.translatable((String)"item.configurationcard.description.1"));
        tooltipComponents.add((Component)Component.translatable((String)"item.configurationcard.description.2"));
    }
}

