/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.lighting;

import dev.imabad.theatrical.api.DynamicLightProvider;
import dev.imabad.theatrical.blockentities.light.BaseLightBlockEntity;
import dev.imabad.theatrical.compat.ModCompat;
import dev.imabad.theatrical.compat.ShimmerCompat;
import dev.imabad.theatrical.config.TheatricalConfig;
import dev.imabad.theatrical.lighting.LambDynamicLightUtil;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class LightManager {
    private static final Set<DynamicLightProvider> dynamicLightSources = new HashSet<DynamicLightProvider>();
    private static final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();
    public static long lastUpdate = System.currentTimeMillis();
    public static List<Integer> jarHoldingEntityList = new ArrayList<Integer>();
    public static int lastUpdateCount = 0;

    public static void addLightSource(DynamicLightProvider lightSource) {
        if (!lightSource.getLightWorld().isClientSide()) {
            return;
        }
        if (!LightManager.shouldUpdateDynamicLight()) {
            return;
        }
        if (LightManager.containsLightSource(lightSource)) {
            return;
        }
        lightSourcesLock.writeLock().lock();
        dynamicLightSources.add(lightSource);
        if (ModCompat.SHIMMER) {
            ShimmerCompat.addLight(lightSource);
        }
        lightSourcesLock.writeLock().unlock();
    }

    public static boolean containsLightSource(@NotNull DynamicLightProvider lightSource) {
        if (!lightSource.getLightWorld().isClientSide()) {
            return false;
        }
        lightSourcesLock.readLock().lock();
        boolean result = dynamicLightSources.contains(lightSource);
        lightSourcesLock.readLock().unlock();
        return result;
    }

    public int getLightSourcesCount() {
        lightSourcesLock.readLock().lock();
        int result = dynamicLightSources.size();
        lightSourcesLock.readLock().unlock();
        return result;
    }

    public static void removeLightSource(DynamicLightProvider lightSource) {
        lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightProvider> sourceIterator = dynamicLightSources.iterator();
        while (sourceIterator.hasNext()) {
            DynamicLightProvider it = sourceIterator.next();
            if (!it.equals(lightSource)) continue;
            sourceIterator.remove();
            if (ModCompat.SHIMMER) {
                ShimmerCompat.removeLight(lightSource.getOwnerPos());
                break;
            }
            if (Minecraft.getInstance().level == null) break;
            lightSource.scheduleTrackedChunksRebuild(Minecraft.getInstance().levelRenderer);
            break;
        }
        lightSourcesLock.writeLock().unlock();
    }

    public static void clearLightSources() {
        lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightProvider> sourceIterator = dynamicLightSources.iterator();
        while (sourceIterator.hasNext()) {
            DynamicLightProvider it = sourceIterator.next();
            sourceIterator.remove();
            if (ModCompat.SHIMMER) {
                ShimmerCompat.removeLight(it.getOwnerPos());
                continue;
            }
            if (Minecraft.getInstance().levelRenderer == null) continue;
            if (it.getLightLuminance() > 0) {
                it.resetLight();
            }
            it.scheduleTrackedChunksRebuild(Minecraft.getInstance().levelRenderer);
        }
        jarHoldingEntityList = new ArrayList<Integer>();
        lightSourcesLock.writeLock().unlock();
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, @NotNull BlockPos chunkPos) {
        LightManager.scheduleChunkRebuild(renderer, chunkPos.getX(), chunkPos.getY(), chunkPos.getZ());
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, long chunkPos) {
        LightManager.scheduleChunkRebuild(renderer, BlockPos.getX((long)chunkPos), BlockPos.getY((long)chunkPos), BlockPos.getZ((long)chunkPos));
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, int x, int y, int z) {
        if (Minecraft.getInstance().level != null) {
            renderer.setSectionDirty(x, y, z);
        }
    }

    public static void updateAll(LevelRenderer renderer) {
        long now;
        lastUpdate = now = System.currentTimeMillis();
        lastUpdateCount = 0;
        lightSourcesLock.readLock().lock();
        for (DynamicLightProvider lightSource : dynamicLightSources) {
            if (!lightSource.updateDynamicLight(renderer)) continue;
            ++lastUpdateCount;
        }
        lightSourcesLock.readLock().unlock();
    }

    public static void updateTrackedChunks(@NotNull BlockPos chunkPos, @Nullable LongOpenHashSet old, @Nullable LongOpenHashSet newPos) {
        if (old != null || newPos != null) {
            long pos = chunkPos.asLong();
            if (old != null) {
                old.remove(pos);
            }
            if (newPos != null) {
                newPos.add(pos);
            }
        }
    }

    public static int getLightmapWithDynamicLight(@NotNull BlockPos pos, int lightmap) {
        return LightManager.getLightmapWithDynamicLight(LightManager.getDynamicLightLevel(pos), lightmap);
    }

    public static int getLightmapWithDynamicLight(double dynamicLightLevel, int lightmap) {
        int blockLevel;
        if (dynamicLightLevel > 0.0 && dynamicLightLevel > (double)(blockLevel = LightManager.getBlockLightNoPatch(lightmap))) {
            int luminance = (int)(dynamicLightLevel * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public static int getBlockLightNoPatch(int light) {
        return light >> 4 & 0xFFFF;
    }

    public static double getDynamicLightLevel(@NotNull BlockPos pos) {
        double result = 0.0;
        lightSourcesLock.readLock().lock();
        for (DynamicLightProvider lightSource : dynamicLightSources) {
            result = LightManager.maxDynamicLightLevel(pos, lightSource, result);
        }
        lightSourcesLock.readLock().unlock();
        return Mth.clamp((double)result, (double)0.0, (double)15.0);
    }

    public static double maxDynamicLightLevel(@NotNull BlockPos pos, @NotNull DynamicLightProvider lightSource, double currentLightLevel) {
        int luminance = lightSource.getLightLuminance();
        if (luminance > 0) {
            double multiplier;
            double lightLevel;
            double radius;
            double maxRadius;
            double dz;
            double dy;
            Vector3f lightPos = lightSource.getLightPos();
            double dx = (double)((float)pos.getX() - lightPos.x) + 0.5;
            double distanceSquared = dx * dx + (dy = (double)((float)pos.getY() - lightPos.y) + 0.5) * dy + (dz = (double)((float)pos.getZ() - lightPos.z) + 0.5) * dz;
            if (distanceSquared <= (maxRadius = (radius = (double)lightSource.getLightSpread()) * radius) && (lightLevel = (multiplier = 1.0 - Math.sqrt(distanceSquared) / maxRadius) * (double)luminance) > currentLightLevel) {
                return lightLevel;
            }
        }
        return currentLightLevel;
    }

    public static void updateTracking(@NotNull DynamicLightProvider lightSource) {
        boolean enabled = lightSource.isLightEnabled();
        int luminance = lightSource.getLightLuminance();
        if (!enabled && luminance > 0) {
            lightSource.setLightEnabled(true);
        } else if (enabled && luminance < 1) {
            lightSource.setLightEnabled(false);
        }
    }

    public static boolean shouldUpdateDynamicLight() {
        return LightManager.shouldUpdateDynamicLight(false);
    }

    public static boolean shouldUpdateDynamicLight(boolean checkShimmer) {
        if (checkShimmer && ModCompat.SHIMMER) {
            return false;
        }
        return TheatricalConfig.INSTANCE.COMMON.shouldEmitLight;
    }

    public static boolean updateDynamicLight(BaseLightBlockEntity light, LevelRenderer renderer) {
        int luminance = light.getLightLuminance();
        float spread = light.getLightSpread();
        BlockPos emissionBlock = light.getEmissionBlock();
        if (!emissionBlock.equals((Object)light.getPrevEmissionBlock()) || luminance != light.getPrevLuminance() || spread != light.getPrevSpread()) {
            light.setPrevEmissionBlock(emissionBlock);
            light.setPrevLuminance(luminance);
            light.setPrevSpread(spread);
            if (ModCompat.SHIMMER) {
                ShimmerCompat.handleLightUpdate(light);
            } else {
                LightManager.theatricalLightHandler(light, renderer, luminance, emissionBlock);
            }
            return true;
        }
        if (ModCompat.SHIMMER && (light.getPrevColour() != light.getLightColour() || light.getPrevSpread() != light.getLightSpread())) {
            light.setPrevColour(light.getLightColour());
            light.setPrevSpread(light.getLightSpread());
            ShimmerCompat.handleLightUpdate(light);
        }
        return false;
    }

    private static void theatricalLightHandler(BaseLightBlockEntity light, LevelRenderer renderer, int luminance, BlockPos emissionBlock) {
        LongOpenHashSet newPos = new LongOpenHashSet();
        if (luminance > 0) {
            ChunkPos entityChunkPos = new ChunkPos(emissionBlock);
            BlockPos.MutableBlockPos chunkPos = new BlockPos.MutableBlockPos(entityChunkPos.x, LambDynamicLightUtil.getSectionCoord(emissionBlock.getY()), entityChunkPos.z);
            LightManager.scheduleChunkRebuild(renderer, (BlockPos)chunkPos);
            LightManager.updateTrackedChunks((BlockPos)chunkPos, light.getTrackedLitChunkPos(), newPos);
            Direction directionX = (emissionBlock.getX() & 0xF) >= 8 ? Direction.EAST : Direction.WEST;
            Direction directionY = (emissionBlock.getY() & 0xF) >= 8 ? Direction.UP : Direction.DOWN;
            Direction directionZ = (emissionBlock.getZ() & 0xF) >= 8 ? Direction.SOUTH : Direction.NORTH;
            for (int i = 0; i < 7; ++i) {
                if (i % 4 == 0) {
                    chunkPos.move(directionX);
                } else if (i % 4 == 1) {
                    chunkPos.move(directionZ);
                } else if (i % 4 == 2) {
                    chunkPos.move(directionX.getOpposite());
                } else {
                    chunkPos.move(directionZ.getOpposite());
                    chunkPos.move(directionY);
                }
                LightManager.scheduleChunkRebuild(renderer, (BlockPos)chunkPos);
                LightManager.updateTrackedChunks((BlockPos)chunkPos, light.getTrackedLitChunkPos(), newPos);
            }
        }
        light.scheduleTrackedChunksRebuild(renderer);
        light.setTrackedLitChunkPos(newPos);
    }
}

