/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.neoforge;

import dev.imabad.theatrical.Theatrical;
import dev.imabad.theatrical.TheatricalClient;
import dev.imabad.theatrical.api.Fixture;
import dev.imabad.theatrical.fixtures.Fixtures;
import dev.imabad.theatrical.neoforge.DataEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.javafmlmod.FMLJavaModLoadingContext;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="theatrical")
public class TheatricalNeoForge {
    public TheatricalNeoForge() {
        Theatrical.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(DataEvent::onData);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="theatrical", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void setupClient(FMLClientSetupEvent event) {
            TheatricalClient.init();
            FMLJavaModLoadingContext.get().getModEventBus().addListener(additionalEvent -> {
                for (Fixture fixture : Fixtures.FIXTURES) {
                    if (fixture.getStaticModel() != null) {
                        additionalEvent.register(fixture.getStaticModel());
                    }
                    if (fixture.hasPanModel() && fixture.getPanModel() != null) {
                        additionalEvent.register(fixture.getPanModel());
                    }
                    if (!fixture.hasTiltModel() || fixture.getTiltModel() == null) continue;
                    additionalEvent.register(fixture.getTiltModel());
                }
            });
            NeoForge.EVENT_BUS.addListener(renderLevelStageEvent -> {
                if (renderLevelStageEvent.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
                    TheatricalClient.renderWorldLastAfterTripwire(renderLevelStageEvent.getLevelRenderer());
                }
                if (renderLevelStageEvent.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                    TheatricalClient.renderWorldLast(renderLevelStageEvent.getPoseStack(), renderLevelStageEvent.getProjectionMatrix(), renderLevelStageEvent.getCamera(), renderLevelStageEvent.getPartialTick());
                }
            });
        }
    }
}

