/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.net.artnet;

import ch.bildspur.artnet.rdm.RDMDeviceId;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.imabad.theatrical.TheatricalClient;
import dev.imabad.theatrical.dmx.DMXDevice;
import dev.imabad.theatrical.net.TheatricalNet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.api.distmarker.Dist;

public class ListConsumers
extends BaseS2CMessage {
    private int universe;
    private List<DMXDevice> dmxDevices;

    public ListConsumers(int universe, List<DMXDevice> dmxDevices) {
        this.universe = universe;
        this.dmxDevices = dmxDevices;
    }

    public ListConsumers(FriendlyByteBuf buf) {
        this.universe = buf.readInt();
        int count = buf.readInt();
        this.dmxDevices = new ArrayList<DMXDevice>();
        for (int i = 0; i < count; ++i) {
            this.dmxDevices.add(new DMXDevice(new RDMDeviceId(buf.readByteArray(6)), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readUtf(), buf.readResourceLocation()));
        }
    }

    public MessageType getType() {
        return TheatricalNet.LIST_CONSUMERS;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.universe);
        buf.writeInt(this.dmxDevices.size());
        for (DMXDevice dmxDevice : this.dmxDevices) {
            buf.writeByteArray(dmxDevice.getDeviceId().toBytes());
            buf.writeInt(dmxDevice.getDmxStartAddress());
            buf.writeInt(dmxDevice.getDmxChannelCount());
            buf.writeInt(dmxDevice.getDeviceTypeId());
            buf.writeInt(dmxDevice.getActivePersonality());
            buf.writeUtf(dmxDevice.getModelName());
            buf.writeResourceLocation(dmxDevice.getFixtureID());
        }
    }

    public void handle(NetworkManager.PacketContext context) {
        if (context.getEnv() == Dist.CLIENT) {
            TheatricalClient.handleListConsumers(this);
        }
    }

    public int getUniverse() {
        return this.universe;
    }

    public List<DMXDevice> getDmxDevices() {
        return this.dmxDevices;
    }
}

