/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.gui.screen;

import dev.imabad.theatrical.TheatricalClient;
import dev.imabad.theatrical.blockentities.control.BasicLightingDeskBlockEntity;
import dev.imabad.theatrical.client.gui.widgets.FaderWidget;
import dev.imabad.theatrical.net.ControlGo;
import dev.imabad.theatrical.net.ControlModeToggle;
import dev.imabad.theatrical.net.ControlMoveStep;
import dev.imabad.theatrical.net.ControlUpdateFader;
import dev.imabad.theatrical.net.UpdateNetworkId;
import dev.imabad.theatrical.util.UUIDUtil;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class BasicLightingDeskScreen
extends Screen {
    private final ResourceLocation GUI = new ResourceLocation("theatrical", "textures/gui/lighting_console.png");
    private int imageWidth = 244;
    private int imageHeight = 126;
    private int xCenter;
    private int yCenter;
    private BasicLightingDeskBlockEntity be;
    private EditBox fadeInTime;
    private EditBox fadeOutTime;
    private UUID networkId;

    public BasicLightingDeskScreen(BasicLightingDeskBlockEntity blockEntity) {
        super((Component)Component.m_237115_((String)"screen.basicLightingDesk"));
        this.be = blockEntity;
        this.networkId = this.be.getNetworkId();
    }

    public void m_280273_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_280273_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderWindow(guiGraphics);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderLabels(guiGraphics);
    }

    private void renderWindow(GuiGraphics guiGraphics) {
        int relX = (this.f_96543_ - this.imageWidth) / 2;
        int relY = (this.f_96544_ - this.imageHeight) / 2;
        guiGraphics.m_280218_(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
    }

    private void renderLabels(GuiGraphics guiGraphics) {
        this.renderLabel(guiGraphics, "ui.control.step", 20, 57, this.be.getCurrentStep());
        this.renderLabel(guiGraphics, this.be.isRunMode() ? "ui.control.modes.run" : "ui.control.modes.program", 41, 90, new Object[0]);
        this.renderLabel(guiGraphics, "ui.control.cues", 100, 5, new Object[0]);
        for (int key : this.be.getStoredSteps().keySet()) {
            this.renderLabel(guiGraphics, "ui.control.cue", 101, 15 + 10 * key, key);
        }
        this.renderLabel(guiGraphics, "ui.control.fadeIn", 35, 10, new Object[0]);
        this.renderLabel(guiGraphics, "ui.control.fadeOut", 35, 33, new Object[0]);
    }

    private void renderLabel(GuiGraphics guiGraphics, String translationKey, int offSetX, int offSetY, Object ... replacements) {
        guiGraphics.m_280168_().m_85836_();
        MutableComponent translatable = Component.m_237110_((String)translationKey, (Object[])replacements);
        guiGraphics.m_280614_(this.f_96547_, (Component)translatable, this.xCenter + this.imageWidth / 2 - this.f_96547_.m_92895_(translatable.getString()) / 2 + offSetX, this.yCenter + offSetY, 0x404040, false);
        guiGraphics.m_280168_().m_85849_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.xCenter = (this.f_96543_ - this.imageWidth) / 2;
        this.yCenter = (this.f_96544_ - this.imageHeight) / 2;
        byte[] faders = this.be.getFaders();
        for (int i = 0; i < faders.length; ++i) {
            int baseY = this.yCenter + 7;
            if (i >= 6) {
                baseY += i / 6 * 61;
            }
            int faderNumber = i - i / 6 * 6;
            this.m_142416_((GuiEventListener)new FaderWidget(this.xCenter + 7 + faderNumber * 20, baseY, i, Byte.toUnsignedInt(faders[i])));
        }
        this.m_142416_((GuiEventListener)new FaderWidget(this.xCenter + 184, this.yCenter + 7, -1, Byte.toUnsignedInt(this.be.getGrandMaster())));
        this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"<-"), button -> this.moveStep(false)).m_252794_(this.xCenter + 155, this.yCenter + 67).m_253046_(15, 20).m_253136_());
        this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"->"), button -> this.moveStep(true)).m_252794_(this.xCenter + 170, this.yCenter + 67).m_253046_(15, 20).m_253136_());
        this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"Go"), button -> this.go()).m_252794_(this.xCenter + 130, this.yCenter + 100).m_253046_(20, 20).m_253136_());
        this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"Mode"), button -> this.mode()).m_252794_(this.xCenter + 155, this.yCenter + 100).m_253046_(30, 20).m_253136_());
        this.fadeInTime = new EditBox(this.f_96547_, this.xCenter + 147, this.yCenter + 20, 20, 10, (Component)Component.m_237113_((String)"0"));
        this.fadeOutTime = new EditBox(this.f_96547_, this.xCenter + 147, this.yCenter + 43, 20, 10, (Component)Component.m_237113_((String)"0"));
        this.fadeInTime.m_94144_(Integer.toString(this.be.getFadeInTicks()));
        this.fadeOutTime.m_94144_(Integer.toString(this.be.getFadeOutTicks()));
        this.m_142416_((GuiEventListener)this.fadeInTime);
        this.m_142416_((GuiEventListener)this.fadeOutTime);
        this.m_142416_((GuiEventListener)new CycleButton.Builder(networkId -> {
            if (TheatricalClient.getArtNetManager().getKnownNetworks().containsKey(networkId)) {
                return Component.m_237113_((String)TheatricalClient.getArtNetManager().getKnownNetworks().get(networkId));
            }
            return Component.m_237113_((String)"Unknown");
        }).m_232500_(CycleButton.ValueListSupplier.m_232504_((Collection)Stream.concat(Stream.of(UUIDUtil.NULL), TheatricalClient.getArtNetManager().getKnownNetworks().keySet().stream()).collect(Collectors.toList()))).m_168929_().m_168948_((Object)this.networkId).m_168936_(this.xCenter + 45, this.yCenter + 130, 150, 20, (Component)Component.m_237115_((String)"screen.artnetconfig.network"), (obj, val) -> {
            this.networkId = val;
            new UpdateNetworkId(this.be.m_58899_(), this.networkId).sendToServer();
        }));
    }

    private void moveStep(boolean forward) {
        new ControlMoveStep(this.be.m_58899_(), forward).sendToServer();
    }

    private void go() {
        new ControlGo(this.be.m_58899_(), Integer.parseInt(this.fadeInTime.m_94155_()), Integer.parseInt(this.fadeOutTime.m_94155_())).sendToServer();
    }

    private void mode() {
        new ControlModeToggle(this.be.m_58899_()).sendToServer();
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.m_6702_().forEach(widget -> {
            FaderWidget fader;
            if (widget instanceof FaderWidget && (fader = (FaderWidget)((Object)widget)).m_5953_(mouseX, mouseY) && fader.isDragging()) {
                int newVal = fader.updateValue(mouseY);
                new ControlUpdateFader(this.be.m_58899_(), fader.getChannel(), newVal).sendToServer();
            }
        });
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_7043_() {
        return false;
    }
}

