/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer;

import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.PsrLocalization;
import io.github.rothes.protocolstringreplacer.api.configuration.CommentYamlConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;

public class ConfigManager {
    public final boolean printReplacer;
    public final boolean cmdTypingSound;
    public final boolean placeholderEnabled;
    public final char placeholderHead;
    public final char placeholderTail;
    public final boolean consolePlaceholder;
    public final long cleanTaskInterval;
    public final long cleanAccessInterval;
    public final LifeCycle loadConfigLifeCycle;
    public final String listenerPriority;
    public final boolean forceReplace;
    public final boolean convertPlayerChat;
    public final boolean removeCacheWhenMerchantTrade;
    public final int protocolLibSideStackPrintCount;
    public final int maxCaptureRecords;
    public final boolean directSkips;
    public final String gitRawHost;
    public final boolean resetConsoleColor;

    public ConfigManager(ProtocolStringReplacer instance) {
        CommentYamlConfiguration config = instance.getConfig();
        this.printReplacer = config.getBoolean("Options.Features.Console.Print-Replacer-Config-When-Loaded", false);
        this.cmdTypingSound = config.getBoolean("Options.Features.Command-Typing-Sound-Enabled", true);
        String placeholderHead = config.getString("Options.Features.Placeholder.Placeholder-Head");
        if (placeholderHead == null || placeholderHead.isEmpty()) {
            ProtocolStringReplacer.error(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Config.Invalid-Placeholder-Head", new String[0]));
            this.placeholderHead = (char)65371;
        } else {
            this.placeholderHead = placeholderHead.charAt(0);
        }
        if (config.getBoolean("Options.Features.Placeholder.Placeholder-Enabled", true)) {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                List ver = Arrays.stream(Bukkit.getPluginManager().getPlugin("PlaceholderAPI").getDescription().getVersion().split("-")[0].split("\\.")).map(Integer::parseInt).collect(Collectors.toList());
                if ((Integer)ver.get(1) < 10 || (Integer)ver.get(1) == 10 && (Integer)ver.get(2) < 7) {
                    ProtocolStringReplacer.warn(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Initialize.Incompatible-PAPI-Version", new String[0]));
                    this.placeholderEnabled = false;
                } else {
                    this.placeholderEnabled = true;
                }
            } else {
                ProtocolStringReplacer.warn(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Initialize.Missing-PAPI", new String[0]));
                this.placeholderEnabled = false;
            }
        } else {
            this.placeholderEnabled = false;
        }
        String placeholderTail = config.getString("Options.Features.Placeholder.Placeholder-Tail");
        if (placeholderTail == null || placeholderTail.isEmpty()) {
            ProtocolStringReplacer.error(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Config.Invalid-Placeholder-Tail", new String[0]));
            this.placeholderTail = (char)65373;
        } else {
            this.placeholderTail = placeholderTail.charAt(0);
        }
        this.cleanTaskInterval = 20L * (long)config.getInt("Options.Features.ItemMetaCache.Purge-Task-Interval", 600);
        this.cleanAccessInterval = 1000L * (long)config.getInt("Options.Features.ItemMetaCache.Purge-Access-Interval", 300);
        switch (config.getString("Options.Config-Load-LifeCycle", "ENABLE").toUpperCase(Locale.ROOT)) {
            case "INIT": {
                this.loadConfigLifeCycle = LifeCycle.INIT;
                break;
            }
            case "LOAD": {
                this.loadConfigLifeCycle = LifeCycle.LOAD;
                break;
            }
            case "ENABLE": {
                this.loadConfigLifeCycle = LifeCycle.ENABLE;
                break;
            }
            default: {
                ProtocolStringReplacer.error(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Config.Invalid-Config-Load-LifeCycle", new String[0]));
                this.loadConfigLifeCycle = LifeCycle.ENABLE;
            }
        }
        this.listenerPriority = config.getString("Options.Features.Packet-Listener.Listener-Priority", "HIGHEST");
        this.forceReplace = config.getBoolean("Options.Features.Packet-Listener.Force-Replace", false);
        this.consolePlaceholder = config.getBoolean("Options.Features.Placeholder.Parse-For-Console", true);
        this.gitRawHost = config.getString("Options.Git-Raw-Host", "raw.githubusercontent.com");
        this.protocolLibSideStackPrintCount = config.getInt("Options.ProtocolLib-Side-Stack-Print-Count", 3);
        this.maxCaptureRecords = config.getInt("Options.Max-Capture-Records", 100);
        this.convertPlayerChat = instance.getServerMajorVersion() >= 19 && config.getBoolean("Options.Features.Chat-Packet.Convert-Player-Chat", true);
        this.removeCacheWhenMerchantTrade = config.getBoolean("Options.Features.ItemMetaCache.Remove-Cache-When-Merchant-Trade", false);
        this.directSkips = config.getBoolean("Options.Features.Replace-Mode.Skip-When-Direct-Replaced", true);
        this.resetConsoleColor = config.getBoolean("Options.Features.Console.Reset-Console-Color-At-End", true);
    }

    public static enum LifeCycle {
        INIT,
        LOAD,
        ENABLE;

    }
}

