/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer;

import com.sk89q.protocolstringreplacer.PsrDisguisePlugin;
import io.github.rothes.protocolstringreplacer.ConfigManager;
import io.github.rothes.protocolstringreplacer.PsrLocalization;
import io.github.rothes.protocolstringreplacer.Updater;
import io.github.rothes.protocolstringreplacer.api.configuration.CommentYamlConfiguration;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.api.user.PsrUserManager;
import io.github.rothes.protocolstringreplacer.command.CommandHandler;
import io.github.rothes.protocolstringreplacer.console.ConsoleReplaceManager;
import io.github.rothes.protocolstringreplacer.events.PsrReloadEvent;
import io.github.rothes.protocolstringreplacer.listeners.PlayerJoinListener;
import io.github.rothes.protocolstringreplacer.listeners.PlayerQuitListener;
import io.github.rothes.protocolstringreplacer.listeners.PsrInternalListeners;
import io.github.rothes.protocolstringreplacer.nms.NmsManager;
import io.github.rothes.protocolstringreplacer.packetlistener.PacketListenerManager;
import io.github.rothes.protocolstringreplacer.replacer.ReplacerManager;
import io.github.rothes.protocolstringreplacer.upgrade.AbstractUpgradeHandler;
import io.github.rothes.protocolstringreplacer.upgrade.UpgradeEnum;
import io.github.rothes.protocolstringreplacer.util.FileUtils;
import io.github.rothes.protocolstringreplacer.util.scheduler.PsrScheduler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLogger;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ProtocolStringReplacer
extends JavaPlugin {
    private static ProtocolStringReplacer instance;
    private static Logger logger;
    private CommentYamlConfiguration config;
    private File configFile;
    private ReplacerManager replacerManager;
    private PacketListenerManager packetListenerManager;
    private ConsoleReplaceManager consoleReplaceManager;
    private PsrUserManager userManager;
    private ConfigManager configManager;
    private final byte serverMajorVersion;
    private final byte serverMinorVersion;
    private boolean isSpigot;
    private boolean isPaper;
    private boolean isFolia;
    private boolean hasPaperComponent;
    private boolean hasStarted;
    private boolean reloading;

    public ProtocolStringReplacer() {
        instance = this;
        try {
            Field logger = JavaPlugin.class.getDeclaredField("logger");
            logger.setAccessible(true);
            logger.set((Object)this, new PluginLogger((Plugin)new PsrDisguisePlugin(this)));
            logger.setAccessible(false);
            Field name = PluginLogger.class.getDeclaredField("pluginName");
            name.setAccessible(true);
            String background = ";48;2;5;15;40";
            String bracket = "\u001b[38;2;255;106;0;48;2;5;15;40m";
            String red = "\u001b[0;91;48;2;5;15;40m";
            String gold = "\u001b[0;33;48;2;5;15;40m";
            String brightGold = "\u001b[38;2;220;175;0;48;2;5;15;40m";
            String reset = "\u001b[0m";
            name.set(this.getLogger(), "\u001b[38;2;255;106;0;48;2;5;15;40m[\u001b[0;91;48;2;5;15;40mProtocol\u001b[0;33;48;2;5;15;40mString\u001b[38;2;220;175;0;48;2;5;15;40mReplacer\u001b[38;2;255;106;0;48;2;5;15;40m]\u001b[0m ");
            name.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        logger = this.getLogger();
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            this.isFolia = true;
        }
        catch (ClassNotFoundException e) {
            this.isFolia = false;
        }
        String[] split = Bukkit.getServer().getBukkitVersion().split("-")[0].split("\\.");
        this.serverMajorVersion = Byte.parseByte(split[1]);
        this.serverMinorVersion = split.length > 2 ? Byte.parseByte(split[2]) : (byte)0;
        NmsManager.INSTANCE.setWarningFunction(ProtocolStringReplacer::warn);
        NmsManager.INSTANCE.setVersion(this.serverMajorVersion, this.serverMinorVersion);
        this.consoleReplaceManager = new ConsoleReplaceManager(this);
        this.consoleReplaceManager.initialize();
        this.loadConfigAndLocale();
        this.checkConfig();
        this.enableModify(ConfigManager.LifeCycle.INIT);
    }

    public static ProtocolStringReplacer getInstance() {
        return instance;
    }

    public static void info(String message) {
        logger.info(message);
    }

    public static void warn(String message) {
        logger.warning("\u001b[0;93m" + message + "\u001b[m");
    }

    public static void warn(String message, Throwable throwable) {
        logger.log(Level.WARNING, "\u001b[0;93m" + message + "\u001b[m", throwable);
    }

    public static void error(String message) {
        logger.severe("\u001b[0;91m" + message + "\u001b[m");
    }

    public static void error(String message, Throwable throwable) {
        logger.log(Level.SEVERE, "\u001b[0;91m" + message + "\u001b[m", throwable);
    }

    public boolean hasStarted() {
        return this.hasStarted;
    }

    public boolean isReloading() {
        return this.reloading;
    }

    @NotNull
    public CommentYamlConfiguration getConfig() {
        return this.config;
    }

    @NotNull
    public File getConfigFile() {
        return this.configFile;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public void onLoad() {
        this.enableModify(ConfigManager.LifeCycle.LOAD);
    }

    public void onEnable() {
        block7: {
            try {
                Class.forName("org.bukkit.entity.Player$Spigot");
                this.isSpigot = true;
            }
            catch (Throwable tr) {
                this.isSpigot = false;
                ProtocolStringReplacer.error(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Initialize.Require-Spigot", new String[0]));
                Bukkit.getPluginManager().disablePlugin((Plugin)instance);
                return;
            }
            try {
                Class.forName("com.destroystokyo.paper.VersionHistoryManager$VersionData");
                this.isPaper = true;
                try {
                    Class.forName("io.papermc.paper.text.PaperComponents");
                    this.hasPaperComponent = true;
                }
                catch (Throwable tr) {
                    this.hasPaperComponent = false;
                }
            }
            catch (Throwable tr) {
                this.isPaper = false;
                if (this.serverMajorVersion < 12) break block7;
                ProtocolStringReplacer.warn("\u001b[0;31m" + PsrLocalization.getLocaledMessage("Console-Sender.Messages.Initialize.Recommend-Paper", new String[0]) + "\u001b[0m");
            }
        }
        if (!this.checkDepends("ProtocolLib", "NBTAPI")) {
            this.initialize();
            new Updater(this).start();
        }
    }

    public void onDisable() {
        if (this.consoleReplaceManager != null) {
            this.consoleReplaceManager.disable();
        }
        if (this.packetListenerManager != null) {
            this.packetListenerManager.removeListeners();
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.updateInventory();
            }
        }
        if (this.replacerManager != null) {
            this.replacerManager.saveReplacerConfigs();
        }
        PsrScheduler.cancelTasks();
    }

    public byte getServerMajorVersion() {
        return this.serverMajorVersion;
    }

    public byte getServerMinorVersion() {
        return this.serverMinorVersion;
    }

    public boolean isSpigot() {
        return this.isSpigot;
    }

    public boolean isPaper() {
        return this.isPaper;
    }

    public boolean isFolia() {
        return this.isFolia;
    }

    public boolean hasPaperComponent() {
        return this.hasPaperComponent;
    }

    @Nonnull
    public ReplacerManager getReplacerManager() {
        return this.replacerManager;
    }

    @Nonnull
    public PsrUserManager getUserManager() {
        return this.userManager;
    }

    @Nonnull
    public PacketListenerManager getPacketListenerManager() {
        return this.packetListenerManager;
    }

    private void initialize() {
        this.enableModify(ConfigManager.LifeCycle.ENABLE);
        this.replacerManager.registerTask();
        CommandHandler commandHandler = new CommandHandler();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(), (Plugin)instance);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PlayerQuitListener(), (Plugin)instance);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PsrInternalListeners(), (Plugin)instance);
        this.packetListenerManager = new PacketListenerManager();
        this.packetListenerManager.initialize();
        commandHandler.initialize();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.userManager.loadUser(player);
            player.updateInventory();
        }
    }

    private boolean checkDepends(String ... depends) {
        boolean missingDepend = false;
        PluginManager pluginManager = Bukkit.getPluginManager();
        for (String depend : depends) {
            if (pluginManager.isPluginEnabled(depend)) continue;
            ProtocolStringReplacer.error(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Initialize.Missing-Dependency", depend));
            missingDepend = true;
        }
        if (missingDepend) {
            pluginManager.disablePlugin((Plugin)instance);
        }
        return missingDepend;
    }

    private void enableModify(ConfigManager.LifeCycle lifeCycle) {
        if (lifeCycle == this.getConfigManager().loadConfigLifeCycle) {
            this.userManager = new PsrUserManager();
            this.replacerManager = new ReplacerManager();
            this.replacerManager.initialize();
            this.hasStarted = true;
        }
    }

    private void loadConfigAndLocale() {
        this.configFile = new File(instance.getDataFolder() + "/Config.yml");
        this.config = new CommentYamlConfiguration();
        if (!this.configFile.exists()) {
            PsrLocalization.initialize(instance);
            return;
        }
        try {
            this.config.load(this.configFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            PsrLocalization.initialize(instance);
            ProtocolStringReplacer.error(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Initialize.Config-Failed-To-Load", new String[0]), e);
            this.config = PsrLocalization.getDefaultLocaledConfig();
            return;
        }
        PsrLocalization.initialize(instance);
    }

    private void checkConfig() {
        try {
            this.configFile = new File(instance.getDataFolder() + "/Config.yml");
            if (!this.configFile.exists()) {
                FileUtils.createFile(this.configFile);
                PsrLocalization.getDefaultLocaledConfig().save(this.configFile);
                this.configFile = new File(instance.getDataFolder() + "/Config.yml");
            }
            this.config = CommentYamlConfiguration.loadConfiguration(this.configFile);
            this.checkConfigsVersion();
            this.saveExampleReplacers();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.configManager = new ConfigManager(instance);
        this.checkConfigKeys();
    }

    private void saveExampleReplacers() throws IOException {
        if (!new File(instance.getDataFolder() + "/Replacers/").exists()) {
            try (InputStream list = PsrLocalization.getLocaledResource("/Example_Replacers.txt");
                 BufferedReader reader = new BufferedReader(new InputStreamReader(list, StandardCharsets.UTF_8));){
                String line = reader.readLine();
                while (line != null) {
                    if (!line.isEmpty()) {
                        if (line.startsWith("$Locale/")) {
                            this.saveResource(line.substring(7));
                        } else {
                            File file = new File(instance.getDataFolder(), line.split("/", 2)[1]);
                            FileUtils.createFile(file);
                            try (InputStream inputStream = this.getResource("Languages/" + line);){
                                Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (Throwable t) {
                                ProtocolStringReplacer.warn("Failed to create example replacer config " + line + ": " + t);
                            }
                        }
                    }
                    line = reader.readLine();
                }
            }
            ProtocolStringReplacer.warn(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Initialize.Created-Example-Replacers", new String[0]));
        }
    }

    private void saveResource(String path) throws IOException {
        File file = new File(instance.getDataFolder(), path);
        FileUtils.createFile(file);
        try (InputStream inputStream = PsrLocalization.getLocaledResource(path);){
            Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void checkConfigKeys() {
        CommentYamlConfiguration configDefault = PsrLocalization.getDefaultLocaledConfig();
        Pattern commentKeyPattern = CommentYamlConfiguration.getCommentKeyPattern();
        boolean edited = false;
        LinkedList<String> comments = new LinkedList<String>();
        int index = 2333;
        for (String key : configDefault.getKeys(true)) {
            if (configDefault.get(key) instanceof ConfigurationSection) continue;
            if (commentKeyPattern.matcher(key).find()) {
                comments.add(key);
                continue;
            }
            if (key.equals("Configs-Version")) {
                comments.clear();
                continue;
            }
            if (!this.config.contains(key)) {
                for (String commentKey : comments) {
                    String[] split = commentKey.split("\\.");
                    StringBuilder stringBuilder = new StringBuilder(commentKey.length() + 4);
                    for (int i = 0; i < split.length - 1; i = (int)((byte)(i + 1))) {
                        stringBuilder.append(split[i]).append(".");
                    }
                    stringBuilder.append(index++).append(split[split.length - 1]);
                    this.config.set(stringBuilder.toString(), configDefault.getString(commentKey));
                }
                this.config.set(key, configDefault.get(key));
                ProtocolStringReplacer.warn(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Initialize.Added-Missing-Config-Key", key));
                edited = true;
            }
            comments.clear();
        }
        if (edited) {
            try {
                this.config.save(this.configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void checkConfigsVersion() {
        HashMap<Short, AbstractUpgradeHandler> upgrades = new HashMap<Short, AbstractUpgradeHandler>();
        for (UpgradeEnum upgrade : UpgradeEnum.values()) {
            try {
                upgrades.put(upgrade.getCurrentVersion(), upgrade.getUpgradeHandler().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        boolean backup = true;
        for (short i = (short)this.config.getInt("Configs-Version", 1); i <= upgrades.size(); i = (short)(i + 1)) {
            if (backup) {
                String path = "/backups/" + System.currentTimeMillis();
                ProtocolStringReplacer.info(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Initialize.Backing-Up-Configs", path.substring(1)));
                this.backupConfigs(path);
                backup = false;
            }
            ProtocolStringReplacer.info(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Initialize.Upgrading-Configs", String.valueOf(i), String.valueOf(i + 1)));
            ((AbstractUpgradeHandler)upgrades.get(i)).upgrade();
        }
    }

    public void backupConfigs(String path) {
        File bkp = new File(instance.getDataFolder(), path);
        bkp.mkdirs();
        try {
            FileUtils.copyDirectoryOrFile(new File(instance.getDataFolder(), "/Locale"), new File(bkp, "/Locale"));
            FileUtils.copyDirectoryOrFile(new File(instance.getDataFolder(), "/Replacers"), new File(bkp, "/Replacers"));
            FileUtils.copyDirectoryOrFile(new File(instance.getDataFolder(), "Config.yml"), new File(bkp, "Config.yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reload(@Nonnull PsrUser user) {
        this.reloading = true;
        Validate.notNull((Object)user, (String)"user cannot be null");
        PsrReloadEvent event = new PsrReloadEvent(PsrReloadEvent.ReloadState.BEFORE, user);
        PsrScheduler.runTask(() -> Bukkit.getServer().getPluginManager().callEvent((Event)event));
        if (event.isCancelled()) {
            this.reloading = false;
            return;
        }
        PsrScheduler.runTaskAsynchronously(() -> {
            try {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Reload.Async-Reloading", new String[0]));
                this.loadConfigAndLocale();
                this.checkConfig();
                this.replacerManager.cancelCleanTask();
                this.replacerManager.saveReplacerConfigs();
                this.replacerManager = new ReplacerManager();
                this.replacerManager.initialize();
                this.replacerManager.registerTask();
                this.packetListenerManager.removeListeners();
                this.packetListenerManager.initialize();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    this.userManager.getUser(player).clearUserItemRestoreCache();
                    player.updateInventory();
                }
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Reload.Complete", new String[0]));
                PsrScheduler.runTask(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new PsrReloadEvent(PsrReloadEvent.ReloadState.FINISH, user)));
            }
            catch (Throwable t) {
                t.printStackTrace();
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Reload.Error-Occurred", new String[0]));
            }
            finally {
                this.reloading = false;
            }
        });
    }
}

