/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer;

import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.api.configuration.CommentYamlConfiguration;
import io.github.rothes.protocolstringreplacer.api.exceptions.MissingInitialResourceException;
import io.github.rothes.protocolstringreplacer.util.ColorUtils;
import io.github.rothes.protocolstringreplacer.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public class PsrLocalization {
    private static ProtocolStringReplacer plugin = null;
    private static String systemLocale = null;
    private static String locale = null;
    private static HashMap<String, String> localedMessages = null;
    private static String[] replaceHolders = new String[10];

    public static void initialize(@Nonnull ProtocolStringReplacer plugin) {
        PsrLocalization.plugin = plugin;
        systemLocale = System.getProperty("user.language", Locale.getDefault().getLanguage());
        systemLocale = systemLocale + '-';
        systemLocale = systemLocale + System.getProperty("user.country", Locale.getDefault().getCountry());
        locale = plugin.getConfig().getString("Options.Locale", systemLocale);
        localedMessages = new HashMap();
        PsrLocalization.loadLocale();
        for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
            PsrLocalization.replaceHolders[i] = "%" + i + '%';
        }
    }

    public static String getLocale() {
        return locale;
    }

    @NotNull
    public static String getLocaledMessage(@Nonnull String key, String ... replacements) {
        Validate.notNull((Object)key, (String)"Key cannot be null");
        Validate.notNull((Object)replacements, (String)"Replacements Array cannot be null");
        String result = localedMessages.getOrDefault(key, "\u00a7cMissing localization key: " + key);
        byte length = (byte)replacements.length;
        return length > 0 ? StringUtils.replaceEach((String)result, (String[])Arrays.copyOf(replaceHolders, (int)length), (String[])replacements) : result;
    }

    @NotNull
    public static String getPrefixedLocaledMessage(@Nonnull String key, String ... replacements) {
        Validate.notNull((Object)key, (String)"Key cannot be null");
        Validate.notNull((Object)replacements, (String)"Replacements Array cannot be null");
        return PsrLocalization.getLocaledMessage("Sender.Prefix", new String[0]) + PsrLocalization.getLocaledMessage(key, replacements);
    }

    @NotNull
    public static CommentYamlConfiguration getDefaultLocaledConfig() {
        InputStream resource = PsrLocalization.getLocaledResource("/Configs/Config.yml");
        return CommentYamlConfiguration.loadConfiguration(new InputStreamReader(resource, StandardCharsets.UTF_8));
    }

    @NotNull
    public static CommentYamlConfiguration getDefaultLocale() {
        InputStream resource = PsrLocalization.getLocaledResource("/Locales/Locale.yml");
        return CommentYamlConfiguration.loadConfiguration(new InputStreamReader(resource, StandardCharsets.UTF_8));
    }

    @NotNull
    public static InputStream getLocaledResource(@NotNull String file) {
        InputStream resource = plugin.getResource("Languages/" + locale + file);
        if (resource == null && (resource = plugin.getResource("Languages/" + systemLocale + file)) == null && (resource = plugin.getResource("Languages/en-US" + file)) == null) {
            throw new MissingInitialResourceException("Languages/en-US" + file);
        }
        return resource;
    }

    private static void loadLocale() {
        CommentYamlConfiguration locale;
        File localeFile = new File(plugin.getDataFolder() + "/Locale/" + PsrLocalization.locale + ".yml");
        if (localeFile.exists()) {
            PsrLocalization.checkLocaleKeys(localeFile);
            locale = CommentYamlConfiguration.loadConfiguration(localeFile);
        } else {
            locale = PsrLocalization.getDefaultLocale();
            FileUtils.createFile(localeFile);
            try {
                locale.save(localeFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Pattern commentKeyPattern = CommentYamlConfiguration.getCommentKeyPattern();
        for (String key : locale.getKeys(true)) {
            if (commentKeyPattern.matcher(key).find()) continue;
            localedMessages.put(key, ColorUtils.getColored(locale.getString(key)));
        }
    }

    private static void checkLocaleKeys(@NotNull File localeFile) {
        CommentYamlConfiguration defaultLocale = PsrLocalization.getDefaultLocale();
        CommentYamlConfiguration locale = CommentYamlConfiguration.loadConfiguration(localeFile);
        boolean checked = false;
        Pattern commentKeyPattern = CommentYamlConfiguration.getCommentKeyPattern();
        for (String key : defaultLocale.getKeys(true)) {
            if (commentKeyPattern.matcher(key).find() || locale.contains(key)) continue;
            locale.set(key, defaultLocale.get(key));
            checked = true;
        }
        if (checked) {
            try {
                locale.save(localeFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

