/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.api.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.DumperOptions;

public class CommentYamlConfiguration
extends YamlConfiguration {
    protected static Pattern commentKeyPattern = Pattern.compile("([0-9]+)\u3a75\u904c\u36b3\u8fd9\u662f\u6ce8\u91ca([\u662f\u5426])");
    protected static Pattern commentPattern = Pattern.compile("^( *)([0-9]+)\u3a75\u904c\u36b3\u8fd9\u662f\u6ce8\u91ca([\u662f\u5426]): '([0-9]+)\\| ");
    protected static final Pattern startedSpacePattern = Pattern.compile("^( +)");
    protected static final Pattern endedSpacePattern = Pattern.compile("( +)$");
    protected static final String EMPTY_LINE = "#\u3a75\u904c\u36b3 - This is empty line";

    public static Pattern getCommentKeyPattern() {
        return commentKeyPattern;
    }

    public CommentYamlConfiguration() {
        this.options().copyHeader(false);
        try {
            Field field;
            try {
                field = YamlConfiguration.class.getDeclaredField("yamlOptions");
            }
            catch (NoSuchFieldException e) {
                field = YamlConfiguration.class.getDeclaredField("yamlDumperOptions");
            }
            field.setAccessible(true);
            DumperOptions options = (DumperOptions)field.get((Object)this);
            field.setAccessible(false);
            options.setWidth(10240);
            options.setSplitLines(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public void loadFromString(@Nonnull String contents) throws InvalidConfigurationException {
        Validate.notNull((Object)contents, (String)"Contents cannot be null");
        String[] lines = contents.split("\n");
        StringBuilder stringBuilder = new StringBuilder();
        short commentIndex = 0;
        LinkedList<Comment> commentsToAdd = new LinkedList<Comment>();
        for (String line : lines) {
            String startedSpace = CommentYamlConfiguration.getStartedSpace(line);
            int cursor = startedSpace.length();
            char quoteChar = '\n';
            boolean isPlainComment = true;
            boolean isInQuote = false;
            boolean isKey = false;
            boolean isList = false;
            boolean foundComment = false;
            if (cursor == line.length()) {
                line = line + EMPTY_LINE;
            } else if (line.charAt(cursor) == '-') {
                isList = true;
            }
            while (cursor < line.length()) {
                char charAtCursor = line.charAt(cursor);
                if (isInQuote) {
                    if (charAtCursor == quoteChar) {
                        if (line.length() > cursor + 1 && line.charAt(cursor + 1) == charAtCursor) {
                            ++cursor;
                        } else {
                            isInQuote = false;
                        }
                    }
                } else {
                    if (isPlainComment && " #".indexOf(charAtCursor) == -1) {
                        isPlainComment = false;
                    }
                    if (charAtCursor == '\'' || charAtCursor == '\"') {
                        quoteChar = charAtCursor;
                        isInQuote = true;
                    } else if (charAtCursor == ':') {
                        isKey = true;
                    } else if (charAtCursor == '#' && (cursor == 0 || " '\":".indexOf(line.charAt(cursor - 1)) != -1)) {
                        foundComment = true;
                        break;
                    }
                }
                ++cursor;
            }
            if (isKey && !isList) {
                commentIndex = CommentYamlConfiguration.addComments(CommentYamlConfiguration.getStartedSpace(line), commentsToAdd, stringBuilder, commentIndex);
            }
            if (foundComment) {
                commentsToAdd.add(0, new Comment(CommentYamlConfiguration.getEndedSpace(line.substring(0, cursor)) + line.substring(cursor).replace("'", "''"), isPlainComment));
            }
            stringBuilder.append(line).append("\n");
            for (Comment comment : commentsToAdd) {
                comment.passedLines++;
            }
        }
        if (!commentsToAdd.isEmpty()) {
            CommentYamlConfiguration.addComments("", commentsToAdd, stringBuilder, commentIndex);
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        super.loadFromString(stringBuilder.toString());
    }

    @Nonnull
    public String saveToString() {
        String contents = super.saveToString();
        String[] lines = contents.split("\n");
        StringBuilder stringBuilder = new StringBuilder();
        for (String line : lines) {
            Matcher matcher = commentPattern.matcher(line);
            if (matcher.find()) {
                int passedLines = Short.parseShort(matcher.group(4));
                int index = stringBuilder.length() - 1;
                for (int i = 0; i < passedLines; ++i) {
                    --index;
                    index = stringBuilder.lastIndexOf("\n", index);
                }
                if (index == -1) {
                    index = 0;
                    stringBuilder.insert(index, '\n');
                }
                stringBuilder.insert(index, StringUtils.replace((String)line.substring(matcher.group(0).length(), line.length() - 1), (String)"''", (String)"'"));
                if (index == 0 || !matcher.group(3).equals("\u662f")) continue;
                stringBuilder.insert(index, '\n');
                continue;
            }
            stringBuilder.append(line).append("\n");
        }
        return stringBuilder.toString().replace(EMPTY_LINE, "");
    }

    @Nonnull
    public static CommentYamlConfiguration loadConfiguration(@Nonnull File file) {
        Validate.notNull((Object)file, (String)"File cannot be null");
        CommentYamlConfiguration config = new CommentYamlConfiguration();
        try {
            config.load(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException | InvalidConfigurationException var4) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load " + file, var4);
        }
        return config;
    }

    @Nonnull
    public static CommentYamlConfiguration loadConfiguration(@Nonnull Reader reader) {
        Validate.notNull((Object)reader, (String)"Stream cannot be null");
        CommentYamlConfiguration config = new CommentYamlConfiguration();
        try {
            config.load(reader);
        }
        catch (IOException | InvalidConfigurationException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load configuration from stream", ex);
        }
        return config;
    }

    @NotNull
    protected String parseHeader(@NotNull String input) {
        return "";
    }

    protected static String getStartedSpace(@Nonnull String string) {
        Validate.notNull((Object)string, (String)"String cannot be null");
        Matcher matcher = startedSpacePattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    protected static String getEndedSpace(@NotNull String string) {
        Validate.notNull((Object)string, (String)"String cannot be null");
        Matcher matcher = endedSpacePattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    protected static short addComments(@NotNull String space, @NotNull List<Comment> commentsToAdd, @NotNull StringBuilder stringBuilder, short commentIndex) {
        short resultIndex = commentIndex;
        for (Comment comment : commentsToAdd) {
            short s = resultIndex;
            resultIndex = (short)(resultIndex + 1);
            stringBuilder.append(space).append(s).append("\u3a75\u904c\u36b3\u8fd9\u662f\u6ce8\u91ca");
            if (comment.plainComment) {
                stringBuilder.append("\u662f");
            } else {
                stringBuilder.append("\u5426");
            }
            stringBuilder.append(": '").append(comment.passedLines).append("| ").append(comment.commentString).append("'\n");
        }
        commentsToAdd.clear();
        return resultIndex;
    }

    private static class Comment {
        private int passedLines = -1;
        private String commentString;
        private boolean plainComment;

        private Comment(String commentString, boolean isplainComment) {
            this.commentString = commentString;
            this.plainComment = isplainComment;
        }
    }
}

