/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.api.user;

import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PsrUserManager {
    private final HashMap<UUID, PsrUser> users = new HashMap();
    private final PsrUser console = new PsrUser((CommandSender)Bukkit.getConsoleSender());

    public PsrUser getUser(@NotNull UUID uuid) {
        return this.users.getOrDefault(uuid, this.loadUser(uuid));
    }

    @Nonnull
    public PsrUser getUser(@NotNull Player player) {
        return this.users.getOrDefault(player.getUniqueId(), this.loadUser(player));
    }

    @Nonnull
    public PsrUser getUser(@NotNull CommandSender sender) {
        return sender instanceof Player ? this.getUser((Player)sender) : this.console;
    }

    public PsrUser getConsoleUser() {
        return this.console;
    }

    public PsrUser loadUser(@NotNull UUID uuid) {
        return this.users.putIfAbsent(uuid, new PsrUser(uuid));
    }

    public PsrUser loadUser(@NotNull Player player) {
        return this.users.putIfAbsent(player.getUniqueId(), new PsrUser(player));
    }

    public void unloadUser(@NotNull UUID uuid) {
        this.users.remove(uuid);
    }

    public void unloadUser(@NotNull Player player) {
        this.unloadUser(player.getUniqueId());
    }
}

