/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.command.subcommands.editchildren;

import io.github.rothes.protocolstringreplacer.PsrLocalization;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.command.SubCommand;
import io.github.rothes.protocolstringreplacer.replacer.FileReplacerConfig;
import io.github.rothes.protocolstringreplacer.replacer.ReplaceMode;
import io.github.rothes.protocolstringreplacer.util.ArgUtils;
import io.github.rothes.protocolstringreplacer.util.ColorUtils;
import io.github.rothes.protocolstringreplacer.util.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class Block
extends SubCommand {
    public Block() {
        super("block", "protocolstringreplacer.command.edit", PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Block.Description", new String[0]));
    }

    @Override
    public void onExecute(@Nonnull PsrUser user, @NotNull String[] args2) {
        if (user.getEditorReplacerConfig() == null) {
            user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.Replace.Not-Selected-Replacer-Config", new String[0]));
            return;
        }
        if (args2.length > 2) {
            if ("list".equalsIgnoreCase(args2[2])) {
                this.listCommand(user, args2);
                return;
            }
            if ("set".equalsIgnoreCase(args2[2])) {
                this.setCommand(user, args2);
                return;
            }
            if ("add".equalsIgnoreCase(args2[2])) {
                this.addCommand(user, args2);
                return;
            }
            if ("remove".equalsIgnoreCase(args2[2])) {
                this.removeCommand(user, args2);
                return;
            }
        }
        this.sendHelp(user);
    }

    private void listCommand(@Nonnull PsrUser user, @NotNull String[] args2) {
        if (args2.length < 6 && args2.length > 3) {
            int page = 1;
            ReplaceMode replaceMode = this.getReplacesMode(args2[3]);
            if (replaceMode == null) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Variables.Match-Mode.Messages.Invalid-Mode", args2[3]));
                return;
            }
            List<Object> blocks = user.getEditorReplacerConfig().getBlocks(replaceMode);
            int totalPage = (int)Math.ceil((float)blocks.size() / 10.0f);
            if (args2.length == 5) {
                if (StringUtils.isNumeric((String)args2[4])) {
                    page = Integer.parseInt(args2[4]);
                } else {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Not-A-Positive-Integer", args2[4]));
                    return;
                }
            }
            if (page > totalPage) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Page-Exceed", String.valueOf(totalPage)));
                return;
            }
            if (page < 1) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Page-Low", new String[0]));
                return;
            }
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Block.Children.List.Result.Header", new String[0]));
            for (int i = (page - 1) * 10; i < blocks.size() && i < page * 10; ++i) {
                String block = blocks.get(i).toString();
                user.sendFilteredMessage(new ComponentBuilder(PsrLocalization.getLocaledMessage("Utils.Message.Buttons.Add", new String[0])).event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/psr edit block add " + replaceMode.getNode() + " " + i + " <" + PsrLocalization.getLocaledMessage("Variables.Block-Text", new String[0]) + ">")).append(PsrLocalization.getLocaledMessage("Utils.Message.Buttons.Edit", new String[0])).event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/psr edit block set " + replaceMode.getNode() + " " + i + " " + ArgUtils.formatWithQuotes(ColorUtils.restoreColored(block)))).append(PsrLocalization.getLocaledMessage("Utils.Message.Buttons.Delete", new String[0])).event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/psr edit block remove " + replaceMode.getNode() + " " + i)).append(" " + i + ". ").reset().append(ColorUtils.showColorCodes(block)).color(ChatColor.AQUA).create());
            }
            MessageUtils.sendPageButtons(user, "/psr edit block list " + replaceMode.getNode() + " ", page, totalPage);
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Block.Children.List.Result.Footer", new String[0]));
        } else {
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Block.Children.List.Detailed-Help", new String[0]));
        }
    }

    private void setCommand(@Nonnull PsrUser user, @NotNull String[] args2) {
        if (args2.length > 4) {
            ReplaceMode replaceMode = this.getReplacesMode(args2[3]);
            if (replaceMode == null) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Variables.Match-Mode.Messages.Invalid-Mode", args2[3]));
                return;
            }
            if (!StringUtils.isNumeric((String)args2[4])) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Not-A-Positive-Integer", args2[4]));
                return;
            }
            int index = Integer.parseInt(args2[4]);
            FileReplacerConfig editorReplacerConfig = user.getEditorReplacerConfig();
            if (index < 0) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Index-Low", new String[0]));
                return;
            }
            if (args2.length == 6) {
                if (index >= editorReplacerConfig.getBlocks(replaceMode).size()) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Index-Exceed", String.valueOf(editorReplacerConfig.getBlocks(replaceMode).size())));
                    return;
                }
                String block = ColorUtils.getColored(args2[5]);
                editorReplacerConfig.setBlock(index, block, replaceMode);
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.Block.Children.Set.Successfully-Set-Block", args2[4], ColorUtils.showColorCodes(block)));
                return;
            }
        }
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Block.Children.Set.Detailed-Help", new String[0]));
    }

    private void addCommand(@Nonnull PsrUser user, @NotNull String[] args2) {
        if (args2.length > 3) {
            ReplaceMode replaceMode = this.getReplacesMode(args2[3]);
            if (replaceMode == null) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Variables.Match-Mode.Messages.Invalid-Mode", args2[3]));
                return;
            }
            if (args2.length == 5) {
                String block = ColorUtils.getColored(args2[4]);
                FileReplacerConfig editorReplacerConfig = user.getEditorReplacerConfig();
                editorReplacerConfig.addBlock(block, replaceMode);
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.Block.Children.Add.Successfully-Added-Block", String.valueOf(editorReplacerConfig.getBlocks(replaceMode).size()), ColorUtils.showColorCodes(block)));
            } else if (args2.length == 6) {
                if (!StringUtils.isNumeric((String)args2[4])) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Not-A-Positive-Integer", args2[4]));
                    return;
                }
                int index = Integer.parseInt(args2[4]);
                if (index < 0) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Index-Low", new String[0]));
                    return;
                }
                String block = ColorUtils.getColored(args2[5]);
                user.getEditorReplacerConfig().addBlock(index, block, replaceMode);
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.Block.Children.Add.Successfully-Added-Block", String.valueOf(index), ColorUtils.showColorCodes(block)));
            }
        } else {
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Block.Children.Add.Detailed-Help", new String[0]));
        }
    }

    private void removeCommand(@Nonnull PsrUser user, @NotNull String[] args2) {
        if (args2.length > 3) {
            ReplaceMode replaceMode = this.getReplacesMode(args2[3]);
            if (replaceMode == null) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Variables.Match-Mode.Messages.Invalid-Mode", args2[3]));
                return;
            }
            if (args2.length == 5) {
                if (!StringUtils.isNumeric((String)args2[4])) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Not-A-Positive-Integer", args2[4]));
                    return;
                }
                int index = Integer.parseInt(args2[4]);
                if (index < 0) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Index-Low", new String[0]));
                    return;
                }
                FileReplacerConfig editorReplacerConfig = user.getEditorReplacerConfig();
                if (index > editorReplacerConfig.getBlocks(replaceMode).size()) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Index-Exceed", String.valueOf(editorReplacerConfig.getBlocks(replaceMode).size())));
                    return;
                }
                editorReplacerConfig.removeBlock(index, replaceMode);
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.Block.Children.Remove.Sucessfully-Removed-Block", String.valueOf(index)));
            }
        } else {
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.Remove.Detailed-Help", new String[0]));
        }
    }

    @Override
    public List<String> onTab(@NotNull PsrUser user, @NotNull String[] args2) {
        List<String> list = new ArrayList<String>();
        if (args2.length == 3) {
            list = Arrays.asList("help", "list", "set", "add", "remove");
        } else if (args2.length == 4 && (args2[2].equalsIgnoreCase("list") || args2[2].equalsIgnoreCase("set") || args2[2].equalsIgnoreCase("add") || args2[2].equalsIgnoreCase("remove"))) {
            list.add("<" + PsrLocalization.getLocaledMessage("Variables.Match-Mode.Name", new String[0]) + ">");
            for (ReplaceMode replaceMode : ReplaceMode.values()) {
                list.add(replaceMode.getNode().toLowerCase(Locale.ENGLISH));
            }
        } else if (args2.length == 5) {
            if (args2[2].equalsIgnoreCase("list")) {
                list.add("[" + PsrLocalization.getLocaledMessage("Variables.Page.Name", new String[0]) + "]");
            } else if (args2[2].equalsIgnoreCase("set")) {
                list.add("<" + PsrLocalization.getLocaledMessage("Variables.Index.Name", new String[0]) + ">");
            } else if (args2[2].equalsIgnoreCase("add")) {
                list.add("[" + PsrLocalization.getLocaledMessage("Variables.Index.Name", new String[0]) + "]|<" + PsrLocalization.getLocaledMessage("Variables.Block-Text.Name", new String[0]) + ">");
            } else if (args2[2].equalsIgnoreCase("remove")) {
                list.add("<" + PsrLocalization.getLocaledMessage("Variables.Index.Name", new String[0]) + ">");
            }
        } else if (args2.length == 6) {
            if (args2[2].equalsIgnoreCase("set")) {
                list.add("<" + PsrLocalization.getLocaledMessage("Variables.Block-Text.Name", new String[0]) + ">");
            } else if (args2[2].equalsIgnoreCase("add") && StringUtils.isNumeric((String)args2[3])) {
                list.add("<" + PsrLocalization.getLocaledMessage("Variables.Block-Text.Name", new String[0]) + ">");
            }
        }
        return list;
    }

    @Override
    public void sendHelp(@Nonnull PsrUser user) {
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Block.Help.Header", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Block.Children.List.Simple-Help", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Block.Children.Set.Simple-Help", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Block.Children.Add.Simple-Help", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Block.Children.Remove.Simple-Help", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Block.Help.Footer", new String[0]));
    }

    private ReplaceMode getReplacesMode(@NotNull String string) {
        for (ReplaceMode type : ReplaceMode.values()) {
            if (!type.getNode().equalsIgnoreCase(string)) continue;
            return type;
        }
        return null;
    }
}

