/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.command.subcommands.editchildren;

import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.PsrLocalization;
import io.github.rothes.protocolstringreplacer.api.configuration.CommentYamlConfiguration;
import io.github.rothes.protocolstringreplacer.api.replacer.ReplacerConfig;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.command.SubCommand;
import io.github.rothes.protocolstringreplacer.replacer.FileReplacerConfig;
import io.github.rothes.protocolstringreplacer.replacer.ListenType;
import io.github.rothes.protocolstringreplacer.util.ArgUtils;
import io.github.rothes.protocolstringreplacer.util.FileUtils;
import io.github.rothes.protocolstringreplacer.util.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class File
extends SubCommand {
    private static Pattern fileNamePrefix = Pattern.compile("(\")?Replacers/");

    public File() {
        super("file", "protocolstringreplacer.command.edit", PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Description", new String[0]));
    }

    @Override
    public void onExecute(@Nonnull PsrUser user, @NotNull String[] args2) {
        if (args2.length > 2) {
            if ("list".equalsIgnoreCase(args2[2])) {
                this.listCommand(user, args2);
                return;
            }
            if ("select".equalsIgnoreCase(args2[2])) {
                this.selectCommand(user, args2);
                return;
            }
            if ("create".equalsIgnoreCase(args2[2])) {
                this.createCommand(user, args2);
                return;
            }
            if ("delete".equalsIgnoreCase(args2[2])) {
                this.deleteCommand(user, args2);
                return;
            }
        }
        this.sendHelp(user);
    }

    private void listCommand(@Nonnull PsrUser user, @NotNull String[] args2) {
        if (args2.length < 5) {
            int page = 1;
            ArrayList<FileReplacerConfig> replacerConfigList = new ArrayList<FileReplacerConfig>();
            for (ReplacerConfig replacerConfig : ProtocolStringReplacer.getInstance().getReplacerManager().getReplacerConfigList()) {
                if (!(replacerConfig instanceof FileReplacerConfig)) continue;
                replacerConfigList.add((FileReplacerConfig)replacerConfig);
            }
            int totalPage = (int)Math.ceil((float)replacerConfigList.size() / 10.0f);
            if (args2.length == 4) {
                if (StringUtils.isNumeric((String)args2[3])) {
                    page = Integer.parseInt(args2[3]);
                } else {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Not-A-Positive-Integer", args2[3]));
                    return;
                }
            }
            if (page > totalPage) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Page-Exceed", String.valueOf(totalPage)));
                return;
            }
            if (page < 1) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Page-Low", new String[0]));
                return;
            }
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Children.List.Result.Header", new String[0]));
            for (int i = (page - 1) * 10; i < replacerConfigList.size() && i < page * 10; ++i) {
                ReplacerConfig replacerConfig = (ReplacerConfig)replacerConfigList.get(i);
                StringBuilder listens = new StringBuilder();
                for (ListenType listenType : replacerConfig.getListenTypeList()) {
                    listens.append("\n\u00a77- \u00a7b").append(listenType.getName());
                }
                user.sendFilteredMessage(new ComponentBuilder(PsrLocalization.getLocaledMessage("Utils.Message.Buttons.Select", new String[0])).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/psr edit file select " + i)).append(" " + i + ". ").reset().color(ChatColor.WHITE).append(replacerConfig.getRelativePath()).color(ChatColor.AQUA).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Children.List.Result.Replacer-Info", replacerConfig.getRelativePath(), replacerConfig.isEnabled() ? PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Children.List.Result.Enabled", new String[0]) : PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Children.List.Result.Not-Enabled", new String[0]), String.valueOf(replacerConfig.getPriority()), replacerConfig.getVersion() == null ? PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Children.List.Result.Not-Configured", new String[0]) : replacerConfig.getVersion(), replacerConfig.getAuthor() == null ? PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Children.List.Result.Not-Configured", new String[0]) : replacerConfig.getAuthor(), PsrLocalization.getLocaledMessage(replacerConfig.getMatchMode().getLocaleKey(), new String[0]), listens.length() == 0 ? PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Children.List.Result.Not-Configured", new String[0]) : listens.toString())))).create());
            }
            MessageUtils.sendPageButtons(user, "/psr edit file list ", page, totalPage);
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Children.List.Result.Footer", new String[0]));
        } else {
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Children.List.Detailed-Help", new String[0]));
        }
    }

    private void selectCommand(@Nonnull PsrUser user, @NotNull String[] args2) {
        if (args2.length == 4) {
            FileReplacerConfig replacerConfig = this.getSpecifiedFileReplacerConfig(args2[3]);
            if (replacerConfig != null) {
                user.setEditorReplacerConfig(replacerConfig);
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.File.Children.Select.Replacer-Config-Selected", replacerConfig.getRelativePath()));
            } else {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.File.Children.Cannot-Find-Replacer-Config", args2[3]));
            }
        } else {
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Children.Select.Detailed-Help", new String[0]));
        }
    }

    private void createCommand(@Nonnull PsrUser user, @NotNull String[] args2) {
        if (args2.length == 4) {
            if (args2[3].startsWith("Replacers/")) {
                if (FileUtils.checkFileSuffix(args2[3], ".yml")) {
                    java.io.File file = new java.io.File(ProtocolStringReplacer.getInstance().getDataFolder() + "/" + args2[3]);
                    if (FileUtils.createFile(file)) {
                        CommentYamlConfiguration configuration = CommentYamlConfiguration.loadConfiguration(file);
                        FileReplacerConfig replacerConfig = new FileReplacerConfig(file, configuration);
                        replacerConfig.saveConfig();
                        ProtocolStringReplacer.getInstance().getReplacerManager().addReplacerConfig(replacerConfig);
                        user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.File.Children.Create.File-Successfully-Created", replacerConfig.getRelativePath()));
                    } else {
                        user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.File.Children.Create.File-Create-Failed", args2[3]));
                    }
                } else {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.File.Children.Create.Not-Yml-File", new String[0]));
                }
            } else {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.File.Children.Create.Not-In-Replacers-Folder", new String[0]));
            }
        } else {
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Children.Create.Detailed-Help", new String[0]));
        }
    }

    private void deleteCommand(@Nonnull PsrUser user, @NotNull String[] args2) {
        if (args2.length == 4) {
            FileReplacerConfig replacerConfig = this.getSpecifiedFileReplacerConfig(args2[3]);
            if (replacerConfig != null) {
                if (user.isConfirmed(args2)) {
                    replacerConfig.getFile().delete();
                    ProtocolStringReplacer.getInstance().getReplacerManager().getReplacerConfigList().remove(replacerConfig);
                    user.clearCommandToConfirm();
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.File.Children.Delete.File-Successfully-Deleted", replacerConfig.getRelativePath()));
                } else {
                    user.setCommandToConfirm(args2);
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.File.Children.Delete.Delete-Need-To-Confirm", replacerConfig.getRelativePath()));
                }
            } else {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.File.Children.Cannot-Find-Replacer-Config", args2[3]));
            }
        } else {
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Children.Delete.Detailed-Help", new String[0]));
        }
    }

    @Override
    public List<String> onTab(@NotNull PsrUser user, @NotNull String[] args2) {
        List<String> list = new ArrayList<String>();
        if (args2.length == 3) {
            list = Arrays.asList("help", "list", "select", "create", "delete");
        } else if (args2.length == 4) {
            if (args2[2].equalsIgnoreCase("list")) {
                list.add("[" + PsrLocalization.getLocaledMessage("Variables.Page.Name", new String[0]) + "]");
            } else if (args2[2].equalsIgnoreCase("delete") || args2[2].equalsIgnoreCase("select")) {
                list.add("<" + PsrLocalization.getLocaledMessage("Variables.Replacer-Config.Name", new String[0]) + "|" + PsrLocalization.getLocaledMessage("Variables.Index.Name", new String[0]) + ">");
                for (ReplacerConfig replacerConfig : ProtocolStringReplacer.getInstance().getReplacerManager().getReplacerConfigList()) {
                    if (!(replacerConfig instanceof FileReplacerConfig)) continue;
                    list.add(ArgUtils.formatWithQuotes(replacerConfig.getRelativePath()));
                }
            } else if (args2[2].equalsIgnoreCase("create")) {
                String arg = args2[3];
                Matcher matcher = fileNamePrefix.matcher(arg);
                if (matcher.find()) {
                    int i;
                    int length = arg.length();
                    String subfix = ".yml\"";
                    for (i = 5; i > 0 && !arg.substring(length - i).equalsIgnoreCase(subfix.substring(0, i)); --i) {
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(arg, 0, arg.length() - i).append(subfix);
                    if (matcher.group(1) == null) {
                        stringBuilder.insert(0, '\"');
                    }
                    list.add(stringBuilder.toString());
                } else {
                    list.add("\"Replacers/");
                }
            }
        }
        return list;
    }

    @Override
    public void sendHelp(@Nonnull PsrUser user) {
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Help.Header", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Children.List.Simple-Help", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Children.Select.Simple-Help", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Children.Create.Simple-Help", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Children.Delete.Simple-Help", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.File.Help.Footer", new String[0]));
    }

    @Nullable
    private FileReplacerConfig getSpecifiedFileReplacerConfig(@NotNull String string) {
        ArrayList<FileReplacerConfig> replacerConfigList = new ArrayList<FileReplacerConfig>();
        for (ReplacerConfig replacerConfig : ProtocolStringReplacer.getInstance().getReplacerManager().getReplacerConfigList()) {
            if (!(replacerConfig instanceof FileReplacerConfig)) continue;
            replacerConfigList.add((FileReplacerConfig)replacerConfig);
        }
        for (FileReplacerConfig fileReplacerConfig : replacerConfigList) {
            if (!fileReplacerConfig.getRelativePath().equals(string)) continue;
            return fileReplacerConfig;
        }
        if (StringUtils.isNumeric((String)string)) {
            int index = Integer.parseInt(string);
            if (replacerConfigList.size() > index) {
                return (FileReplacerConfig)replacerConfigList.get(index);
            }
        }
        return null;
    }
}

