/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.console;

import io.github.rothes.protocolstringreplacer.ConfigManager;
import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.api.replacer.ReplacerConfig;
import io.github.rothes.protocolstringreplacer.console.ConsoleReplaceManager;
import io.github.rothes.protocolstringreplacer.replacer.ReplacerManager;
import io.github.rothes.protocolstringreplacer.replacer.containers.SimpleTextContainer;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;

@ConverterKeys(value={"PsrFormatting"})
@Plugin(name="PsrFormatting", category="Converter")
public class PsrLogEventPatternConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;
    private final boolean removeAnsi;

    protected PsrLogEventPatternConverter(List<PatternFormatter> formatters, boolean removeAnsi) {
        super("PsrFormatting", null);
        this.formatters = formatters;
        this.removeAnsi = removeAnsi;
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        block8: {
            ProtocolStringReplacer plugin;
            block7: {
                for (PatternFormatter formatter : this.formatters) {
                    formatter.format(event, toAppendTo);
                }
                plugin = ProtocolStringReplacer.getInstance();
                if (plugin.hasStarted()) {
                    SimpleTextContainer container = new SimpleTextContainer(toAppendTo.toString());
                    container.createTexts(container);
                    ReplacerManager replacerManager = plugin.getReplacerManager();
                    List<ReplacerConfig> replacers = replacerManager.getAcceptedReplacers(plugin.getUserManager().getConsoleUser(), ConsoleReplaceManager.getFilter());
                    if (replacerManager.isTextBlocked(container, replacers)) {
                        toAppendTo.delete(0, toAppendTo.length());
                        return;
                    }
                    replacerManager.replaceContainerTexts(container, replacers);
                    if (plugin.getConfigManager().consolePlaceholder) {
                        replacerManager.setPapi(plugin.getUserManager().getConsoleUser(), container.getTexts());
                    }
                    toAppendTo.delete(0, toAppendTo.length());
                    toAppendTo.append(container.getResult());
                }
                if (!this.removeAnsi) break block7;
                int m = -1;
                for (int i = toAppendTo.length() - 1; i >= 0; --i) {
                    char c = toAppendTo.charAt(i);
                    if (c == 'm') {
                        m = i;
                        continue;
                    }
                    if (c != '\u001b') continue;
                    toAppendTo.delete(i, m + 1);
                }
                break block8;
            }
            ConfigManager configManager = plugin.getConfigManager();
            if (configManager == null || !configManager.resetConsoleColor) break block8;
            for (int i = toAppendTo.length() - 1; i >= 0; --i) {
                if (toAppendTo.charAt(i) != '\n') continue;
                toAppendTo.insert(i, "\u001b[0m");
            }
        }
    }

    public boolean handlesThrowable() {
        for (PatternFormatter formatter : this.formatters) {
            if (!formatter.handlesThrowable()) continue;
            return true;
        }
        return false;
    }

    public static PsrLogEventPatternConverter newInstance(Configuration config, String[] options) {
        if (options.length < 1 || options.length > 2) {
            LOGGER.error("Incorrect number of options. Expected at least 1, max 2 received " + options.length);
            return null;
        }
        String pattern = ConsoleReplaceManager.getPatterns().get(Short.parseShort(options[0]));
        boolean removeAnsi = options.length == 2 && "removeAnsi".equals(options[1]);
        return new PsrLogEventPatternConverter(PatternLayout.createPatternParser((Configuration)config).parse(pattern, true, removeAnsi), removeAnsi);
    }
}

