/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.packetlistener.server;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.PsrLocalization;
import io.github.rothes.protocolstringreplacer.api.capture.CaptureInfoImpl;
import io.github.rothes.protocolstringreplacer.api.exceptions.JsonSyntaxException;
import io.github.rothes.protocolstringreplacer.api.replacer.ReplacerConfig;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.packetlistener.BasePacketListener;
import io.github.rothes.protocolstringreplacer.replacer.ListenType;
import io.github.rothes.protocolstringreplacer.replacer.ReplaceMode;
import io.github.rothes.protocolstringreplacer.replacer.ReplacerManager;
import io.github.rothes.protocolstringreplacer.replacer.containers.ChatJsonContainer;
import io.github.rothes.protocolstringreplacer.replacer.containers.ItemStackContainer;
import io.github.rothes.protocolstringreplacer.replacer.containers.Replaceable;
import io.github.rothes.protocolstringreplacer.replacer.containers.SimpleTextContainer;
import io.github.rothes.protocolstringreplacer.util.SpigotUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class BaseServerPacketListener
extends BasePacketListener {
    protected static final ProtocolStringReplacer plugin = ProtocolStringReplacer.getInstance();
    protected final BiPredicate<ReplacerConfig, PsrUser> filter;
    protected final ListenType listenType;
    private static final String DIRECT_NOT_REPLACED = "PSR Direct Not Replaced - \u8510\u9b6c\u9d2f\u92c6\u98bd\u6f1a\u94fc";

    protected BaseServerPacketListener(PacketType packetType, ListenType listenType) {
        super(packetType);
        this.listenType = listenType;
        this.filter = (replacerConfig, user) -> this.containType((ReplacerConfig)replacerConfig) && this.checkFilter((PsrUser)user, (ReplacerConfig)replacerConfig);
        this.packetAdapter = new PacketAdapter((Plugin)ProtocolStringReplacer.getInstance(), ProtocolStringReplacer.getInstance().getPacketListenerManager().getListenerPriority(), new PacketType[]{packetType}){

            public void onPacketSending(PacketEvent packetEvent) {
                boolean readOnly = packetEvent.isReadOnly();
                if (!BaseServerPacketListener.this.canWrite(packetEvent)) {
                    return;
                }
                BaseServerPacketListener.this.process(packetEvent);
                if (readOnly) {
                    packetEvent.setReadOnly(readOnly);
                }
            }
        };
    }

    @Override
    protected void register() {
        boolean enabled = ProtocolStringReplacer.getInstance().getConfig().getBoolean("Options.Features.Packet-Listener.Listen-Type-Enabled." + this.listenType.getName(), false);
        if (enabled) {
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.packetAdapter);
        }
    }

    protected final boolean containType(ReplacerConfig replacerConfig) {
        return replacerConfig.getListenTypeList().contains((Object)this.listenType);
    }

    protected final boolean checkFilter(PsrUser user, ReplacerConfig replacerConfig) {
        return replacerConfig.isEnabled() && this.checkPermission(user, replacerConfig) && replacerConfig.acceptsLocale(user.getClientLocale());
    }

    protected final boolean checkPermission(PsrUser user, ReplacerConfig replacerConfig) {
        String permission = replacerConfig.getPermissionLimit();
        return permission.isEmpty() || user.hasPermission(permission);
    }

    protected final boolean checkWindowTitle(PsrUser user, ReplacerConfig replacerConfig) {
        String currentWindowTitle = user.getCurrentWindowTitle();
        List<String> windowTitles = replacerConfig.getWindowTitleLimit();
        if (windowTitles.isEmpty()) {
            return true;
        }
        if (currentWindowTitle == null) {
            return replacerConfig.windowTitleLimitIgnoreInventory();
        }
        return windowTitles.contains(currentWindowTitle);
    }

    protected static ChatJsonContainer deployContainer(@Nonnull PacketEvent packetEvent, @Nonnull PsrUser user, @Nonnull String json, List<ReplacerConfig> replacers) {
        boolean blocked = false;
        ReplacerManager replacerManager = ProtocolStringReplacer.getInstance().getReplacerManager();
        ChatJsonContainer container = new ChatJsonContainer(json, true);
        container.createJsons(container);
        if (replacerManager.isJsonBlocked(container, replacers)) {
            packetEvent.setCancelled(true);
            blocked = true;
        } else {
            replacerManager.replaceContainerJsons(container, replacers);
        }
        try {
            container.createDefaultChildren();
        }
        catch (Throwable t) {
            throw new JsonSyntaxException("Unable to create default children. Please check your Json format.\nOriginal Json: " + json + "\nReplaced Json: " + container.getJsons().get(0).getText() + "\nIf you need support, please provide the stacktrace below.", t);
        }
        try {
            container.createTexts(container);
        }
        catch (Throwable t) {
            throw new JsonSyntaxException("Unable to create Texts. Please check your Json format.\nOriginal Json: " + json + "\nReplaced Json: " + container.getJsons().get(0).getText() + "\nIf you need support, please provide the stacktrace below.", t);
        }
        if (blocked || replacerManager.isTextBlocked(container, replacers)) {
            packetEvent.setCancelled(true);
            blocked = true;
        } else {
            replacerManager.replaceContainerTexts(container, replacers);
            replacerManager.setPapi(user, container.getTexts());
        }
        return blocked ? null : container;
    }

    @Nullable
    protected static String getReplacedJson(@Nonnull PacketEvent packetEvent, @Nonnull PsrUser user, @Nonnull ListenType listenType, @Nonnull String json, BiPredicate<ReplacerConfig, PsrUser> filter) {
        ReplacerManager replacerManager = ProtocolStringReplacer.getInstance().getReplacerManager();
        List<ReplacerConfig> replacers = replacerManager.getAcceptedReplacers(user, filter);
        return BaseServerPacketListener.getReplacedJson(packetEvent, user, listenType, json, replacers);
    }

    @Nullable
    protected static String getReplacedJson(@Nonnull PacketEvent packetEvent, @Nonnull PsrUser user, @Nonnull ListenType listenType, @Nonnull String json, List<ReplacerConfig> replacers) {
        String replacedDirect = BaseServerPacketListener.getReplacedDirect(packetEvent, user, listenType, json, replacers);
        if (replacedDirect == null) {
            return null;
        }
        if (replacedDirect != DIRECT_NOT_REPLACED && BaseServerPacketListener.plugin.getConfigManager().directSkips) {
            return SpigotUtils.serializeComponents(TextComponent.fromLegacyText((String)replacedDirect));
        }
        ChatJsonContainer container = BaseServerPacketListener.deployContainer(packetEvent, user, replacedDirect != DIRECT_NOT_REPLACED ? SpigotUtils.serializeComponents(TextComponent.fromLegacyText((String)replacedDirect)) : json, replacers);
        if (container != null) {
            return container.getResult();
        }
        return null;
    }

    @Nullable
    protected static String getReplacedDirect(@Nonnull PacketEvent packetEvent, @Nonnull PsrUser user, @Nonnull ListenType listenType, @Nonnull String json, List<ReplacerConfig> replacers) {
        StringBuilder sb = new StringBuilder();
        for (BaseComponent baseComponent : SpigotUtils.parseComponents(json)) {
            sb.append(baseComponent.toLegacyText());
        }
        String directString = sb.toString();
        if (user.isCapturing(listenType)) {
            CaptureInfoImpl info = new CaptureInfoImpl();
            info.setTime(System.currentTimeMillis());
            info.setUser(user);
            info.setListenType(listenType);
            ArrayList<String> directs = new ArrayList<String>();
            directs.add(directString);
            info.setDirects(directs);
            ChatJsonContainer container = new ChatJsonContainer(json, true);
            container.createJsons(container);
            List<Replaceable> jsons = container.getJsons();
            for (Replaceable j : jsons) {
                StringBuilder sb1 = new StringBuilder();
                for (BaseComponent baseComponent : SpigotUtils.parseComponents(j.getText())) {
                    sb1.append(baseComponent.toLegacyText());
                }
                String ds = sb1.toString();
                String replaceDirect = ProtocolStringReplacer.getInstance().getReplacerManager().replaceDirect(ds, replacers);
                if (replaceDirect.equals(ds)) continue;
                j.setText(SpigotUtils.serializeComponents(TextComponent.fromLegacyText((String)replaceDirect)));
            }
            info.setJsons(jsons);
            ProtocolStringReplacer.getInstance().getReplacerManager().replaceContainerJsons(container, replacers);
            try {
                container.createDefaultChildren();
            }
            catch (Throwable t) {
                throw new JsonSyntaxException("Unable to create default children. Please check your Json format.\nOriginal Json: " + json + "\nReplaced Json: " + jsons.get(0).getText() + "\nIf you need support, please provide the stacktrace below.", t);
            }
            try {
                container.createTexts(container);
            }
            catch (Throwable t) {
                throw new JsonSyntaxException("Unable to create Texts. Please check your Json format.\nOriginal Json: " + json + "\nReplaced Json: " + jsons.get(0).getText() + "\nIf you need support, please provide the stacktrace below.", t);
            }
            info.setTexts(container.getTexts());
            user.addCaptureInfo(listenType, info);
        }
        if (ProtocolStringReplacer.getInstance().getReplacerManager().isDirectBlocked(directString, replacers)) {
            packetEvent.setCancelled(true);
            return null;
        }
        String replaceDirect = ProtocolStringReplacer.getInstance().getReplacerManager().replaceDirect(directString, replacers);
        return replaceDirect.equals(directString) ? DIRECT_NOT_REPLACED : replaceDirect;
    }

    @Nullable
    protected static WrappedChatComponent getReplacedJsonWrappedComponent(@Nonnull PacketEvent packetEvent, @Nonnull PsrUser user, @Nonnull ListenType listenType, @Nonnull String json, BiPredicate<ReplacerConfig, PsrUser> filter) {
        ReplacerManager replacerManager = ProtocolStringReplacer.getInstance().getReplacerManager();
        List<ReplacerConfig> replacers = replacerManager.getAcceptedReplacers(user, filter);
        String replacedJson = BaseServerPacketListener.getReplacedJson(packetEvent, user, listenType, json, replacers);
        if (replacedJson != null) {
            return WrappedChatComponent.fromJson((String)replacedJson);
        }
        return null;
    }

    @Nullable
    protected static String getReplacedText(@Nonnull PacketEvent packetEvent, @Nonnull PsrUser user, @Nonnull ListenType listenType, @Nonnull String text, BiPredicate<ReplacerConfig, PsrUser> filter) {
        ReplacerManager replacerManager = ProtocolStringReplacer.getInstance().getReplacerManager();
        List<ReplacerConfig> replacers = replacerManager.getAcceptedReplacers(user, filter);
        SimpleTextContainer container = new SimpleTextContainer(text);
        CaptureInfoImpl info = null;
        if (user.isCapturing(listenType)) {
            info = new CaptureInfoImpl();
            info.setTime(System.currentTimeMillis());
            info.setUser(user);
            info.setListenType(listenType);
            info.setJsons(new ArrayList<Replaceable>());
        }
        container.createTexts(container);
        if (user.isCapturing(listenType)) {
            assert (info != null);
            info.setTexts(container.getTexts());
            info.setDirects(Collections.emptyList());
            user.addCaptureInfo(listenType, info);
        }
        if (replacerManager.isTextBlocked(container, replacers)) {
            packetEvent.setCancelled(true);
            return null;
        }
        replacerManager.replaceContainerTexts(container, replacers);
        replacerManager.setPapi(user, container.getTexts());
        return container.getResult();
    }

    protected static ItemStack replaceItemStack(@Nonnull PacketEvent packetEvent, @Nonnull PsrUser user, @Nonnull ListenType listenType, @Nonnull ItemStack itemStack, List<ReplacerConfig> nbt, List<ReplacerConfig> lore, List<ReplacerConfig> entries, boolean saveUserCache) {
        try {
            if (itemStack.getType() == Material.AIR) {
                return itemStack;
            }
            ReplacerManager replacerManager = ProtocolStringReplacer.getInstance().getReplacerManager();
            ItemStackContainer container = new ItemStackContainer(itemStack);
            if (!container.isFromCache()) {
                BaseServerPacketListener.cacheItemStack(container, nbt, lore, entries);
            }
            if (container.getMetaCache().isBlocked()) {
                packetEvent.setCancelled(true);
                return null;
            }
            int[] papiIndexes = container.getMetaCache().getPlaceholderIndexes();
            if (papiIndexes.length != 0) {
                if (!container.isFromCache()) {
                    container = new ItemStackContainer(itemStack);
                }
                container.cloneItem();
                container.entriesPeriod();
                container.createDefaultChildrenDeep();
                container.createTexts(container);
                replacerManager.setPapi(user, container.getTexts(), papiIndexes);
            }
            ItemStack result = container.getResult();
            if (saveUserCache && !container.getOriginalNbtString().equals(container.getNbtString())) {
                user.saveUserItemRestoreCache(itemStack, result);
            }
            if (user.isCapturing(listenType)) {
                BaseServerPacketListener.captureItemStackInfo(user, itemStack, listenType, nbt, lore, entries);
            }
            return result;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return itemStack;
        }
    }

    private static void captureItemStackInfo(@Nonnull PsrUser user, @Nonnull ItemStack itemStack, @Nonnull ListenType listenType, List<ReplacerConfig> nbt, List<ReplacerConfig> lore, List<ReplacerConfig> entries) {
        ReplacerManager replacerManager = ProtocolStringReplacer.getInstance().getReplacerManager();
        ItemStackContainer container = new ItemStackContainer(itemStack, false);
        try {
            Material type = container.getItemType();
            CaptureInfoImpl info = new CaptureInfoImpl();
            info.setTime(System.currentTimeMillis());
            info.setUser(user);
            info.setListenType(listenType);
            ComponentBuilder extraBuilder = new ComponentBuilder(PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Capture-Info.Extra-Prefix", new String[0])).color(ChatColor.BLUE).bold(true).append("").reset();
            container.createDefaultChildren();
            container.createJsons(container);
            List<Replaceable> jsons = container.getJsons();
            extraBuilder.append("[Nbt Json] ").color(ChatColor.GOLD).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)(jsons.get(0).getText() + "\n" + PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Capture-Info.Click-To-Copy", new String[0]))))).event(new ClickEvent(ProtocolStringReplacer.getInstance().getServerMajorVersion() >= 15 ? ClickEvent.Action.COPY_TO_CLIPBOARD : ClickEvent.Action.SUGGEST_COMMAND, jsons.get(0).getText()));
            replacerManager.replaceJsonReplaceable(jsons.get(0), BaseServerPacketListener.matchItemType(nbt, type));
            container.childrenResult();
            container.lorePeriod();
            container.createJsons(container);
            jsons = container.getJsons();
            extraBuilder.append("  ").reset().append("[Lore Json] ").color(ChatColor.GOLD).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)(jsons.get(0).getText() + "\n" + PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Capture-Info.Click-To-Copy", new String[0]))))).event(new ClickEvent(ProtocolStringReplacer.getInstance().getServerMajorVersion() >= 15 ? ClickEvent.Action.COPY_TO_CLIPBOARD : ClickEvent.Action.SUGGEST_COMMAND, jsons.get(0).getText()));
            info.setExtra(extraBuilder.create());
            ProtocolStringReplacer.getInstance().getReplacerManager().replaceJsonReplaceable(jsons.get(0), BaseServerPacketListener.matchItemType(lore, type));
            container.childrenResult();
            container.entriesPeriod();
            container.createJsons(container);
            jsons = container.getJsons();
            List originalJsons = jsons.stream().map(Replaceable::getText).collect(Collectors.toList());
            ArrayList<String> directs = new ArrayList<String>(originalJsons.size());
            for (Object json : originalJsons) {
                StringBuilder sb = new StringBuilder();
                for (BaseComponent baseComponent : SpigotUtils.parseComponents((String)json)) {
                    sb.append(baseComponent.toLegacyText());
                }
                directs.add(sb.toString());
            }
            info.setDirects(directs);
            List<ReplacerConfig> filtered = BaseServerPacketListener.matchItemType(entries, type);
            for (Replaceable json : jsons) {
                StringBuilder sb = new StringBuilder();
                for (BaseComponent baseComponent : SpigotUtils.parseComponents(json.getText())) {
                    sb.append(baseComponent.toLegacyText());
                }
                String directString = sb.toString();
                String replaceDirect = ProtocolStringReplacer.getInstance().getReplacerManager().replaceDirect(directString, filtered);
                if (replaceDirect.equals(directString)) continue;
                json.setText(SpigotUtils.serializeComponents(TextComponent.fromLegacyText((String)replaceDirect)));
            }
            info.setJsons(jsons);
            ProtocolStringReplacer.getInstance().getReplacerManager().replaceContainerJsons(container, filtered);
            try {
                container.createDefaultChildrenDeep();
            }
            catch (Throwable t) {
                throw new JsonSyntaxException("Unable to create default children.", t);
            }
            try {
                container.createTexts(container);
            }
            catch (Throwable t) {
                throw new JsonSyntaxException("Unable to create Texts.", t);
            }
            info.setTexts(container.getTexts());
            user.addCaptureInfo(listenType, info);
        }
        catch (Throwable t) {
            throw new JsonSyntaxException("Failed to handle ItemStack (capture). Please check your nbt format.\nOriginal Nbt: " + container.getOriginalNbtString() + "\nLast replaced Nbt: " + container.getNbtString() + "\nIf you need support, please provide the stacktrace below.", t);
        }
    }

    private static boolean handleItemStackPeriod(ReplacerManager replacerManager, Material type, ItemStackContainer container, List<ReplacerConfig> configs) {
        List<ReplacerConfig> filtered = BaseServerPacketListener.matchItemType(configs, type);
        container.createJsons(container);
        if (BaseServerPacketListener.checkBlocked(container.getJsons().get(0).getText(), filtered, replacerManager)) {
            container.getMetaCache().setBlocked(true);
            return true;
        }
        replacerManager.replaceJsonReplaceable(container.getJsons().get(0), filtered);
        container.childrenResult();
        return false;
    }

    private static boolean cacheItemStack(@Nonnull ItemStackContainer container, List<ReplacerConfig> nbt, List<ReplacerConfig> display, List<ReplacerConfig> entries) {
        try {
            ReplacerManager replacerManager = ProtocolStringReplacer.getInstance().getReplacerManager();
            Material type = container.getItemType();
            container.createDefaultChildren();
            if (BaseServerPacketListener.handleItemStackPeriod(replacerManager, type, container, nbt)) {
                return true;
            }
            container.childrenResult();
            container.lorePeriod();
            if (BaseServerPacketListener.handleItemStackPeriod(replacerManager, type, container, display)) {
                return true;
            }
            container.childrenResult();
            container.entriesPeriod();
            container.createJsons(container);
            boolean direct = false;
            List<ReplacerConfig> filtered = BaseServerPacketListener.matchItemType(entries, type);
            for (Replaceable json : container.getJsons()) {
                StringBuilder sb = new StringBuilder();
                try {
                    for (BaseComponent baseComponent : SpigotUtils.parseComponents(json.getText())) {
                        sb.append(baseComponent.toLegacyText());
                    }
                }
                catch (Throwable t) {
                    throw new JsonSyntaxException("Failed to parse replaced lores.", t);
                }
                String directString = sb.toString();
                if (ProtocolStringReplacer.getInstance().getReplacerManager().isDirectBlocked(directString, filtered)) {
                    container.getMetaCache().setBlocked(true);
                    return true;
                }
                String replaceDirect = ProtocolStringReplacer.getInstance().getReplacerManager().replaceDirect(directString, filtered);
                if (replaceDirect.equals(directString)) continue;
                BaseComponent[] baseComponents = TextComponent.fromLegacyText((String)replaceDirect);
                BaseComponent head = baseComponents[0];
                if (head.isBoldRaw() == null) {
                    head.setBold(Boolean.valueOf(false));
                }
                if (head.isUnderlinedRaw() == null) {
                    head.setUnderlined(Boolean.valueOf(false));
                }
                if (head.isStrikethroughRaw() == null) {
                    head.setStrikethrough(Boolean.valueOf(false));
                }
                if (head.isObfuscatedRaw() == null) {
                    head.setObfuscated(Boolean.valueOf(false));
                }
                for (BaseComponent baseComponent : baseComponents) {
                    if (baseComponent.isItalicRaw() != null) continue;
                    baseComponent.setItalic(Boolean.valueOf(false));
                }
                json.setText(SpigotUtils.serializeComponents(baseComponents));
                direct = true;
            }
            if (direct && BaseServerPacketListener.plugin.getConfigManager().directSkips) {
                container.createDefaultChildrenDeep();
                container.createTexts(container);
            } else {
                if (replacerManager.isJsonBlocked(container, entries)) {
                    container.getMetaCache().setBlocked(true);
                    return true;
                }
                replacerManager.replaceContainerJsons(container, entries);
                try {
                    container.createDefaultChildrenDeep();
                }
                catch (Throwable t) {
                    throw new JsonSyntaxException("Failed to create default children with replaced lores.", t);
                }
                try {
                    container.createTexts(container);
                }
                catch (Throwable t) {
                    throw new JsonSyntaxException("Failed to create texts with replaced lores.", t);
                }
                if (replacerManager.isTextBlocked(container, entries)) {
                    container.getMetaCache().setBlocked(true);
                    return true;
                }
                replacerManager.replaceContainerTexts(container, entries);
            }
            Integer[] ints = replacerManager.getPapiIndexes(container.getTexts()).toArray(new Integer[0]);
            int[] indexes = new int[ints.length];
            for (int i = 0; i < ints.length; ++i) {
                indexes[i] = ints[i];
            }
            container.getMetaCache().setPlaceholderIndexes(indexes);
            container.getResult();
        }
        catch (Throwable t) {
            throw new JsonSyntaxException("Failed to handle ItemStack. Please check your nbt format.\nOriginal Nbt: " + container.getOriginalNbtString() + "\nLast replaced Nbt: " + container.getNbtString() + "\nIf you need support, please provide the stacktrace below.", t);
        }
        return false;
    }

    private static List<ReplacerConfig> matchItemType(List<ReplacerConfig> raw, Material material) {
        ArrayList<ReplacerConfig> result = new ArrayList<ReplacerConfig>(raw.size());
        for (ReplacerConfig cfg : raw) {
            if (!cfg.acceptedItemTypes().isEmpty() && !cfg.acceptedItemTypes().contains(material)) continue;
            result.add(cfg);
        }
        return result;
    }

    private static boolean checkBlocked(String json, List<ReplacerConfig> replacerConfigs, ReplacerManager replacerManager) {
        for (ReplacerConfig replacerConfig : replacerConfigs) {
            if (!replacerManager.getBlocked(json, replacerConfig, ReplaceMode.JSON)) continue;
            return true;
        }
        return false;
    }
}

