/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.packetlistener.server.bossbar;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.packetlistener.server.BaseServerPacketListener;
import io.github.rothes.protocolstringreplacer.replacer.ListenType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public final class BossBarPost17
extends BaseServerPacketListener {
    private Field actionField;
    private final HashMap<Class<?>, FieldAccessor> actionComponentField = new HashMap();

    public BossBarPost17() {
        super(PacketType.Play.Server.BOSS, ListenType.BOSS_BAR);
    }

    @Override
    protected void register() {
        Class packetClass = PacketType.Play.Server.BOSS.getPacketClass();
        Class<?> actionInterface = null;
        for (Class<?> clazz : packetClass.getDeclaredClasses()) {
            if (!clazz.isInterface() || !clazz.getSimpleName().equals("Action") && !clazz.getSimpleName().equals("Operation")) continue;
            actionInterface = clazz;
            break;
        }
        if (actionInterface == null) {
            throw new UnsupportedOperationException("Error when hooking into BOSS packet");
        }
        for (AnnotatedElement annotatedElement : packetClass.getDeclaredFields()) {
            if (((Field)annotatedElement).getType() != actionInterface) continue;
            this.actionField = annotatedElement;
            this.actionField.setAccessible(true);
            break;
        }
        if (this.actionField == null) {
            throw new UnsupportedOperationException("Error when hooking into BOSS packet");
        }
        for (AnnotatedElement annotatedElement : packetClass.getDeclaredClasses()) {
            if (((Class)annotatedElement).getInterfaces().length == 0 || ((Class)annotatedElement).getInterfaces()[0] != actionInterface) continue;
            for (Field field : ((Class)annotatedElement).getDeclaredFields()) {
                if (field.getType() != MinecraftReflection.getIChatBaseComponentClass()) continue;
                this.actionComponentField.put((Class<?>)annotatedElement, Accessors.getFieldAccessor((Field)field));
            }
        }
        if (this.actionComponentField.isEmpty()) {
            throw new UnsupportedOperationException("Error when hooking into BOSS packet");
        }
        super.register();
    }

    @Override
    protected void process(@NotNull PacketEvent packetEvent) {
        PsrUser user = this.getEventUser(packetEvent);
        if (user == null) {
            return;
        }
        Object handle = packetEvent.getPacket().getHandle();
        try {
            WrappedChatComponent wrappedChatComponent;
            String replacedJson;
            Object action = this.actionField.get(handle);
            if (action == null) {
                return;
            }
            FieldAccessor field = this.actionComponentField.get(action.getClass());
            if (field != null && (replacedJson = BossBarPost17.getReplacedJson(packetEvent, user, this.listenType, (wrappedChatComponent = WrappedChatComponent.fromHandle((Object)field.get(action))).getJson(), this.filter)) != null) {
                wrappedChatComponent.setJson(replacedJson);
                field.set(action, wrappedChatComponent.getHandle());
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

