/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.packetlistener.server.chat;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.nms.packetreader.ChatType;
import io.github.rothes.protocolstringreplacer.packetlistener.server.BaseServerComponentsPacketListener;
import io.github.rothes.protocolstringreplacer.packetlistener.server.chat.PlayerChatHelper;
import io.github.rothes.protocolstringreplacer.replacer.ListenType;
import io.github.rothes.protocolstringreplacer.util.PaperUtils;
import io.github.rothes.protocolstringreplacer.util.SpigotUtils;
import java.util.Optional;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;

public final class Chat
extends BaseServerComponentsPacketListener {
    public final PlayerChatHelper.Version version = PlayerChatHelper.version;

    public Chat() {
        super(PacketType.Play.Server.CHAT, ListenType.CHAT);
    }

    @Override
    protected void process(PacketEvent packetEvent) {
        PacketContainer packet = packetEvent.getPacket();
        Optional isFiltered = packet.getMeta("psr_filtered_packet");
        if (!isFiltered.isPresent() || !((Boolean)isFiltered.get()).booleanValue()) {
            String replaced;
            PsrUser user = this.getEventUser(packetEvent);
            if (user == null) {
                return;
            }
            if (this.convert(packet, user)) {
                packetEvent.setCancelled(true);
                return;
            }
            if (packet.getChatTypes().read(0) == EnumWrappers.ChatType.GAME_INFO || packet.getBytes().size() >= 1 && (Byte)packet.getBytes().read(0) == 2) {
                return;
            }
            if (this.version != PlayerChatHelper.Version.V8_0_TO_V18_2) {
                return;
            }
            StructureModifier componentModifier = packet.getChatComponents();
            WrappedChatComponent wrappedChatComponent = (WrappedChatComponent)componentModifier.read(0);
            if (wrappedChatComponent != null) {
                String json = wrappedChatComponent.getJson();
                replaced = Chat.getReplacedJson(packetEvent, user, this.listenType, json, this.filter);
            } else {
                StructureModifier modifier = packet.getModifier();
                replaced = this.processSpigotComponent((StructureModifier<Object>)modifier, packetEvent, user);
                if (replaced == null) {
                    replaced = this.processPaperComponent((StructureModifier<Object>)modifier, packetEvent, user);
                }
            }
            if (replaced != null) {
                componentModifier.write(0, (Object)WrappedChatComponent.fromJson((String)replaced));
            }
        }
    }

    private boolean convert(PacketContainer packet, PsrUser user) {
        BaseComponent[] spigotComponent;
        Object chatMessageTypeSubOrChatSender;
        WrappedChatComponent wrappedChatComponent;
        if (!ProtocolStringReplacer.getInstance().getConfigManager().convertPlayerChat) {
            return false;
        }
        if (this.version == PlayerChatHelper.Version.V8_0_TO_V18_2) {
            return false;
        }
        StructureModifier modifier = packet.getModifier();
        ChatType chatType = PlayerChatHelper.getChatType((ClientboundPlayerChatPacket)packet.getHandle());
        switch (this.version) {
            case V19_0: {
                StructureModifier componentModifier = packet.getChatComponents();
                wrappedChatComponent = (WrappedChatComponent)componentModifier.read(0);
                chatMessageTypeSubOrChatSender = PlayerChatHelper.getChatSender((StructureModifier<Object>)modifier);
                break;
            }
            case V19_1_TO_V19_2: {
                wrappedChatComponent = PlayerChatHelper.getChatMessage(packet.getModifier().withType(PlayerChatHelper.getPlayerChatMessageClass()).read(0));
                chatMessageTypeSubOrChatSender = PlayerChatHelper.getChatMessageTypeSub((StructureModifier<Object>)modifier);
                break;
            }
            case V19_3: 
            case V19_4: {
                StructureModifier componentModifier = packet.getChatComponents();
                wrappedChatComponent = (WrappedChatComponent)componentModifier.read(0);
                if (wrappedChatComponent == null) {
                    wrappedChatComponent = PlayerChatHelper.getChatMessageR3(packet.getModifier().withType(PlayerChatHelper.getMessageBodySubClass()).read(0));
                }
                chatMessageTypeSubOrChatSender = PlayerChatHelper.getChatMessageTypeSub((StructureModifier<Object>)modifier);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        BaseComponent message = wrappedChatComponent != null ? SpigotUtils.parseComponents(wrappedChatComponent.getJson())[0] : ((spigotComponent = Chat.getSpigotComponent((StructureModifier<Object>)modifier)) != null ? spigotComponent[0] : SpigotUtils.parseComponents(PaperUtils.serializeComponent(Chat.getPaperComponent((StructureModifier<Object>)modifier)))[0]);
        block5 : switch (chatType) {
            case PLAYER_CHAT: {
                BaseComponent displayName = PlayerChatHelper.getDisplayName(chatMessageTypeSubOrChatSender);
                TranslatableComponent component = new TranslatableComponent("chat.type.text", new Object[]{displayName, message});
                user.sendMessage(new BaseComponent[]{component});
                break;
            }
            case SYSTEM_CHAT: {
                user.sendMessage(message);
                break;
            }
            case TELLRAW: {
                switch (this.version) {
                    case V19_0: 
                    case V19_1_TO_V19_2: {
                        user.sendMessage(ComponentSerializer.parse((String)PlayerChatHelper.getOptionalChatMessage(packet.getModifier().withType(PlayerChatHelper.getPlayerChatMessageClass()).read(0)).getJson()));
                        break block5;
                    }
                }
                user.sendMessage(SpigotUtils.parseComponents(((WrappedChatComponent)packet.getChatComponents().read(0)).getJson()));
                break;
            }
            case GAME_INFO: {
                user.sendActionBar(message);
                break;
            }
            case SAY: {
                BaseComponent displayName = PlayerChatHelper.getDisplayName(chatMessageTypeSubOrChatSender);
                TranslatableComponent component = new TranslatableComponent("chat.type.announcement", new Object[]{displayName, message});
                user.sendMessage(new BaseComponent[]{component});
                break;
            }
            case MSG_INCOMING: {
                BaseComponent displayName = PlayerChatHelper.getDisplayName(chatMessageTypeSubOrChatSender);
                TranslatableComponent component = new TranslatableComponent("commands.message.display.incoming", new Object[]{displayName, message});
                component.setItalic(Boolean.valueOf(true));
                component.setColor(ChatColor.GRAY);
                user.sendMessage(new BaseComponent[]{component});
                break;
            }
            case MSG_OUTGOING: {
                BaseComponent displayName = PlayerChatHelper.getDisplayName(chatMessageTypeSubOrChatSender);
                TranslatableComponent component = new TranslatableComponent("commands.message.display.outgoing", new Object[]{displayName, message});
                component.setItalic(Boolean.valueOf(true));
                component.setColor(ChatColor.GRAY);
                user.sendMessage(new BaseComponent[]{component});
                break;
            }
            case EMOTE: {
                BaseComponent displayName = PlayerChatHelper.getDisplayName(chatMessageTypeSubOrChatSender);
                TranslatableComponent component = new TranslatableComponent("chat.type.emote", new Object[]{displayName, message});
                user.sendMessage(new BaseComponent[]{component});
                break;
            }
            case TEAM_MSG_INCOMING: {
                BaseComponent displayName = PlayerChatHelper.getDisplayName(chatMessageTypeSubOrChatSender);
                BaseComponent teamName = PlayerChatHelper.getTeamName(chatMessageTypeSubOrChatSender);
                TranslatableComponent component = new TranslatableComponent("chat.type.team.text", new Object[]{teamName, displayName, message});
                user.sendMessage(new BaseComponent[]{component});
                break;
            }
            case TEAM_MSG_OUTGOING: {
                BaseComponent displayName = PlayerChatHelper.getDisplayName(chatMessageTypeSubOrChatSender);
                BaseComponent teamName = PlayerChatHelper.getTeamName(chatMessageTypeSubOrChatSender);
                TranslatableComponent component = new TranslatableComponent("chat.type.team.sent", new Object[]{teamName, displayName, message});
                user.sendMessage(new BaseComponent[]{component});
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return true;
    }
}

