/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.replacer.containers;

import io.github.rothes.protocolstringreplacer.replacer.containers.Container;
import io.github.rothes.protocolstringreplacer.replacer.containers.Replaceable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractContainer<T>
implements Container<T> {
    @NotNull
    protected T content;
    protected Container<?> root;
    protected List<Replaceable> jsonReplaceables = null;
    protected List<Replaceable> textReplaceables = null;
    protected List<Container<?>> children = new ArrayList();

    public AbstractContainer(@NotNull T t) {
        this(t, null);
    }

    public AbstractContainer(@NotNull T t, Container<?> root) {
        Validate.notNull(t, (String)"Content cannot be null");
        this.content = t;
        this.root = root == null ? this : root;
    }

    @Override
    public List<Replaceable> getJsons() {
        if (this.jsonReplaceables == null) {
            throw new IllegalStateException("JsonReplaceables has not been created");
        }
        return this.jsonReplaceables;
    }

    @Override
    public List<Replaceable> getTexts() {
        if (this.textReplaceables == null) {
            throw new IllegalStateException("TextReplaceables has not been created");
        }
        return this.textReplaceables;
    }

    @Override
    public void createDefaultChildren() {
        if (!this.children.isEmpty()) {
            for (Container<?> child : this.children) {
                child.createDefaultChildren();
            }
        }
    }

    @Override
    public void createJsons(@NotNull Container<?> container) {
        Validate.notNull(container, (String)"Container cannot be null");
        if (container == this) {
            this.jsonReplaceables = new ArrayList<Replaceable>();
        }
        if (!this.children.isEmpty()) {
            for (Container<?> child : this.children) {
                child.createJsons(container);
            }
        }
    }

    @Override
    public void createTexts(@NotNull Container<?> container) {
        Validate.notNull(container, (String)"Container cannot be null");
        if (container == this) {
            this.textReplaceables = new ArrayList<Replaceable>();
        }
        if (!this.children.isEmpty()) {
            for (Container<?> child : this.children) {
                child.createTexts(container);
            }
        }
    }

    @Override
    public void addJson(@NotNull Replaceable replaceable) {
        Validate.notNull((Object)replaceable, (String)"JsonReplaceable cannot be null");
        if (this == this.root) {
            this.jsonReplaceables.add(replaceable);
        } else {
            this.root.addJson(replaceable);
        }
    }

    @Override
    public void addText(@NotNull Replaceable replaceable) {
        Validate.notNull((Object)replaceable, (String)"Replaceable cannot be null");
        if (this != this.root) {
            this.root.addText(replaceable);
        } else {
            this.textReplaceables.add(replaceable);
        }
    }

    @Override
    public void reset() {
        this.children = new ArrayList();
        this.jsonReplaceables = null;
        this.textReplaceables = null;
    }

    @Override
    public Container<?> getRoot() {
        return this.root;
    }

    @Override
    public List<Container<?>> getChildren() {
        return this.children;
    }

    @Override
    public T getResult() {
        if (!this.children.isEmpty()) {
            for (Container<?> child : this.children) {
                child.getResult();
            }
        }
        return this.content;
    }
}

