/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.replacer.containers;

import io.github.rothes.protocolstringreplacer.api.exceptions.JsonSyntaxException;
import io.github.rothes.protocolstringreplacer.replacer.containers.AbstractContainer;
import io.github.rothes.protocolstringreplacer.replacer.containers.ComponentsContainer;
import io.github.rothes.protocolstringreplacer.replacer.containers.Container;
import io.github.rothes.protocolstringreplacer.replacer.containers.Replaceable;
import io.github.rothes.protocolstringreplacer.util.SpigotUtils;
import net.md_5.bungee.api.chat.BaseComponent;
import org.jetbrains.annotations.NotNull;

public class ChatJsonContainer
extends AbstractContainer<String> {
    private boolean createComponents = false;
    private ComponentsContainer componentsContainer = null;

    public ChatJsonContainer(@NotNull String json) {
        super(json);
    }

    public ChatJsonContainer(@NotNull String json, boolean createComponents) {
        super(json);
        this.createComponents = createComponents;
    }

    public ChatJsonContainer(@NotNull String json, @NotNull Container<?> root) {
        super(json, root);
    }

    public ChatJsonContainer(@NotNull String json, @NotNull Container<?> root, boolean createComponents) {
        super(json, root);
        this.createComponents = createComponents;
    }

    @Override
    public void createDefaultChildren() {
        if (this.createComponents) {
            try {
                this.componentsContainer = new ComponentsContainer(SpigotUtils.parseComponents((String)this.content), this.root);
            }
            catch (Throwable t) {
                throw new JsonSyntaxException("Serializer can't parse Json: " + (String)this.content, t);
            }
            this.children.add(this.componentsContainer);
        }
        super.createDefaultChildren();
    }

    @Override
    public void createJsons(@NotNull Container<?> container) {
        super.createJsons(container);
        this.root.addJson(new ReplaceableImpl());
    }

    @Override
    public String getResult() {
        if (this.componentsContainer != null) {
            return SpigotUtils.serializeComponents((BaseComponent[])this.componentsContainer.getResult());
        }
        return (String)super.getResult();
    }

    public ComponentsContainer getComponentsContainer() {
        return this.componentsContainer;
    }

    private class ReplaceableImpl
    implements Replaceable {
        private ReplaceableImpl() {
        }

        @Override
        public String getText() {
            return (String)ChatJsonContainer.this.content;
        }

        @Override
        public void setText(String text) {
            ChatJsonContainer.this.content = text;
        }

        public String toString() {
            return (String)ChatJsonContainer.this.content;
        }
    }
}

