/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.replacer.containers;

import io.github.rothes.protocolstringreplacer.replacer.containers.AbstractContainer;
import io.github.rothes.protocolstringreplacer.replacer.containers.Container;
import io.github.rothes.protocolstringreplacer.replacer.containers.HoverEventContainer;
import io.github.rothes.protocolstringreplacer.replacer.containers.SimpleTextContainer;
import io.github.rothes.protocolstringreplacer.util.ColorUtils;
import java.lang.reflect.Method;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import org.jetbrains.annotations.NotNull;

public class ComponentContainer
extends AbstractContainer<BaseComponent> {
    private static final boolean TRANSLATE_FALLBACK = ComponentContainer.supportFallback();

    private static boolean supportFallback() {
        for (Method method : TranslatableComponent.class.getDeclaredMethods()) {
            if (!method.getName().equals("getFallback")) continue;
            return true;
        }
        return false;
    }

    public ComponentContainer(@NotNull BaseComponent component) {
        super(component);
    }

    public ComponentContainer(@NotNull BaseComponent component, @NotNull Container<?> root) {
        super(component, root);
    }

    @Override
    public void createDefaultChildren() {
        List extra;
        if (this.content instanceof TextComponent) {
            final TextComponent textComponent = (TextComponent)this.content;
            final String color = ColorUtils.getTextColor((BaseComponent)textComponent);
            this.children.add(new SimpleTextContainer(color + textComponent.getText(), this.root){

                @Override
                public String getResult() {
                    String result = super.getResult();
                    int length = color.length();
                    if (result.length() >= length && result.substring(0, length).equals(color)) {
                        textComponent.setText(result.substring(length));
                    } else {
                        textComponent.setText(result);
                    }
                    return result;
                }
            });
        } else if (this.content instanceof TranslatableComponent) {
            final TranslatableComponent translatableComponent = (TranslatableComponent)this.content;
            List with = translatableComponent.getWith();
            if (with != null) {
                for (BaseComponent component : with) {
                    this.children.add(new ComponentContainer(component, this.root));
                }
            }
            if (TRANSLATE_FALLBACK && translatableComponent.getFallback() != null) {
                this.children.add(new SimpleTextContainer(translatableComponent.getFallback(), this.root){

                    @Override
                    @NotNull
                    public String getResult() {
                        String result = super.getResult();
                        translatableComponent.setFallback(result);
                        return result;
                    }
                });
            }
        }
        HoverEvent hoverEvent = ((BaseComponent)this.content).getHoverEvent();
        if (hoverEvent != null) {
            this.children.add(new HoverEventContainer(hoverEvent, this.root));
        }
        if ((extra = ((BaseComponent)this.content).getExtra()) != null) {
            for (BaseComponent component : extra) {
                this.children.add(new ComponentContainer(component, this.root));
            }
        }
        super.createDefaultChildren();
    }
}

