/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.replacer.helpers;

import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTContainer;
import de.tr7zw.nbtapi.NBTList;
import io.github.rothes.protocolstringreplacer.util.SpigotUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.hover.content.Item;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public class ItemHelper {
    private Item item;
    private NBTContainer nbt;
    private NBTCompound display;
    private NBTList<String> loreNbt;
    private BaseComponent[] name = null;
    private List<BaseComponent[]> lore = null;

    private ItemHelper() {
    }

    @NotNull
    public static ItemHelper parse(@Nonnull Item item) {
        Validate.notNull((Object)item, (String)"Item cannot be null");
        ItemHelper helper = new ItemHelper();
        helper.item = item;
        ItemTag tag2 = item.getTag();
        if (tag2 != null) {
            helper.nbt = new NBTContainer(tag2.getNbt());
            helper.display = helper.nbt.getCompound("display");
            if (helper.display != null) {
                if (helper.display.hasTag("Name")) {
                    helper.name = SpigotUtils.parseComponents(helper.display.getString("Name"));
                }
                if (helper.display.hasTag("Lore")) {
                    helper.loreNbt = helper.display.getStringList("Lore");
                    helper.lore = new ArrayList<BaseComponent[]>(helper.loreNbt.size());
                    for (String line : helper.loreNbt) {
                        helper.lore.add(SpigotUtils.parseComponents(line));
                    }
                }
            }
        }
        return helper;
    }

    public boolean hasName() {
        return this.name != null;
    }

    @Nullable
    public BaseComponent[] getName() {
        return this.name;
    }

    public void setName(BaseComponent[] name) {
        this.name = name;
        if (name != null) {
            String result = SpigotUtils.serializeComponents(name);
            this.display.setString("Name", result);
        } else {
            this.display.removeKey("Name");
        }
    }

    public boolean hasLore() {
        return this.lore != null;
    }

    public int getLoreSize() {
        return this.lore.size();
    }

    public BaseComponent[] getLore(int line) {
        return this.lore.get(line);
    }

    public void setLore(int line, BaseComponent[] loreLine) {
        this.lore.set(line, loreLine);
        String result = SpigotUtils.serializeComponents(loreLine);
        this.loreNbt.set(line, (Object)result);
    }

    public void saveChanges() {
        if (this.display == null) {
            return;
        }
        this.item.setTag(ItemTag.ofNbt((String)this.nbt.toString()));
    }
}

