/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.upgrade;

import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.api.configuration.CommentYamlConfiguration;
import io.github.rothes.protocolstringreplacer.lib.org.apache.commons.collections.map.ListOrderedMap;
import io.github.rothes.protocolstringreplacer.upgrade.DotConfigUpgradeHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public final class UpgradeHandler1To2
extends DotConfigUpgradeHandler {
    @Override
    public void upgrade() {
        this.upgradeAllReplacerConfigs(new File(ProtocolStringReplacer.getInstance().getDataFolder() + "/Replacers"));
        CommentYamlConfiguration config = ProtocolStringReplacer.getInstance().getConfig();
        ListOrderedMap keyValues = new ListOrderedMap();
        ConfigurationSection configurationSection = config.getConfigurationSection("");
        for (Object key : configurationSection.getKeys(true)) {
            if (((String)key).equals("Configs-Version")) continue;
            keyValues.put(key, config.get((String)key));
        }
        config = new CommentYamlConfiguration();
        config.set("12340\u3a75\u904c\u36b3\u8fd9\u662f\u6ce8\u91ca\u662f", "0| # \u8bf7\u52ff\u624b\u52a8\u4fee\u6539Configs-Version\u503c!");
        config.set("Configs-Version", 2);
        config.set("12341\u3a75\u904c\u36b3\u8fd9\u662f\u6ce8\u91ca\u662f", "0| #");
        Set entrySet = keyValues.entrySet();
        for (Map.Entry entry : entrySet) {
            config.set((String)entry.getKey(), entry.getValue());
        }
        try {
            config.save(ProtocolStringReplacer.getInstance().getConfigFile());
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void upgradeReplacerConfig(@Nonnull File file, @Nonnull YamlConfiguration config) {
        Validate.notNull((Object)file, (String)"configuration File cannot be null");
        Validate.notNull((Object)config, (String)"configuration cannot be null");
        LinkedList<String> listenTypes = new LinkedList<String>();
        List packetTypes = config.getStringList("Options\u9c20Filter\u9c20Packet-Types");
        if (packetTypes.isEmpty()) {
            for (PacketType packetType : PacketType.values()) {
                if (listenTypes.contains(packetType.listenType)) continue;
                listenTypes.add(packetType.listenType);
            }
        } else {
            for (String type : packetTypes) {
                boolean typeFound = false;
                for (PacketType packetType : PacketType.values()) {
                    if (!packetType.packetType.equals(type)) continue;
                    typeFound = true;
                    if (listenTypes.contains(packetType.listenType)) break;
                    listenTypes.add(packetType.listenType);
                    break;
                }
                if (typeFound) continue;
                ProtocolStringReplacer.warn("\u00a7c\u672a\u77e5\u6216\u4e0d\u652f\u6301\u7684\u6570\u636e\u5305\u7c7b\u578b: " + type + ", \u5df2\u5ffd\u7565.");
            }
        }
        config.set("Options\u9c20Filter\u9c2012340\u3a75\u904c\u36b3\u8fd9\u662f\u6ce8\u91ca\u662f", (Object)"0|     # window-title \u66ff\u6362\u5bb9\u5668\u6807\u9898\u6587\u672c");
        config.set("Options\u9c20Filter\u9c2012341\u3a75\u904c\u36b3\u8fd9\u662f\u6ce8\u91ca\u662f", (Object)"1|     # itemstack \u66ff\u6362\u7269\u54c1(\u7269\u54c1\u540d|Lore|\u4e66\u7f72\u540d|\u4e66\u5185\u5bb9)\u6587\u672c");
        config.set("Options\u9c20Filter\u9c2012342\u3a75\u904c\u36b3\u8fd9\u662f\u6ce8\u91ca\u662f", (Object)"2|     # boss-bar \u66ff\u6362Boss\u8840\u91cf\u6761\u6587\u672c");
        config.set("Options\u9c20Filter\u9c2012343\u3a75\u904c\u36b3\u8fd9\u662f\u6ce8\u91ca\u662f", (Object)"3|     # entity \u66ff\u6362\u5b9e\u4f53\u540d\u6587\u672c");
        config.set("Options\u9c20Filter\u9c2012344\u3a75\u904c\u36b3\u8fd9\u662f\u6ce8\u91ca\u662f", (Object)"4|     # title \u66ff\u6362\u6807\u9898(title|subtitle)\u6587\u672c");
        config.set("Options\u9c20Filter\u9c2012345\u3a75\u904c\u36b3\u8fd9\u662f\u6ce8\u91ca\u662f", (Object)"5|     # sign \u66ff\u6362\u544a\u793a\u724c\u6587\u672c");
        config.set("Options\u9c20Filter\u9c2012346\u3a75\u904c\u36b3\u8fd9\u662f\u6ce8\u91ca\u662f", (Object)"6|     # chat \u66ff\u6362\u804a\u5929(chat|actionbar)\u4fe1\u606f\u6587\u672c");
        config.set("Options\u9c20Filter\u9c2012347\u3a75\u904c\u36b3\u8fd9\u662f\u6ce8\u91ca\u662f", (Object)"7|     # \u6307\u5b9a\u66ff\u6362\u4f55\u5904\u7684\u5b57\u7b26\u4e32. \u9ed8\u8ba4\u4e3a\u5168\u90e8. \u53ef\u9009\u503c: ");
        config.set("Options\u9c20Filter\u9c20Listen-Types", listenTypes);
        Pattern commentPattern = CommentYamlConfiguration.getCommentKeyPattern();
        ArrayList<String> commentKeys = new ArrayList<String>();
        ConfigurationSection configurationSection = config.getConfigurationSection("");
        for (String key : configurationSection.getKeys(true)) {
            if (commentPattern.matcher(key).find()) {
                commentKeys.add(key);
                continue;
            }
            if (key.equals("Config-Version") || key.equals("Options\u9c20Filter\u9c20Packet-Types")) {
                for (String commentKey : commentKeys) {
                    config.set(commentKey, null);
                }
                config.set(key, null);
            }
            commentKeys.clear();
        }
        try {
            config.save(file);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private static enum PacketType {
        CHAT("CHAT", "chat"),
        TITLE("TITLE", "title"),
        BOSS_BAR("BOSS_BAR", "boss-bar"),
        OPEN_WINDOW("OPEN_WINDOW", "window-title"),
        SET_SLOT("SET_SLOT", "itemstack"),
        WINDOW_ITEMS("WINDOW_ITEMS", "itemstack"),
        ENTITY_METADATA("ENTITY_METADATA", "entity"),
        TILE_ENTITY_DATA("TILE_ENTITY_DATA", "sign"),
        MAP_CHUNK("MAP_CHUNK", "sign");

        private String packetType;
        private String listenType;

        private PacketType(String packetType, String listenType) {
            this.packetType = packetType;
            this.listenType = listenType;
        }
    }
}

