/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.md_5.bungee.api.chat.BaseComponent;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;

public class ColorUtils {
    private static final String RGBRegex = "&#([0-9a-fA-F]{6})";
    private static final Pattern pattern = Pattern.compile("&#([0-9a-fA-F]{6})");

    @Nonnull
    public static String getColored(@Nonnull String textToTranslate) {
        Validate.notNull((Object)textToTranslate, (String)"Text cannot be null");
        return ColorUtils.translateRGB(ChatColor.translateAlternateColorCodes((char)'&', (String)textToTranslate));
    }

    @Nonnull
    public static String showColorCodes(@Nonnull String string) {
        Validate.notNull((Object)string, (String)"String cannot be null");
        return ColorUtils.showColorCodes(string, false);
    }

    @Nonnull
    public static String showColorCodes(@Nonnull String string, boolean correctHex) {
        Validate.notNull((Object)string, (String)"String cannot be null");
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = string.length() - 2; i >= 0; --i) {
            int indexOf;
            char Char = string.charAt(i);
            char nextChar = string.charAt(i + 1);
            if (Char != '\u00a7' || (indexOf = "x0123456789abcdefABCDEFklmnor".indexOf(nextChar)) == -1) continue;
            stringBuilder.insert(i + 2, nextChar).insert(i + 2, '&');
            if (!correctHex || indexOf != 0 || stringBuilder.length() < i + 28) continue;
            String part = stringBuilder.substring(i, i + 28);
            StringBuilder correct1 = new StringBuilder(14);
            StringBuilder correct2 = new StringBuilder(14);
            for (int j = 1; j < 28; j += 4) {
                char c = part.charAt(j);
                correct1.append('\u00a7').append(c >= 'A' && c <= 'Z' ? (char)(c + 32) : c);
                correct2.append('&').append(c);
            }
            stringBuilder.replace(i, i + 28, correct1 + correct2.toString());
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String restoreColored(@Nonnull String string) {
        Validate.notNull((Object)string, (String)"String cannot be null");
        char[] chars = string.toCharArray();
        for (int i = 0; i < chars.length - 1; ++i) {
            if (chars[i] != '\u00a7') continue;
            chars[i] = 38;
        }
        return new String(chars);
    }

    @Nonnull
    public static String getTextColor(@Nonnull BaseComponent component) {
        Validate.notNull((Object)component, (String)"TextComponent cannot be null");
        StringBuilder colorBuilder = new StringBuilder();
        if (component.getColorRaw() != null) {
            colorBuilder.append(component.getColorRaw());
        }
        if (component.isBoldRaw() != null && component.isBoldRaw().booleanValue()) {
            colorBuilder.append("\u00a7l");
        }
        if (component.isItalicRaw() != null && component.isItalicRaw().booleanValue()) {
            colorBuilder.append("\u00a7o");
        }
        if (component.isObfuscatedRaw() != null && component.isObfuscatedRaw().booleanValue()) {
            colorBuilder.append("\u00a7m");
        }
        if (component.isUnderlinedRaw() != null && component.isUnderlinedRaw().booleanValue()) {
            colorBuilder.append("\u00a7n");
        }
        return colorBuilder.toString();
    }

    @Nonnull
    private static String translateRGB(@Nonnull String string) {
        Validate.notNull((Object)string, (String)"String cannot be null");
        String result = string;
        Matcher matcher = pattern.matcher(result);
        while (matcher.find()) {
            StringBuilder stringBuilder = new StringBuilder(matcher.group(1));
            int i = stringBuilder.length();
            while (i > 0) {
                stringBuilder.insert(--i, '\u00a7');
            }
            stringBuilder.insert(0, "\u00a7x");
            result = result.replace(matcher.group(0), stringBuilder.toString());
        }
        return result;
    }
}

