/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public class FileUtils {
    public static boolean createFile(@NotNull File file) {
        File fileParent = file.getParentFile();
        if (!fileParent.exists() && !fileParent.mkdirs()) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void copyDirectoryOrFile(@NotNull File source, @NotNull File destination) throws IOException {
        if (!source.exists()) {
            return;
        }
        if (source.isDirectory()) {
            FileUtils.copyDirectory(source, destination);
        } else {
            FileUtils.copyFile(source, destination);
        }
    }

    public static void copyDirectory(@NotNull File sourceDirectory, @NotNull File destinationDirectory) throws IOException {
        if (!destinationDirectory.exists()) {
            destinationDirectory.mkdir();
        }
        for (String p : sourceDirectory.list()) {
            FileUtils.copyDirectoryOrFile(new File(sourceDirectory, p), new File(destinationDirectory, p));
        }
    }

    public static void copyFile(@NotNull File sourceFile, @NotNull File destinationFile) throws IOException {
        Files.copy(sourceFile.toPath(), destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    @NotNull
    public static List<File> getFolderFiles(@NotNull File folder, boolean deep, String suffix) {
        ArrayList<File> result = new ArrayList<File>();
        if (folder.exists()) {
            File[] files;
            for (File file : files = folder.listFiles()) {
                if (file.isFile() && (suffix == null || FileUtils.checkFileSuffix(file, suffix))) {
                    result.add(file);
                    continue;
                }
                if (!deep || !file.isDirectory()) continue;
                result.addAll(FileUtils.getFolderFiles(file, deep, suffix));
            }
        }
        return result;
    }

    public static boolean checkFileSuffix(@NotNull File file, @NotNull String suffix) {
        Validate.notNull((Object)file, (String)"File cannot be null");
        return FileUtils.checkFileSuffix(file.getName(), suffix);
    }

    public static boolean checkFileSuffix(@NotNull String fileName, @NotNull String suffix) {
        Validate.notNull((Object)fileName, (String)"FileName cannot be null");
        int length = fileName.length();
        int suffixLength = suffix.length();
        if (length > suffixLength) {
            String sub = fileName.substring(length - suffixLength, length);
            return sub.equalsIgnoreCase(suffix);
        }
        return false;
    }
}

