/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.util.scheduler;

import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.util.scheduler.PsrTask;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class PsrScheduler {
    private static final ProtocolStringReplacer PLUGIN = ProtocolStringReplacer.getInstance();
    private static final boolean FOLIA = PLUGIN.isFolia();

    private PsrScheduler() {
    }

    public static PsrTask runTaskTimerAsynchronously(Runnable runnable, long delay, long period) {
        if (FOLIA) {
            return new PsrTask(Bukkit.getServer().getAsyncScheduler().runAtFixedRate((Plugin)PLUGIN, val -> runnable.run(), delay * 50L, period * 50L, TimeUnit.MILLISECONDS));
        }
        return new PsrTask(Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)PLUGIN, runnable, delay, period));
    }

    public static PsrTask runTaskLaterAsynchronously(Runnable runnable, long delay) {
        if (FOLIA) {
            return new PsrTask(Bukkit.getServer().getAsyncScheduler().runDelayed((Plugin)PLUGIN, val -> runnable.run(), delay * 50L, TimeUnit.MILLISECONDS));
        }
        return new PsrTask(Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)PLUGIN, runnable, delay));
    }

    public static PsrTask runTaskAsynchronously(Runnable runnable) {
        if (FOLIA) {
            return new PsrTask(Bukkit.getServer().getAsyncScheduler().runNow((Plugin)PLUGIN, val -> runnable.run()));
        }
        return new PsrTask(Bukkit.getScheduler().runTaskAsynchronously((Plugin)PLUGIN, runnable));
    }

    public static void runTask(Runnable runnable) {
        if (FOLIA) {
            Bukkit.getServer().getGlobalRegionScheduler().run((Plugin)PLUGIN, (T val) -> runnable.run());
        } else {
            Bukkit.getScheduler().runTask((Plugin)PLUGIN, runnable);
        }
    }

    public static void run(Runnable runnable, Location location) {
        if (FOLIA) {
            Bukkit.getServer().getRegionScheduler().execute((Plugin)PLUGIN, location, runnable);
        } else {
            runnable.run();
        }
    }

    public static void runTaskLater(Runnable runnable, long delay) {
        if (FOLIA) {
            Bukkit.getServer().getGlobalRegionScheduler().runDelayed((Plugin)PLUGIN, val -> runnable.run(), delay);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)PLUGIN, runnable, delay);
        }
    }

    public static void runTaskLater(Runnable runnable, Location location, long delay) {
        if (FOLIA) {
            Bukkit.getServer().getRegionScheduler().runDelayed((Plugin)PLUGIN, location, val -> runnable.run(), delay);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)PLUGIN, runnable, delay);
        }
    }

    public static void cancelTasks() {
        if (FOLIA) {
            Bukkit.getServer().getGlobalRegionScheduler().cancelTasks((Plugin)PLUGIN);
            Bukkit.getServer().getAsyncScheduler().cancelTasks((Plugin)PLUGIN);
        } else {
            Bukkit.getScheduler().cancelTasks((Plugin)PLUGIN);
        }
    }
}

