/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.PsrLocalization;
import io.github.rothes.protocolstringreplacer.api.replacer.ReplacerConfig;
import io.github.rothes.protocolstringreplacer.lib.org.bstats.MetricsBase;
import io.github.rothes.protocolstringreplacer.lib.org.bstats.charts.CustomChart;
import io.github.rothes.protocolstringreplacer.lib.org.bstats.charts.DrilldownPie;
import io.github.rothes.protocolstringreplacer.lib.org.bstats.json.JsonObjectBuilder;
import io.github.rothes.protocolstringreplacer.replacer.ReplaceMode;
import io.github.rothes.protocolstringreplacer.util.scheduler.PsrScheduler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class Updater
implements Listener {
    private final HashMap<String, Integer> msgTimesMap = new HashMap();
    private final List<String> messages = new ArrayList<String>();
    private final ProtocolStringReplacer plugin;
    private final String VERSION_CHANNEL;
    private final int VERSION_NUMBER;
    private int errorCount = 0;

    Updater(ProtocolStringReplacer plugin) {
        this.plugin = plugin;
        YamlConfiguration meta = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(plugin.getResource("metadata.yml"), StandardCharsets.UTF_8));
        this.VERSION_CHANNEL = meta.getString("version-channel", "unknown");
        this.VERSION_NUMBER = meta.getInt("version-id");
    }

    public void start() {
        this.initMetrics();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        PsrScheduler.runTaskTimerAsynchronously(() -> {
            try {
                String host = this.plugin.getConfigManager().gitRawHost;
                if (host.isEmpty()) {
                    return;
                }
                String json = this.getJson(host, 0);
                if (json == null) {
                    return;
                }
                this.checkJson(json);
            }
            catch (Throwable e) {
                ProtocolStringReplacer.error(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Updater.Error-Parsing-Json", new String[0]), e);
            }
        }, 0L, 72000L);
    }

    @EventHandler
    public void playerJoin(PlayerJoinEvent e) {
        PsrScheduler.runTaskAsynchronously(() -> {
            if (e.getPlayer().hasPermission("protocolstringreplacer.updater.notify")) {
                for (String message : this.messages) {
                    e.getPlayer().sendMessage(PsrLocalization.getLocaledMessage("Sender.Prefix", new String[0]) + message);
                }
            }
        });
    }

    private void initMetrics() {
        BStatsMetrics bStatsMetrics = new BStatsMetrics(this.plugin, 11740);
        bStatsMetrics.addCustomChart(new DrilldownPie("Replaces_Count", () -> {
            int configs = 0;
            int replaces = 0;
            for (ReplacerConfig replacerConfig : this.plugin.getReplacerManager().getReplacerConfigList()) {
                ++configs;
                for (ReplaceMode mode : ReplaceMode.values()) {
                    replaces += replacerConfig.getReplaces(mode).size();
                }
            }
            HashMap map = new HashMap();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(replaces + (replaces > 1 ? " Replaces" : " Replace"), 1);
            map.put(configs + (configs > 1 ? " Configs" : " Config"), entry);
            return map;
        }));
        bStatsMetrics.addCustomChart(new DrilldownPie("Blocks_Count", () -> {
            int configs = 0;
            int blocks = 0;
            for (ReplacerConfig replacerConfig : this.plugin.getReplacerManager().getReplacerConfigList()) {
                ++configs;
                for (ReplaceMode mode : ReplaceMode.values()) {
                    blocks += replacerConfig.getBlocks(mode).size();
                }
            }
            HashMap map = new HashMap();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(blocks + (blocks > 1 ? " Blocks" : " Block"), 1);
            map.put(configs + (configs > 1 ? " Configs" : " Config"), entry);
            return map;
        }));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getJson(String domain, int tryTime) {
        try (InputStream stream = new URL("https://" + domain + "/Rothes/ProtocolStringReplacer/master/Version_Info.json").openStream();){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                StringBuilder jsonBuilder = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    jsonBuilder.append(line).append("\n");
                    line = reader.readLine();
                }
                new JsonParser().parse(jsonBuilder.toString());
                this.errorCount = Math.max(this.errorCount - 1, 0);
                string = jsonBuilder.toString();
            }
            return string;
        }
        catch (Throwable e) {
            if (tryTime == 0) {
                return this.getJson("ghfast.top/https://raw.githubusercontent.com", ++tryTime);
            }
            if (tryTime == 1) {
                return this.getJson("raw.githubusercontent.com", ++tryTime);
            }
            if (this.errorCount < 3) {
                ++this.errorCount;
                ProtocolStringReplacer.error(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Updater.Error-Checking-Version", e.toString()));
            }
            return null;
        }
    }

    private void checkJson(String json) {
        JsonElement element = new JsonParser().parse(json);
        JsonObject root = element.getAsJsonObject();
        JsonObject channels = root.getAsJsonObject("Version_Channels");
        this.messages.clear();
        if (channels.has(this.VERSION_CHANNEL)) {
            JsonObject channel = channels.getAsJsonObject(this.VERSION_CHANNEL);
            if (channel.has("Message") && channel.getAsJsonPrimitive("Latest_Version_Number").getAsInt() > this.VERSION_NUMBER) {
                this.sendJsonMessage(channel, "updater");
            }
        } else {
            ProtocolStringReplacer.warn(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Updater.Invalid-Channel", this.VERSION_CHANNEL));
            this.messages.add(PsrLocalization.getLocaledMessage("Console-Sender.Messages.Updater.Invalid-Channel", this.VERSION_CHANNEL));
            return;
        }
        for (Map.Entry entry : root.getAsJsonObject("Version_Actions").entrySet()) {
            JsonObject message;
            String[] split = ((String)entry.getKey()).split("-");
            if (Integer.parseInt(split[1]) <= this.VERSION_NUMBER || this.VERSION_NUMBER <= Integer.parseInt(split[0]) || !(message = (JsonObject)entry.getValue()).has("Message")) continue;
            this.sendJsonMessage(message, (String)entry.getKey());
        }
    }

    private void sendJsonMessage(JsonObject json, String id) {
        int curTimes;
        JsonObject msgJson = json.getAsJsonObject("Message");
        String msg = this.getLocaledJsonMessage(msgJson);
        if (msg == null) {
            return;
        }
        int msgTimes = json.has("Message_Times") ? json.get("Message_Times").getAsInt() : -1;
        int n = curTimes = this.msgTimesMap.get(id) == null ? 0 : this.msgTimesMap.get(id);
        if (msgTimes == -1 || curTimes < msgTimes) {
            String logLevel = json.has("Log_Level") ? json.get("Log_Level").getAsString() : "default maybe";
            block9: for (String s : msg.split("\n")) {
                if (!json.has("Notify_In_Game") || json.get("Notify_In_Game").getAsBoolean()) {
                    this.messages.add(s);
                }
                switch (logLevel) {
                    case "Error": {
                        ProtocolStringReplacer.error(s);
                        continue block9;
                    }
                    case "Warn": {
                        ProtocolStringReplacer.warn(s);
                        continue block9;
                    }
                    default: {
                        ProtocolStringReplacer.info(s);
                    }
                }
            }
            this.msgTimesMap.put(id, ++curTimes);
        }
        this.checkActions(json.getAsJsonArray("Actions"));
    }

    private void checkActions(JsonArray actions) {
        if (actions == null) {
            return;
        }
        for (JsonElement action : actions) {
            if (!action.getAsString().equals("Prohibit")) continue;
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            return;
        }
    }

    private String getLocaledJsonMessage(@NotNull JsonObject messageJson) {
        String msg = null;
        if (messageJson.has(PsrLocalization.getLocale())) {
            msg = messageJson.get(PsrLocalization.getLocale()).getAsString();
        } else if (messageJson.has("en-US")) {
            msg = messageJson.get("en-US").getAsString();
        }
        return msg;
    }

    static final class BStatsMetrics {
        private final Plugin plugin;
        private final MetricsBase metricsBase;

        public BStatsMetrics(JavaPlugin plugin, int serviceId) {
            this.plugin = plugin;
            File bStatsFolder = new File(plugin.getDataFolder().getParentFile(), "bStats");
            File configFile = new File(bStatsFolder, "config.yml");
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            if (!config.isSet("serverUuid")) {
                config.addDefault("enabled", (Object)true);
                config.addDefault("serverUuid", (Object)UUID.randomUUID().toString());
                config.addDefault("logFailedRequests", (Object)false);
                config.addDefault("logSentData", (Object)false);
                config.addDefault("logResponseStatusText", (Object)false);
                config.options().header("bStats (https://bStats.org) collects some basic information for plugin authors, like how\nmany people use their plugin and their total player count. It's recommended to keep bStats\nenabled, but if you're not comfortable with this, you can turn this setting off. There is no\nperformance penalty associated with having metrics enabled, and data sent to bStats is fully\nanonymous.").copyDefaults(true);
                try {
                    config.save(configFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            boolean enabled = config.getBoolean("enabled", true);
            String serverUUID = config.getString("serverUuid");
            boolean logErrors = config.getBoolean("logFailedRequests", false);
            boolean logSentData = config.getBoolean("logSentData", false);
            boolean logResponseStatusText = config.getBoolean("logResponseStatusText", false);
            this.metricsBase = new MetricsBase("bukkit", serverUUID, serviceId, enabled, this::appendPlatformData, this::appendServiceData, PsrScheduler::runTask, () -> ((JavaPlugin)plugin).isEnabled(), (message, error) -> this.plugin.getLogger().log(Level.WARNING, (String)message, (Throwable)error), message -> this.plugin.getLogger().log(Level.INFO, (String)message), logErrors, logSentData, logResponseStatusText);
        }

        public void shutdown() {
            this.metricsBase.shutdown();
        }

        public void addCustomChart(CustomChart chart) {
            this.metricsBase.addCustomChart(chart);
        }

        private void appendPlatformData(JsonObjectBuilder builder) {
            builder.appendField("playerAmount", this.getPlayerAmount());
            builder.appendField("onlineMode", Bukkit.getOnlineMode() ? 1 : 0);
            builder.appendField("bukkitVersion", Bukkit.getVersion());
            builder.appendField("bukkitName", Bukkit.getName());
            builder.appendField("javaVersion", System.getProperty("java.version"));
            builder.appendField("osName", System.getProperty("os.name"));
            builder.appendField("osArch", System.getProperty("os.arch"));
            builder.appendField("osVersion", System.getProperty("os.version"));
            builder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
        }

        private void appendServiceData(JsonObjectBuilder builder) {
            builder.appendField("pluginVersion", this.plugin.getDescription().getVersion());
        }

        private int getPlayerAmount() {
            try {
                Method onlinePlayersMethod = Class.forName("org.bukkit.Server").getMethod("getOnlinePlayers", new Class[0]);
                return onlinePlayersMethod.getReturnType().equals(Collection.class) ? ((Collection)onlinePlayersMethod.invoke((Object)Bukkit.getServer(), new Object[0])).size() : ((Player[])onlinePlayersMethod.invoke((Object)Bukkit.getServer(), new Object[0])).length;
            }
            catch (Exception e) {
                return Bukkit.getOnlinePlayers().size();
            }
        }
    }
}

