/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.api.capture;

import io.github.rothes.protocolstringreplacer.api.capture.CaptureInfo;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.replacer.ListenType;
import io.github.rothes.protocolstringreplacer.replacer.containers.Replaceable;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CaptureInfoImpl
implements CaptureInfo {
    private List<String> jsons;
    private List<String> texts;
    private List<String> directs;
    private ListenType listenType;
    private long time = -1L;
    private PsrUser user;
    private String description;
    private BaseComponent[] extra;
    private int count = 1;

    @Override
    @NotNull
    public List<String> getJsons() {
        return this.jsons;
    }

    @Override
    @NotNull
    public List<String> getTexts() {
        return this.texts;
    }

    @Override
    @NotNull
    public List<String> getDirects() {
        return this.directs;
    }

    @Override
    @NotNull
    public ListenType getListenType() {
        return this.listenType;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    @NotNull
    public PsrUser getUser() {
        return this.user;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public BaseComponent[] getExtra() {
        return this.extra;
    }

    @Override
    public void setJsons(@NotNull List<Replaceable> replaceables) {
        Validate.notNull(replaceables, (String)"Json replaceables cannot be null");
        if (this.jsons != null) {
            throw new IllegalStateException("Json replaceables have already been set");
        }
        ArrayList<String> jsons = new ArrayList<String>();
        for (Replaceable replaceable : replaceables) {
            jsons.add(replaceable.getText());
        }
        this.jsons = jsons;
    }

    @Override
    public void setTexts(@NotNull List<Replaceable> replaceables) {
        Validate.notNull(replaceables, (String)"Text replaceables cannot be null");
        if (this.texts != null) {
            throw new IllegalStateException("Text replaceables have already been set");
        }
        ArrayList<String> texts = new ArrayList<String>();
        for (Replaceable replaceable : replaceables) {
            texts.add(replaceable.getText());
        }
        this.texts = texts;
    }

    @Override
    public void setDirects(@NotNull List<String> strings) {
        Validate.notNull(strings, (String)"Direct strings cannot be null");
        if (this.directs != null) {
            throw new IllegalStateException("Direct strings have already been set");
        }
        this.directs = new ArrayList<String>(strings);
    }

    @Override
    public void setListenType(@NotNull ListenType listenType) {
        Validate.notNull((Object)((Object)listenType), (String)"ListenType cannot be null");
        if (this.listenType != null) {
            throw new IllegalStateException("ListenType has already been set");
        }
        this.listenType = listenType;
    }

    @Override
    public void setTime(long time) {
        if (this.time != -1L) {
            throw new IllegalStateException("Capture time has already been set");
        }
        this.time = time;
    }

    @Override
    public void setUser(@NotNull PsrUser user) {
        Validate.notNull((Object)user, (String)"PsrUser cannot be null");
        if (this.user != null) {
            throw new IllegalStateException("PsrUser has already been set");
        }
        this.user = user;
    }

    @Override
    public void setDescription(@NotNull String description) {
        Validate.notNull((Object)description, (String)"Description String cannot be null");
        if (this.description != null) {
            throw new IllegalStateException("Description has already been set");
        }
        this.description = description;
    }

    @Override
    public void setExtra(@NotNull BaseComponent[] extra) {
        this.extra = extra;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }
}

