/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.api.user;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.ComponentConverter;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import de.tr7zw.nbtapi.NBT;
import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.api.capture.CaptureInfo;
import io.github.rothes.protocolstringreplacer.replacer.FileReplacerConfig;
import io.github.rothes.protocolstringreplacer.replacer.ListenType;
import io.github.rothes.protocolstringreplacer.util.SpigotUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;

public class PsrUser {
    private static final Method getLocaleLegacy = PsrUser.getLegacyLocaleMethod();
    private UUID uuid;
    private Player player;
    private CommandSender sender;
    private final HashMap<Short, ItemStack> itemRestoreCache = new HashMap();
    private String currentWindowTitle;
    private String clientLocale;
    private boolean inAnvil;
    private boolean inMerchant;
    private Short uniqueCacheKey = 0;
    private String[] commandToConfirm;
    private long confirmTime;
    private final Set<ListenType> captureTypes = new HashSet<ListenType>();
    private final HashMap<ListenType, ArrayList<CaptureInfo>> captures = new HashMap();
    private FileReplacerConfig editorReplacerConfig;

    public PsrUser(Player player) {
        this.player = player;
        this.uuid = player.getUniqueId();
        this.sender = player;
        if (ProtocolStringReplacer.getInstance().getServerMajorVersion() >= 12) {
            this.setClientLocale(this.getPlayer().getLocale());
        } else {
            Player.Spigot spigot = this.getPlayer().spigot();
            try {
                this.setClientLocale((String)getLocaleLegacy.invoke((Object)spigot, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    public PsrUser(UUID uuid) {
        this.uuid = uuid;
        this.player = Bukkit.getPlayer((UUID)uuid);
        this.sender = this.player;
        if (ProtocolStringReplacer.getInstance().getServerMajorVersion() >= 12) {
            this.setClientLocale(this.getPlayer().getLocale());
        } else {
            Player.Spigot spigot = this.getPlayer().spigot();
            try {
                this.setClientLocale((String)getLocaleLegacy.invoke((Object)spigot, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    public PsrUser(CommandSender sender) {
        this.sender = sender;
        if (sender instanceof Player) {
            this.player = (Player)sender;
            this.uuid = this.player.getUniqueId();
        }
    }

    private static Method getLegacyLocaleMethod() {
        try {
            return Player.Spigot.class.getDeclaredMethod("getLocale", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public Player getPlayer() {
        return this.player;
    }

    public HashMap<Short, ItemStack> getItemRestoreCache() {
        return this.itemRestoreCache;
    }

    public Short nextUniqueCacheKey() {
        this.uniqueCacheKey = (short)(this.uniqueCacheKey + 1);
        return this.uniqueCacheKey;
    }

    public String getCurrentWindowTitle() {
        return this.currentWindowTitle;
    }

    public String getClientLocale() {
        return this.clientLocale;
    }

    public void setClientLocale(String clientLocale) {
        this.clientLocale = clientLocale;
    }

    public boolean isInAnvil() {
        return this.inAnvil;
    }

    public boolean isInMerchant() {
        return this.inMerchant;
    }

    public String[] getCommandToConfirm() {
        return this.commandToConfirm;
    }

    public FileReplacerConfig getEditorReplacerConfig() {
        return this.editorReplacerConfig;
    }

    public boolean isOnline() {
        return this.player != null && this.player.isOnline();
    }

    public boolean hasPermissionOrOp(String permission) {
        return this.hasPermission(permission) || this.sender.isOp() && !this.getSender().isPermissionSet(permission);
    }

    public boolean hasPermission(String permission) {
        return this.sender.hasPermission(permission);
    }

    public boolean hasPermission(Permission permission) {
        return this.isOnline() && this.player.hasPermission(permission);
    }

    public void setCurrentWindowTitle(String title) {
        this.currentWindowTitle = title;
    }

    public void setInAnvil(boolean inAnvil) {
        this.inAnvil = inAnvil;
    }

    public void setInMerchant(boolean inMerchant) {
        this.inMerchant = inMerchant;
    }

    public void addCaptureType(ListenType listenType) {
        this.captureTypes.add(listenType);
        this.captures.put(listenType, new ArrayList(ProtocolStringReplacer.getInstance().getConfigManager().maxCaptureRecords));
    }

    public void removeCaptureType(ListenType listenType) {
        this.captureTypes.remove((Object)listenType);
        this.captures.remove((Object)listenType);
    }

    public boolean isCapturing(ListenType listenType) {
        return this.captureTypes.contains((Object)listenType);
    }

    public void addCaptureInfo(ListenType listenType, CaptureInfo info) {
        ArrayList<CaptureInfo> captureInfos = this.captures.get((Object)listenType);
        Iterator<CaptureInfo> iterator2 = captureInfos.iterator();
        while (iterator2.hasNext()) {
            CaptureInfo next = iterator2.next();
            if (!next.isSimilar(info)) continue;
            iterator2.remove();
            next.setCount(next.getCount() + 1);
            captureInfos.add(next);
            return;
        }
        if (captureInfos.size() == ProtocolStringReplacer.getInstance().getConfigManager().maxCaptureRecords) {
            captureInfos.remove(ProtocolStringReplacer.getInstance().getConfigManager().maxCaptureRecords - 1);
        }
        this.captures.get((Object)listenType).add(info);
    }

    public List<CaptureInfo> getCaptureInfos(ListenType listenType) {
        return this.captures.get((Object)listenType);
    }

    public void setEditorReplacerConfig(FileReplacerConfig editorReplacerConfig) {
        this.editorReplacerConfig = editorReplacerConfig;
    }

    public void setCommandToConfirm(String[] args2) {
        this.commandToConfirm = args2;
        this.confirmTime = System.currentTimeMillis();
    }

    public boolean isConfirmed(@Nonnull String[] args2) {
        Validate.notNull((Object)args2, (String)"Arguments cannot be null");
        return Arrays.equals(args2, this.commandToConfirm);
    }

    public boolean hasCommandToConfirm() {
        return this.commandToConfirm != null;
    }

    public void clearCommandToConfirm() {
        this.commandToConfirm = null;
        this.confirmTime = -1L;
    }

    public boolean isConfirmExpired() {
        return this.confirmTime != -1L && System.currentTimeMillis() - this.confirmTime > 15000L;
    }

    public void sendFilteredMessage(BaseComponent ... baseComponents) {
        if (this.sender instanceof ConsoleCommandSender) {
            if (ProtocolStringReplacer.getInstance().getServerMajorVersion() >= 12) {
                this.sender.spigot().sendMessage(baseComponents);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                for (BaseComponent component : baseComponents) {
                    stringBuilder.append(component.toLegacyText());
                }
                this.sender.sendMessage(stringBuilder.toString());
            }
        } else {
            PacketContainer packet;
            if (ProtocolStringReplacer.getInstance().getServerMajorVersion() >= 19) {
                packet = new PacketContainer(PacketType.Play.Server.SYSTEM_CHAT);
                StructureModifier stringModifier = packet.getStrings();
                if (stringModifier.size() == 0) {
                    packet.getChatComponents().write(0, (Object)WrappedChatComponent.fromJson((String)SpigotUtils.serializeComponents(baseComponents)));
                } else {
                    stringModifier.write(0, (Object)SpigotUtils.serializeComponents(baseComponents));
                }
                StructureModifier booleans = packet.getBooleans();
                if (booleans.size() >= 1) {
                    booleans.write(0, (Object)false);
                } else {
                    packet.getIntegers().write(0, (Object)EnumWrappers.ChatType.SYSTEM.getId());
                }
            } else {
                packet = new PacketContainer(PacketType.Play.Server.CHAT);
                packet.getChatComponents().write(0, (Object)ComponentConverter.fromBaseComponent((BaseComponent[])baseComponents));
                packet.getChatTypes().write(0, (Object)EnumWrappers.ChatType.SYSTEM);
            }
            packet.setMeta("psr_filtered_packet", (Object)true);
            ProtocolLibrary.getProtocolManager().sendServerPacket(this.player, packet);
        }
    }

    public void sendFilteredMessage(String json) {
        this.sendFilteredMessage(SpigotUtils.parseComponents(json));
    }

    public void sendFilteredText(String text) {
        this.sendFilteredMessage(TextComponent.fromLegacyText((String)text));
    }

    public void sendMessage(BaseComponent ... components) {
        this.sender.spigot().sendMessage(components);
    }

    public void sendActionBar(BaseComponent ... components) {
        ((Player)this.sender).spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
    }

    public void sendMessage(String text) {
        this.sender.sendMessage(text);
    }

    public void clearUserItemRestoreCache() {
        this.getItemRestoreCache().clear();
        this.uniqueCacheKey = 0;
    }

    public void saveUserItemRestoreCache(ItemStack originalItem, ItemStack replacedItem) {
        if (this.hasPermission("protocolstringreplacer.feature.usermetacache")) {
            if (ProtocolStringReplacer.getInstance().getConfigManager().removeCacheWhenMerchantTrade && this.isInMerchant()) {
                return;
            }
            NBT.modify((ItemStack)replacedItem, nbt -> nbt.getOrCreateCompound("ProtocolStringReplacer").setShort("UserMetaCacheKey", this.nextUniqueCacheKey()));
            this.getItemRestoreCache().put(this.uniqueCacheKey, originalItem);
        }
    }

    public String toString() {
        return "user{uuid=" + this.uuid + ", player=" + this.player + ", currentWindowTitle='" + this.currentWindowTitle + '\'' + ", metaCache=" + this.itemRestoreCache + ", uniqueCacheKey=" + this.uniqueCacheKey + ", editorReplacerConfig=" + this.editorReplacerConfig + '}';
    }
}

