/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.command;

import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.PsrLocalization;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.command.SubCommand;
import io.github.rothes.protocolstringreplacer.command.subcommands.About;
import io.github.rothes.protocolstringreplacer.command.subcommands.Capture;
import io.github.rothes.protocolstringreplacer.command.subcommands.Edit;
import io.github.rothes.protocolstringreplacer.command.subcommands.Parse;
import io.github.rothes.protocolstringreplacer.command.subcommands.Reload;
import io.github.rothes.protocolstringreplacer.util.ArgUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Sound;
import org.bukkit.block.CommandBlock;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CommandHandler
implements TabCompleter,
CommandExecutor {
    private final LinkedList<SubCommand> subCommands = new LinkedList();
    private final ProtocolStringReplacer plugin = ProtocolStringReplacer.getInstance();

    public void initialize() {
        this.plugin.getCommand("ProtocolStringReplacer").setExecutor((CommandExecutor)this);
        this.plugin.getCommand("ProtocolStringReplacer").setTabCompleter((TabCompleter)this);
        this.subCommands.add(new Capture());
        this.subCommands.add(new Edit());
        this.subCommands.add(new Parse());
        this.subCommands.add(new About());
        this.subCommands.add(new Reload());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (sender instanceof CommandBlock) {
            sender.sendMessage(PsrLocalization.getLocaledMessage("Command-Block-Sender.Messages.Command-Not-Available", new String[0]));
        } else {
            PsrUser user = this.plugin.getUserManager().getUser(sender);
            if (args2.length > 0) {
                String[] mergedArgs = ArgUtils.mergeQuotes(args2);
                if (mergedArgs[0].equalsIgnoreCase("confirm")) {
                    if (user.hasCommandToConfirm()) {
                        if (user.isConfirmExpired()) {
                            user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Confirm.Expired", new String[0]));
                            user.clearCommandToConfirm();
                            return true;
                        }
                        mergedArgs = user.getCommandToConfirm();
                    } else {
                        user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Confirm.Nothing-To-Confirm", new String[0]));
                        return true;
                    }
                }
                for (SubCommand subCommand : this.subCommands) {
                    if (!mergedArgs[0].equalsIgnoreCase(subCommand.getName())) continue;
                    if (user.hasPermissionOrOp(subCommand.getPermission())) {
                        subCommand.onExecute(user, mergedArgs);
                    } else {
                        user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.No-Permission", new String[0]));
                    }
                    return true;
                }
            }
            this.sendHelp(user);
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args2) {
        if (this.plugin.getConfigManager().cmdTypingSound && sender instanceof Player && this.plugin.getServerMajorVersion() >= 9) {
            Player player = (Player)sender;
            player.playSound(player.getLocation(), Sound.BLOCK_DISPENSER_FAIL, 80.0f, 1.0f);
        }
        String[] mergedArgs = ArgUtils.mergeQuotes(args2);
        List<String> list = new ArrayList<String>();
        PsrUser user = this.plugin.getUserManager().getUser(sender);
        if (mergedArgs.length == 1) {
            list.add("help");
            if (user.hasCommandToConfirm() && !user.isConfirmExpired()) {
                list.add("confirm");
            }
            for (SubCommand subCommand : this.subCommands) {
                if (!user.hasPermissionOrOp(subCommand.getPermission())) continue;
                list.add(subCommand.getName());
            }
        } else {
            for (SubCommand subCommand : this.subCommands) {
                if (!subCommand.getName().equalsIgnoreCase(mergedArgs[0])) continue;
                list = subCommand.onTab(user, mergedArgs);
            }
        }
        return list;
    }

    public void sendHelp(@Nonnull PsrUser user) {
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Help.Header", new String[0]));
        for (SubCommand subCommand : this.subCommands) {
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Subcommand-Help-Format", "/psr " + subCommand.getName(), subCommand.getDescription()));
        }
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Help.Footer", new String[0]));
    }
}

