/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.command.subcommands;

import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.PsrLocalization;
import io.github.rothes.protocolstringreplacer.api.capture.CaptureInfo;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.command.SubCommand;
import io.github.rothes.protocolstringreplacer.replacer.ListenType;
import io.github.rothes.protocolstringreplacer.util.MessageUtils;
import io.github.rothes.protocolstringreplacer.util.scheduler.PsrScheduler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class Capture
extends SubCommand {
    public Capture() {
        super("capture", "protocolstringreplacer.command.capture", PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Description", new String[0]));
    }

    @Override
    public void onExecute(@Nonnull PsrUser user, @Nonnull String[] args2) {
        if (!user.isOnline()) {
            user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Console-Sender.Messages.Command-Not-Available", new String[0]));
            return;
        }
        if (args2.length > 1) {
            if ("add".equalsIgnoreCase(args2[1])) {
                this.addCommand(user, args2);
                return;
            }
            if ("remove".equalsIgnoreCase(args2[1])) {
                this.removeCommand(user, args2);
                return;
            }
            if ("list".equalsIgnoreCase(args2[1])) {
                this.listCommand(user, args2);
                return;
            }
            if ("clipboard".equalsIgnoreCase(args2[1])) {
                this.clipboardCommand(user, args2);
                return;
            }
        }
        this.sendHelp(user);
    }

    private void addCommand(@Nonnull PsrUser user, @Nonnull String[] args2) {
        if (args2.length == 3) {
            ListenType listenType = ListenType.getType(args2[2]);
            if (listenType == null) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Variables.Listen-Type.Messages.Invalid-Type", args2[2]));
                return;
            }
            if (!listenType.isCapturable()) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Capture.Children.Add.Listen-Type-Cannot-Be-Captured", new String[0]));
                return;
            }
            if (!ProtocolStringReplacer.getInstance().getConfig().getBoolean("Options.Features.Packet-Listener.Listen-Type-Enabled." + listenType.getName(), false)) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Capture.Children.Add.Listen-Type-Not-Enabled", new String[0]));
                return;
            }
            if (user.isCapturing(listenType)) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Capture.Children.Add.Already-Capturing-Listen-Type", listenType.getName()));
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Capture.Remove-Capture-Tip", listenType.getName()));
                return;
            }
            user.addCaptureType(listenType);
            user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Capture.Children.Add.Capture-Added", listenType.getName()));
            user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Capture.Children.Add.Capture-Usage-Tip", listenType.getName()));
        } else {
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Children.Add.Detailed-Help", new String[0]));
        }
    }

    private void removeCommand(@Nonnull PsrUser user, @Nonnull String[] args2) {
        if (args2.length == 3) {
            ListenType listenType = ListenType.getType(args2[2]);
            if (listenType == null) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Variables.Listen-Type.Messages.Invalid-Type", args2[2]));
                return;
            }
            if (!user.isCapturing(listenType)) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Capture.Children.Remove.Already-Not-Capturing-Listen-Type", listenType.getName()));
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Capture.Add-Capture-Tip", listenType.getName()));
                return;
            }
            user.removeCaptureType(listenType);
            user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Capture.Children.Remove.Capture-Removed", listenType.getName()));
        } else {
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Children.Remove.Detailed-Help", new String[0]));
        }
    }

    private void listCommand(@Nonnull PsrUser user, @Nonnull String[] args2) {
        if (args2.length == 3 || args2.length == 4) {
            PsrScheduler.runTaskAsynchronously(() -> {
                ListenType listenType = ListenType.getType(args2[2]);
                if (listenType == null) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Variables.Listen-Type.Messages.Invalid-Type", args2[2]));
                    return;
                }
                if (!user.isCapturing(listenType)) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Capture.Children.List.Not-Capturing-Listen-Type", listenType.getName()));
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Capture.Add-Capture-Tip", listenType.getName()));
                    return;
                }
                int page = 1;
                if (args2.length == 4) {
                    if (StringUtils.isNumeric((String)args2[3])) {
                        page = Integer.parseInt(args2[3]);
                    } else {
                        user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Not-A-Positive-Integer", args2[3]));
                        return;
                    }
                }
                user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Children.List.Results-Header", new String[0]));
                List<CaptureInfo> captureMessages = user.getCaptureInfos(listenType);
                int size = captureMessages.size();
                int totalPage = (int)Math.ceil((float)size / 10.0f);
                int sent = 0;
                for (int i = size - 1 - (page - 1) * 10; i >= 0 && ++sent <= 10; --i) {
                    MessageUtils.sendCaptureInfo(user, captureMessages.get(i), i);
                }
                MessageUtils.sendPageButtons(user, "/psr capture list " + args2[2] + " ", page, totalPage);
                user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Children.List.Results-Footer", new String[0]));
            });
        } else {
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Children.List.Detailed-Help", new String[0]));
        }
    }

    private void clipboardCommand(@Nonnull PsrUser user, @Nonnull String[] args2) {
        if (args2.length == 4) {
            PsrScheduler.runTaskAsynchronously(() -> {
                ListenType listenType = ListenType.getType(args2[2]);
                if (!user.isCapturing(listenType)) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Capture.Children.List.Not-Capturing-Listen-Type", listenType.getName()));
                    return;
                }
                List<CaptureInfo> captureInfos = user.getCaptureInfos(listenType);
                int index = Integer.parseInt(args2[3]);
                if (captureInfos.size() <= index) {
                    return;
                }
                MessageUtils.sendCaptureInfoClipboard(user, captureInfos.get(index));
                user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Capture-Info.Click-Any-Entry-To-Copy", new String[0]));
            });
        }
    }

    @Override
    public List<String> onTab(@NotNull PsrUser user, @NotNull String[] args2) {
        ArrayList<String> list = new ArrayList<String>();
        if (args2.length == 2) {
            list = Arrays.asList("add", "remove", "list");
        } else if (args2.length == 3 && args2[1].equalsIgnoreCase("add") || args2[1].equalsIgnoreCase("remove") || args2[1].equalsIgnoreCase("list")) {
            list.add("<" + PsrLocalization.getLocaledMessage("Variables.Listen-Type.Name", new String[0]) + ">");
            for (ListenType listenType : ListenType.values()) {
                if (!listenType.isCapturable()) continue;
                list.add(listenType.getName().toLowerCase(Locale.ENGLISH));
            }
        } else if (args2.length == 4 && args2[1].equalsIgnoreCase("list")) {
            list.add("[" + PsrLocalization.getLocaledMessage("Variables.Page.Name", new String[0]) + "]");
        }
        return list;
    }

    @Override
    public void sendHelp(@Nonnull PsrUser user) {
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Help.Header", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Children.Add.Simple-Help", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Children.Remove.Simple-Help", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Children.List.Simple-Help", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Capture.Help.Footer", new String[0]));
    }
}

