/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.command.subcommands;

import io.github.rothes.protocolstringreplacer.PsrLocalization;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.command.SubCommand;
import io.github.rothes.protocolstringreplacer.command.subcommands.editchildren.Block;
import io.github.rothes.protocolstringreplacer.command.subcommands.editchildren.File;
import io.github.rothes.protocolstringreplacer.command.subcommands.editchildren.Replace;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;

public class Edit
extends SubCommand {
    private final LinkedList<SubCommand> childCommands = new LinkedList();

    public Edit() {
        super("edit", "protocolstringreplacer.command.edit", PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Description", new String[0]));
        this.childCommands.add(new File());
        this.childCommands.add(new Replace());
        this.childCommands.add(new Block());
    }

    @Override
    public void onExecute(@Nonnull PsrUser user, @Nonnull String[] args2) {
        if (args2.length > 1) {
            for (SubCommand childCommand : this.childCommands) {
                if (!childCommand.getName().equalsIgnoreCase(args2[1])) continue;
                if (user.hasPermissionOrOp(childCommand.getPermission())) {
                    childCommand.onExecute(user, args2);
                } else {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.No-Permission", new String[0]));
                }
                return;
            }
        }
        this.sendHelp(user);
    }

    @Override
    public List<String> onTab(@NotNull PsrUser user, @NotNull String[] args2) {
        List<String> list = new ArrayList<String>();
        if (args2.length == 2) {
            list.add("help");
            for (SubCommand childCommand : this.childCommands) {
                if (!user.hasPermissionOrOp(childCommand.getPermission())) continue;
                list.add(childCommand.getName());
            }
        } else {
            for (SubCommand childCommand : this.childCommands) {
                if (!childCommand.getName().equalsIgnoreCase(args2[1])) continue;
                list = childCommand.onTab(user, args2);
            }
        }
        return list;
    }

    @Override
    public void sendHelp(@Nonnull PsrUser user) {
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Help.Header", new String[0]));
        for (SubCommand childCommand : this.childCommands) {
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Subcommand-Help-Format", "/psr edit " + childCommand.getName(), childCommand.getDescription()));
        }
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Help.Footer", new String[0]));
    }
}

