/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.command.subcommands;

import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.PsrLocalization;
import io.github.rothes.protocolstringreplacer.api.replacer.ReplacerConfig;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.command.SubCommand;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.Emit;
import io.github.rothes.protocolstringreplacer.replacer.ListenType;
import io.github.rothes.protocolstringreplacer.replacer.ReplaceMode;
import io.github.rothes.protocolstringreplacer.util.ColorUtils;
import io.github.rothes.protocolstringreplacer.util.scheduler.PsrScheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Parse
extends SubCommand {
    public Parse() {
        super("parse", "protocolstringreplacer.command.parse", PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Description", new String[0]));
    }

    @Override
    public void onExecute(@NotNull PsrUser user, @NotNull String[] args2) {
        if (args2.length == 5) {
            Player player;
            if ("null".equals(args2[2])) {
                player = null;
            } else {
                player = Bukkit.getPlayer((String)args2[2]);
                if (player == null) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Variables.Player.Messages.Player-Is-Offline", args2[2]));
                    return;
                }
            }
            ListenType listenType = ListenType.getType(args2[3]);
            if (listenType == null) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Variables.Listen-Type.Messages.Invalid-Type", args2[3]));
                return;
            }
            ReplaceMode replaceMode = null;
            for (ReplaceMode mode : ReplaceMode.values()) {
                if (!mode.getNode().equalsIgnoreCase(args2[4])) continue;
                replaceMode = mode;
                break;
            }
            if (replaceMode == null) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Variables.Match-Mode.Messages.Invalid-Mode", args2[4]));
                return;
            }
            user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Parse.Start-Parse", new String[0]));
            ReplaceMode finalReplaceMode = replaceMode;
            PsrScheduler.runTaskAsynchronously(() -> this.startParse(user, args2[1], player, listenType, finalReplaceMode));
            return;
        }
        this.sendHelp(user);
    }

    private void startParse(@NotNull PsrUser user, @NotNull String originalText, Player player, @NotNull ListenType listenType, @NotNull ReplaceMode replaceMode) {
        String original;
        long startTime = System.nanoTime();
        String text = original = ColorUtils.getColored(originalText);
        ArrayList<HoverEvent> results = new ArrayList<HoverEvent>();
        for (ReplacerConfig replacerConfig : ProtocolStringReplacer.getInstance().getReplacerManager().getReplacerConfigList()) {
            if (!replacerConfig.getListenTypeList().contains((Object)listenType)) continue;
            switch (replacerConfig.getMatchMode()) {
                case CONTAIN: {
                    text = this.containResult(results, text, replacerConfig, replaceMode);
                    break;
                }
                case EQUAL: {
                    text = this.equalResult(results, text, replacerConfig, replaceMode);
                    break;
                }
                case REGEX: {
                    text = this.regexResult(results, text, replacerConfig, replaceMode);
                    break;
                }
            }
        }
        ComponentBuilder placeholderMessage = new ComponentBuilder(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Result.PAPI-Replace.Start-Prefix", new String[0]));
        if (ProtocolStringReplacer.getInstance().getConfigManager().placeholderEnabled && ProtocolStringReplacer.getInstance().getReplacerManager().hasPlaceholder(text)) {
            String original1 = text;
            PsrUser placeholderTarget = player == null ? ProtocolStringReplacer.getInstance().getUserManager().getConsoleUser() : ProtocolStringReplacer.getInstance().getUserManager().getUser(player);
            text = ProtocolStringReplacer.getInstance().getReplacerManager().setPlaceholder(placeholderTarget, text);
            placeholderMessage.append(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Result.PAPI-Replace.Replaced", new String[0])).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)PsrLocalization.getLocaledMessage("Sender.Commands.Parse.PAPI-Replace-Info", placeholderTarget.getPlayer() == null ? "\u00a77\u00a7onull" : placeholderTarget.getPlayer().getName(), ColorUtils.showColorCodes(original1), ColorUtils.showColorCodes(text)))));
        } else {
            placeholderMessage.append(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Result.PAPI-Replace.Not-Replaced", new String[0]));
        }
        double duration = (double)(System.nanoTime() - startTime) / 1000000.0;
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Result.Header", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Result.Duration", String.valueOf(duration)));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Result.Listen-Type", listenType.getName()));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Result.Match-Mode", PsrLocalization.getLocaledMessage(replaceMode.getLocaleKey(), new String[0])));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Result.Original-Text", ColorUtils.showColorCodes(original)));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Result.Final-Text", ColorUtils.showColorCodes(text)));
        ComponentBuilder componentBuilder = new ComponentBuilder(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Result.Steps.Start-Prefix", new String[0]));
        if (results.isEmpty()) {
            componentBuilder.append(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Result.Steps.Noting-Replaced", new String[0]));
        } else {
            for (int i = 0; i < results.size(); ++i) {
                componentBuilder.append(" " + (i + 1) + " ");
                if (i % 2 == 1) {
                    componentBuilder.color(ChatColor.YELLOW);
                } else {
                    componentBuilder.color(ChatColor.GOLD);
                }
                componentBuilder.event(results.get(i)).append("|").reset();
            }
            componentBuilder.append(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Result.Steps.Hover-To-View-Info", new String[0])).reset();
        }
        user.sendFilteredMessage(componentBuilder.create());
        user.sendFilteredMessage(placeholderMessage.create());
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Result.Footer", new String[0]));
    }

    @NotNull
    private String containResult(@NotNull ArrayList<HoverEvent> results, @NotNull String text, @NotNull ReplacerConfig replacerConfig, @NotNull ReplaceMode replaceMode) {
        replacerConfig.getReplacesStringSearcher(replaceMode);
        int i = 0;
        StringBuilder resultBuilder = new StringBuilder();
        for (Emit<String> emit : replacerConfig.getReplacesStringSearcher(replaceMode).parseText(text)) {
            if (emit.getStart() > i) {
                resultBuilder.append(text, i, emit.getStart());
            }
            resultBuilder.append(emit.getPayload());
            i = emit.getEnd() + 1;
            results.add(new HoverEvent(HoverEvent.Action.SHOW_TEXT, this.createReplaceResultInfo(results, replacerConfig, replaceMode, emit.getSearchString(), emit.getPayload(), resultBuilder + (i < text.length() ? text.substring(i) : ""))));
        }
        if (i < text.length()) {
            resultBuilder.append(text.substring(i));
        }
        return resultBuilder.toString();
    }

    @NotNull
    private String equalResult(@NotNull ArrayList<HoverEvent> results, @NotNull String text, @NotNull ReplacerConfig replacerConfig, @NotNull ReplaceMode replaceMode) {
        Object result = replacerConfig.getReplaces(replaceMode).get(text);
        if (result != null) {
            String resultString = (String)result;
            results.add(new HoverEvent(HoverEvent.Action.SHOW_TEXT, this.createReplaceResultInfo(results, replacerConfig, replaceMode, text, resultString, resultString)));
            return resultString;
        }
        return text;
    }

    @NotNull
    private String regexResult(@NotNull ArrayList<HoverEvent> results, @NotNull String text, @NotNull ReplacerConfig replacerConfig, @NotNull ReplaceMode replaceMode) {
        String result = text;
        Set containSet = replacerConfig.getReplaces(replaceMode).entrySet();
        for (Map.Entry entry : containSet) {
            Pattern key = (Pattern)entry.getKey();
            String value = (String)entry.getValue();
            Matcher matcher = key.matcher(result);
            while (matcher.find()) {
                result = matcher.replaceAll(value);
                results.add(new HoverEvent(HoverEvent.Action.SHOW_TEXT, this.createReplaceResultInfo(results, replacerConfig, replaceMode, key.toString(), value, result)));
            }
        }
        return result;
    }

    @NotNull
    private BaseComponent[] createReplaceResultInfo(@NotNull ArrayList<HoverEvent> results, @NotNull ReplacerConfig replacerConfig, @NotNull ReplaceMode replaceMode, @NotNull String original, @NotNull String replacement, @NotNull String result) {
        return TextComponent.fromLegacyText((String)PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Replace-Result-Info", String.valueOf(results.size() + 1), replacerConfig.getRelativePath(), PsrLocalization.getLocaledMessage(replaceMode.getLocaleKey(), new String[0]), ColorUtils.showColorCodes(original), ColorUtils.showColorCodes(replacement), ColorUtils.showColorCodes(result)));
    }

    @Override
    public List<String> onTab(@NotNull PsrUser user, @NotNull String[] args2) {
        ArrayList<String> list;
        block4: {
            block6: {
                block5: {
                    block3: {
                        list = new ArrayList<String>();
                        if (args2.length != 2) break block3;
                        list.add(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Tab-Complete.String-To-Parse", new String[0]));
                        break block4;
                    }
                    if (args2.length != 3) break block5;
                    list.add(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Tab-Complete.PAPI-Target", new String[0]));
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        list.add(player.getName());
                    }
                    list.add("null");
                    break block4;
                }
                if (args2.length != 4) break block6;
                list.add("<" + PsrLocalization.getLocaledMessage("Variables.Listen-Type.Name", new String[0]) + ">");
                for (ListenType listenType : ListenType.values()) {
                    list.add(listenType.getName());
                }
                break block4;
            }
            if (args2.length != 5) break block4;
            list.add("<" + PsrLocalization.getLocaledMessage("Variables.Match-Mode.Name", new String[0]) + ">");
            for (ReplaceMode replaceMode : ReplaceMode.values()) {
                list.add(replaceMode.getNode());
            }
        }
        return list;
    }

    @Override
    public void sendHelp(@NotNull PsrUser user) {
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Help.Header", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Help.Line-1", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Help.Line-2", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Help.Line-3", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Help.Line-4", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Parse.Help.Footer", new String[0]));
    }
}

