/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.command.subcommands.editchildren;

import io.github.rothes.protocolstringreplacer.PsrLocalization;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.command.SubCommand;
import io.github.rothes.protocolstringreplacer.lib.org.apache.commons.collections.map.ListOrderedMap;
import io.github.rothes.protocolstringreplacer.replacer.FileReplacerConfig;
import io.github.rothes.protocolstringreplacer.replacer.ReplaceMode;
import io.github.rothes.protocolstringreplacer.util.ArgUtils;
import io.github.rothes.protocolstringreplacer.util.ColorUtils;
import io.github.rothes.protocolstringreplacer.util.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class Replace
extends SubCommand {
    public Replace() {
        super("replace", "protocolstringreplacer.command.edit", PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Replace.Description", new String[0]));
    }

    @Override
    public void onExecute(@Nonnull PsrUser user, @NotNull String[] args2) {
        if (user.getEditorReplacerConfig() == null) {
            user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.Replace.Not-Selected-Replacer-Config", new String[0]));
            return;
        }
        if (args2.length > 2) {
            if ("list".equalsIgnoreCase(args2[2])) {
                this.listCommand(user, args2);
                return;
            }
            if ("set".equalsIgnoreCase(args2[2])) {
                this.setCommand(user, args2);
                return;
            }
            if ("add".equalsIgnoreCase(args2[2])) {
                this.addCommand(user, args2);
                return;
            }
            if ("remove".equalsIgnoreCase(args2[2])) {
                this.removeCommand(user, args2);
                return;
            }
        }
        this.sendHelp(user);
    }

    private void listCommand(@Nonnull PsrUser user, @NotNull String[] args2) {
        if (args2.length < 6 && args2.length > 3) {
            int page = 1;
            ReplaceMode replaceMode = this.getReplacesMode(args2[3]);
            if (replaceMode == null) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Variables.Match-Mode.Messages.Invalid-Mode", args2[3]));
                return;
            }
            ListOrderedMap replaces = user.getEditorReplacerConfig().getReplaces(replaceMode);
            int totalPage = (int)Math.ceil((float)replaces.size() / 5.0f);
            if (args2.length == 5) {
                if (StringUtils.isNumeric((String)args2[4])) {
                    page = Integer.parseInt(args2[4]);
                } else {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Not-A-Positive-Integer", args2[4]));
                    return;
                }
            }
            if (page > totalPage) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Page-Exceed", String.valueOf(totalPage)));
                return;
            }
            if (page < 1) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Page-Low", new String[0]));
                return;
            }
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.List.Result.Header", new String[0]));
            for (int i = (page - 1) * 5; i < replaces.size() && i < page * 5; ++i) {
                String original = replaces.get(i).toString();
                String replacement = (String)replaces.get(replaces.get(i));
                user.sendFilteredMessage(new ComponentBuilder(PsrLocalization.getLocaledMessage("Utils.Message.Buttons.Add", new String[0])).event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/psr edit replace add " + replaceMode.getNode() + " " + i + " <" + PsrLocalization.getLocaledMessage("Variables.Original-Text", new String[0]) + "> <" + PsrLocalization.getLocaledMessage("Variables.Replacement-Text", new String[0]) + ">")).append(PsrLocalization.getLocaledMessage("Utils.Message.Buttons.Edit", new String[0])).event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/psr edit replace set " + replaceMode.getNode() + " " + i + " " + ArgUtils.formatWithQuotes(ColorUtils.restoreColored(original)) + " " + ArgUtils.formatWithQuotes(ColorUtils.restoreColored(replacement)))).append(" " + i + ". ").reset().append(ColorUtils.showColorCodes(original, replaceMode == ReplaceMode.DIRECT)).color(ChatColor.AQUA).create());
                user.sendFilteredMessage(new ComponentBuilder(PsrLocalization.getLocaledMessage("Utils.Message.Buttons.Delete", new String[0])).event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/psr edit replace remove " + replaceMode.getNode() + " " + i)).append(" \u00a77\u00a7o==> ").reset().append(ColorUtils.showColorCodes(replacement, replaceMode == ReplaceMode.DIRECT)).color(ChatColor.BLUE).create());
            }
            MessageUtils.sendPageButtons(user, "/psr edit replace list " + replaceMode.getNode() + " ", page, totalPage);
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.List.Result.Footer", new String[0]));
        } else {
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.List.Detailed-Help", new String[0]));
        }
    }

    private void setCommand(@Nonnull PsrUser user, @NotNull String[] args2) {
        if (args2.length > 4) {
            ReplaceMode replaceMode = this.getReplacesMode(args2[3]);
            if (replaceMode == null) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Variables.Match-Mode.Messages.Invalid-Mode", args2[3]));
                return;
            }
            if (!StringUtils.isNumeric((String)args2[4])) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Not-A-Positive-Integer", args2[4]));
                return;
            }
            int index = Integer.parseInt(args2[4]);
            FileReplacerConfig editorReplacerConfig = user.getEditorReplacerConfig();
            if (index < 0) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Index-Low", new String[0]));
                return;
            }
            if (args2.length == 6) {
                if (index >= editorReplacerConfig.getReplaces(replaceMode).size()) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Index-Exceed", String.valueOf(editorReplacerConfig.getReplaces(replaceMode).size())));
                    return;
                }
                String replacement = ColorUtils.getColored(args2[5]);
                editorReplacerConfig.setReplace(index, replacement, replaceMode);
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.Set.Successfully-Set-Replace", args2[4], ColorUtils.showColorCodes((String)editorReplacerConfig.getReplaces(replaceMode).get(index), replaceMode == ReplaceMode.DIRECT), ColorUtils.showColorCodes(replacement, replaceMode == ReplaceMode.DIRECT)));
            } else if (args2.length == 7) {
                if (index > editorReplacerConfig.getReplaces(replaceMode).size()) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Index-Exceed", String.valueOf(editorReplacerConfig.getReplaces(replaceMode).size())));
                    return;
                }
                String original = ColorUtils.getColored(args2[5]);
                int i = editorReplacerConfig.checkReplaceKey(original, replaceMode);
                if (i == -1 || i == index) {
                    String replacement = ColorUtils.getColored(args2[6]);
                    editorReplacerConfig.setReplace(index, original, replacement, replaceMode);
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.Set.Successfully-Set-Replace", args2[4], ColorUtils.showColorCodes(original, replaceMode == ReplaceMode.DIRECT), ColorUtils.showColorCodes(replacement, replaceMode == ReplaceMode.DIRECT)));
                } else {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.Same-Original-Text", String.valueOf(i)));
                }
            } else {
                user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.Set.Detailed-Help", new String[0]));
            }
        } else {
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.Set.Detailed-Help", new String[0]));
        }
    }

    private void addCommand(@Nonnull PsrUser user, @NotNull String[] args2) {
        if (args2.length > 3) {
            ReplaceMode replaceMode = this.getReplacesMode(args2[3]);
            if (replaceMode == null) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Variables.Match-Mode.Messages.Invalid-Mode", args2[3]));
                return;
            }
            if (args2.length == 6) {
                String original = ColorUtils.getColored(args2[4]);
                FileReplacerConfig editorReplacerConfig = user.getEditorReplacerConfig();
                int i = editorReplacerConfig.checkReplaceKey(original, replaceMode);
                if (i == -1) {
                    String replacement = ColorUtils.getColored(args2[5]);
                    editorReplacerConfig.addReplace(original, replacement, replaceMode);
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.Add.Successfully-Added-Replace", String.valueOf(editorReplacerConfig.getReplaces(replaceMode).size()), ColorUtils.showColorCodes(original, replaceMode == ReplaceMode.DIRECT), ColorUtils.showColorCodes(replacement, replaceMode == ReplaceMode.DIRECT)));
                } else {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.Same-Original-Text", String.valueOf(i)));
                }
            } else if (args2.length == 7) {
                if (!StringUtils.isNumeric((String)args2[4])) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Not-A-Positive-Integer", args2[4]));
                    return;
                }
                int index = Integer.parseInt(args2[4]);
                if (index < 0) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Index-Low", new String[0]));
                    return;
                }
                String original = ColorUtils.getColored(args2[5]);
                FileReplacerConfig editorReplacerConfig = user.getEditorReplacerConfig();
                int i = editorReplacerConfig.checkReplaceKey(original, replaceMode);
                if (i == -1) {
                    String replacement = ColorUtils.getColored(args2[6]);
                    editorReplacerConfig.addReplace(index, original, replacement, replaceMode);
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.Add.Successfully-Added-Replace", String.valueOf(index), ColorUtils.showColorCodes(original, replaceMode == ReplaceMode.DIRECT), ColorUtils.showColorCodes(replacement, replaceMode == ReplaceMode.DIRECT)));
                } else {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.Same-Original-Text", String.valueOf(i)));
                }
            }
        } else {
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.Add.Detailed-Help", new String[0]));
        }
    }

    private void removeCommand(@Nonnull PsrUser user, @NotNull String[] args2) {
        if (args2.length > 3) {
            ReplaceMode replaceMode = this.getReplacesMode(args2[3]);
            if (replaceMode == null) {
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Variables.Match-Mode.Messages.Invalid-Mode", args2[3]));
                return;
            }
            if (args2.length == 5) {
                if (!StringUtils.isNumeric((String)args2[4])) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Not-A-Positive-Integer", args2[4]));
                    return;
                }
                int index = Integer.parseInt(args2[4]);
                if (index < 0) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Index-Low", new String[0]));
                    return;
                }
                FileReplacerConfig editorReplacerConfig = user.getEditorReplacerConfig();
                if (index > editorReplacerConfig.getReplaces(replaceMode).size()) {
                    user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Error.Index-Exceed", String.valueOf(editorReplacerConfig.getReplaces(replaceMode).size())));
                    return;
                }
                editorReplacerConfig.removeReplace(index, replaceMode);
                user.sendFilteredText(PsrLocalization.getPrefixedLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.Remove.Sucessfully-Removed-Replace", String.valueOf(index)));
            }
        } else {
            user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.Remove.Detailed-Help", new String[0]));
        }
    }

    @Override
    public List<String> onTab(@NotNull PsrUser user, @NotNull String[] args2) {
        List<String> list = new ArrayList<String>();
        if (args2.length == 3) {
            list = Arrays.asList("help", "list", "set", "add", "remove");
        } else if (args2.length == 4 && (args2[2].equalsIgnoreCase("list") || args2[2].equalsIgnoreCase("set") || args2[2].equalsIgnoreCase("add") || args2[2].equalsIgnoreCase("remove"))) {
            list.add("<" + PsrLocalization.getLocaledMessage("Variables.Match-Mode.Name", new String[0]) + ">");
            for (ReplaceMode replaceMode : ReplaceMode.values()) {
                list.add(replaceMode.getNode().toLowerCase(Locale.ENGLISH));
            }
        } else if (args2.length == 5) {
            if (args2[2].equalsIgnoreCase("list")) {
                list.add("[" + PsrLocalization.getLocaledMessage("Variables.Page.Name", new String[0]) + "]");
            } else if (args2[2].equalsIgnoreCase("set")) {
                list.add("<" + PsrLocalization.getLocaledMessage("Variables.Index.Name", new String[0]) + ">");
            } else if (args2[2].equalsIgnoreCase("add")) {
                list.add("[" + PsrLocalization.getLocaledMessage("Variables.Index.Name", new String[0]) + "]|<" + PsrLocalization.getLocaledMessage("Variables.Original-Text.Name", new String[0]) + ">");
            } else if (args2[2].equalsIgnoreCase("remove")) {
                list.add("<" + PsrLocalization.getLocaledMessage("Variables.Index.Name", new String[0]) + ">");
            }
        } else if (args2.length == 6) {
            if (args2[2].equalsIgnoreCase("set")) {
                list.add("<" + PsrLocalization.getLocaledMessage("Variables.Original-Text.Name", new String[0]) + ">");
            } else if (args2[2].equalsIgnoreCase("add")) {
                if (StringUtils.isNumeric((String)args2[3])) {
                    list.add("<" + PsrLocalization.getLocaledMessage("Variables.Original-Text.Name", new String[0]) + ">");
                } else {
                    list.add("<" + PsrLocalization.getLocaledMessage("Variables.Replacement-Text.Name", new String[0]) + ">");
                }
            }
        } else if (args2.length == 7) {
            if (args2[2].equalsIgnoreCase("set")) {
                list.add("<" + PsrLocalization.getLocaledMessage("Variables.Replacement-Text.Name", new String[0]) + ">");
            } else if (args2[2].equalsIgnoreCase("add") && StringUtils.isNumeric((String)args2[3])) {
                list.add("<" + PsrLocalization.getLocaledMessage("Variables.Replacement-Text.Name", new String[0]) + ">");
            }
        }
        return list;
    }

    @Override
    public void sendHelp(@Nonnull PsrUser user) {
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Replace.Help.Header", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.List.Simple-Help", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.Set.Simple-Help", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.Add.Simple-Help", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Replace.Children.Remove.Simple-Help", new String[0]));
        user.sendFilteredText(PsrLocalization.getLocaledMessage("Sender.Commands.Edit.Children.Replace.Help.Footer", new String[0]));
    }

    private ReplaceMode getReplacesMode(@NotNull String string) {
        for (ReplaceMode type : ReplaceMode.values()) {
            if (!type.getNode().equalsIgnoreCase(string)) continue;
            return type;
        }
        return null;
    }
}

