/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.console;

import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.api.replacer.ReplacerConfig;
import io.github.rothes.protocolstringreplacer.console.ConsoleReplaceManager;
import io.github.rothes.protocolstringreplacer.replacer.ReplacerManager;
import io.github.rothes.protocolstringreplacer.replacer.containers.SimpleTextContainer;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.message.Message;
import org.jetbrains.annotations.NotNull;

public class PsrFilter
implements Filter {
    private final ProtocolStringReplacer plugin;
    private boolean started = false;

    public PsrFilter(@NotNull ProtocolStringReplacer plugin) {
        this.plugin = plugin;
    }

    public Filter.Result getOnMismatch() {
        return Filter.Result.NEUTRAL;
    }

    public Filter.Result getOnMatch() {
        return Filter.Result.NEUTRAL;
    }

    @NotNull
    private Filter.Result getBlocked(@NotNull String message) {
        if (ProtocolStringReplacer.getInstance().hasStarted() && message != null) {
            SimpleTextContainer container = new SimpleTextContainer(message);
            container.createTexts(container);
            ReplacerManager replacerManager = this.plugin.getReplacerManager();
            List<ReplacerConfig> replacers = replacerManager.getAcceptedReplacers(this.plugin.getUserManager().getConsoleUser(), ConsoleReplaceManager.getFilter());
            boolean textBlocked = replacerManager.isTextBlocked(container, replacers);
            if (textBlocked) {
                return Filter.Result.DENY;
            }
            return Filter.Result.NEUTRAL;
        }
        return Filter.Result.NEUTRAL;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        return this.getBlocked(msg);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0) {
        return this.getBlocked(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1) {
        return this.getBlocked(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        return this.getBlocked(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        return this.getBlocked(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.getBlocked(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.getBlocked(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.getBlocked(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.getBlocked(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.getBlocked(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.getBlocked(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        if (msg != null) {
            return this.getBlocked(msg.toString());
        }
        return Filter.Result.NEUTRAL;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return this.getBlocked(msg.getFormattedMessage());
    }

    public Filter.Result filter(LogEvent event) {
        return this.getBlocked(event.getMessage().getFormattedMessage());
    }

    public LifeCycle.State getState() {
        return LifeCycle.State.STARTED;
    }

    public void initialize() {
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return !this.started;
    }
}

