/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.console;

import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.api.replacer.ReplacerConfig;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.console.ConsoleReplaceManager;
import io.github.rothes.protocolstringreplacer.replacer.ReplacerManager;
import io.github.rothes.protocolstringreplacer.replacer.containers.SimpleTextContainer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.message.Message;

public class PsrMessage
implements Message,
CharSequence {
    private static ProtocolStringReplacer plugin;
    private String message;
    private Object[] params;
    private transient CharSequence charSequence;

    public PsrMessage(String message) {
        this(message, null);
    }

    public PsrMessage(String message, Object[] params) {
        if (plugin.hasStarted()) {
            String result;
            SimpleTextContainer container = new SimpleTextContainer(message);
            container.createTexts(container);
            ReplacerManager replacerManager = plugin.getReplacerManager();
            PsrUser consoleUser = plugin.getUserManager().getConsoleUser();
            List<ReplacerConfig> replacers = replacerManager.getAcceptedReplacers(consoleUser, ConsoleReplaceManager.getFilter());
            replacerManager.replaceContainerTexts(container, replacers);
            if (PsrMessage.plugin.getConfigManager().consolePlaceholder) {
                replacerManager.setPapi(consoleUser, container.getTexts());
            }
            this.message = result = container.getResult();
            this.charSequence = result;
        } else {
            this.message = message;
            this.charSequence = message;
        }
        this.params = params;
    }

    public PsrMessage(CharSequence charSequence) {
        if (plugin.hasStarted()) {
            SimpleTextContainer container = new SimpleTextContainer(charSequence.toString());
            container.createTexts(container);
            ReplacerManager replacerManager = plugin.getReplacerManager();
            PsrUser consoleUser = plugin.getUserManager().getConsoleUser();
            List<ReplacerConfig> replacers = replacerManager.getAcceptedReplacers(consoleUser, ConsoleReplaceManager.getFilter());
            replacerManager.replaceContainerTexts(container, replacers);
            if (PsrMessage.plugin.getConfigManager().consolePlaceholder) {
                replacerManager.setPapi(consoleUser, container.getTexts());
            }
            this.charSequence = container.getResult();
        } else {
            this.charSequence = charSequence;
        }
    }

    public static void initialize(ProtocolStringReplacer plugin) {
        PsrMessage.plugin = plugin;
    }

    public String getFormattedMessage() {
        if (this.message == null) {
            this.message = this.params == null ? String.valueOf(this.charSequence) : String.format(this.charSequence.toString(), this.params);
        }
        return this.message;
    }

    public String getFormat() {
        return this.message;
    }

    public Object[] getParameters() {
        return this.params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsrMessage that = (PsrMessage)o;
        return Objects.equals(this.charSequence, that.charSequence);
    }

    public int hashCode() {
        return this.charSequence != null ? this.charSequence.hashCode() : 0;
    }

    @Override
    public String toString() {
        return this.getFormattedMessage();
    }

    public Throwable getThrowable() {
        return null;
    }

    @Override
    public int length() {
        return this.charSequence == null ? 0 : this.charSequence.length();
    }

    @Override
    public char charAt(int index) {
        return this.charSequence.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.charSequence.subSequence(start, end);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getFormattedMessage();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.charSequence = this.message;
    }
}

