/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher;

import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.Algorithm;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.StringSearcher;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.StringSearcherConfig;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.StringSearcherPrepare;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.trie.Trie;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class StringSearcherBuilder<T> {
    private final StringSearcherConfig config = new StringSearcherConfig();
    private StringSearcherPrepare<T> stringMatcher;
    private Queue<Map.Entry<String, T>> stringsearchPayloads = new LinkedList<Map.Entry<String, T>>();
    private Algorithm algorithm = Algorithm.AHO_COHARICK;

    public StringSearcherBuilder<T> algorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public StringSearcherBuilder<T> ignoreCase() {
        this.config.setCaseInsensitive(true);
        return this;
    }

    public StringSearcherBuilder<T> ignoreOverlaps() {
        this.config.setAllowOverlaps(false);
        return this;
    }

    public StringSearcherBuilder<T> addSearchString(String searchString) {
        this.addSearchStringImpl(searchString, null);
        return this;
    }

    public StringSearcherBuilder<T> addSearchStrings(String ... searchStrings) {
        for (String string : searchStrings) {
            this.addSearchStringImpl(string, null);
        }
        return this;
    }

    public StringSearcherBuilder<T> addSearchStrings(Collection<String> searchStrings) {
        for (String string : searchStrings) {
            this.addSearchStringImpl(string, null);
        }
        return this;
    }

    public StringSearcherBuilder<T> addSearchString(String searchString, T payload) {
        this.addSearchStringImpl(searchString, payload);
        return this;
    }

    private void addSearchStringImpl(String searchString, T payload) {
        this.stringsearchPayloads.add(new AbstractMap.SimpleEntry<String, T>(searchString, payload));
    }

    public StringSearcherBuilder<T> addSearchString(Map.Entry<String, T> entry) {
        this.stringsearchPayloads.add(entry);
        return this;
    }

    public StringSearcherBuilder<T> onlyWholeWords() {
        this.config.setOnlyWholeWords(true);
        return this;
    }

    public StringSearcherBuilder<T> onlyWholeWordsWhiteSpaceSeparated() {
        this.config.setOnlyWholeWordsWhiteSpaceSeparated(true);
        return this;
    }

    public StringSearcherBuilder<T> stopOnHit() {
        this.config.setStopOnHit(true);
        return this;
    }

    public StringSearcher<T> build() {
        if (this.algorithm == Algorithm.AHO_COHARICK) {
            this.stringMatcher = new Trie(this.config);
            Map.Entry<String, T> simpleEntry = null;
            while ((simpleEntry = this.stringsearchPayloads.poll()) != null) {
                this.stringMatcher.addSearchString(simpleEntry.getKey(), simpleEntry.getValue());
            }
            return this.stringMatcher.build();
        }
        return null;
    }
}

