/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.trie;

import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.Emit;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.EmitHandler;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.FragmentToken;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.MatchToken;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.StringSearcher;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.StringSearcherConfig;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.StringSearcherPrepare;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.Token;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.trie.Payload;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.trie.State;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.trie.handler.DefaultEmitHandler;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.trie.handler.StatefulEmitHandler;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.trie.interval.IntervalTree;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.trie.interval.Intervalable;
import io.github.rothes.protocolstringreplacer.lib.org.neosearch.stringsearcher.trie.util.ListElementRemoval;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Trie<T>
implements StringSearcher<T>,
StringSearcherPrepare<T> {
    private final StringSearcherConfig trieConfig;
    private final State<T> rootState;

    public Trie(StringSearcherConfig trieConfig) {
        this.trieConfig = trieConfig;
        this.rootState = new State();
    }

    @Override
    public void addSearchString(String keyword, T emit) {
        if (keyword.isEmpty()) {
            return;
        }
        if (this.isCaseInsensitive()) {
            keyword = keyword.toLowerCase();
        }
        this.addState(keyword).addEmit(new Payload<T>(keyword, emit));
    }

    @Override
    public void addSearchString(String keyword) {
        if (keyword.isEmpty()) {
            return;
        }
        if (this.isCaseInsensitive()) {
            keyword = keyword.toLowerCase();
        }
        this.addState(keyword).addEmit(new Payload<Object>(keyword, null));
    }

    @Override
    public void addSearchStrings(String ... keywords) {
        for (String keyword : keywords) {
            this.addSearchString(keyword);
        }
    }

    @Override
    public void addSearchStrings(Collection<String> keywords) {
        for (String keyword : keywords) {
            this.addSearchString(keyword);
        }
    }

    private State<T> addState(String keyword) {
        return this.getRootState().addState(keyword);
    }

    @Override
    public Collection<Token<T>> tokenize(String text) {
        ArrayList<Token<T>> tokens = new ArrayList<Token<T>>();
        Collection<Emit<T>> collectedEmits = this.parseText(text);
        int lastCollectedPosition = -1;
        for (Emit<T> emit : collectedEmits) {
            if (emit.getStart() - lastCollectedPosition > 1) {
                tokens.add(this.createFragment(emit, text, lastCollectedPosition));
            }
            tokens.add(this.createMatch(emit, text));
            lastCollectedPosition = emit.getEnd();
        }
        if (text.length() - lastCollectedPosition > 1) {
            tokens.add(this.createFragment(null, text, lastCollectedPosition));
        }
        return tokens;
    }

    private Token<T> createFragment(Emit<T> emit, String text, int lastCollectedPosition) {
        return new FragmentToken(text.substring(lastCollectedPosition + 1, emit == null ? text.length() : emit.getStart()));
    }

    private Token<T> createMatch(Emit<T> emit, String text) {
        return new MatchToken<T>(text.substring(emit.getStart(), emit.getEnd() + 1), emit);
    }

    @Override
    public Collection<Emit<T>> parseText(CharSequence text) {
        return this.parseText(text, new DefaultEmitHandler());
    }

    public Collection<Emit<T>> parseText(CharSequence text, StatefulEmitHandler<T> emitHandler) {
        this.parseText(text, (EmitHandler<T>)emitHandler);
        List<Intervalable> collectedEmits = emitHandler.getEmits();
        if (this.trieConfig.isOnlyWholeWords()) {
            this.removePartialMatches(text, collectedEmits);
        }
        if (this.trieConfig.isOnlyWholeWordsWhiteSpaceSeparated()) {
            this.removePartialMatchesWhiteSpaceSeparated(text, collectedEmits);
        }
        if (!this.trieConfig.isAllowOverlaps()) {
            IntervalTree intervalTree = new IntervalTree(collectedEmits);
            intervalTree.removeOverlaps(collectedEmits);
        }
        return collectedEmits;
    }

    @Override
    public boolean containsMatch(CharSequence text) {
        return this.firstMatch(text) != null;
    }

    @Override
    public void parseText(CharSequence text, EmitHandler<T> emitHandler) {
        State<T> currentState = this.getRootState();
        for (int position = 0; position < text.length(); ++position) {
            Character character = Character.valueOf(text.charAt(position));
            if (this.trieConfig.isCaseInsensitive()) {
                character = Character.valueOf(Character.toLowerCase(character.charValue()));
            }
            if (!this.storeEmits(position, currentState = this.getState(currentState, character), emitHandler) || !this.trieConfig.isStopOnHit()) continue;
            return;
        }
    }

    @Override
    public Emit<T> firstMatch(CharSequence text) {
        if (!this.trieConfig.isAllowOverlaps()) {
            Collection<Emit<T>> parseText = this.parseText(text);
            if (parseText != null && !parseText.isEmpty()) {
                return parseText.iterator().next();
            }
        } else {
            State<T> currentState = this.getRootState();
            for (int position = 0; position < text.length(); ++position) {
                Collection<Payload<T>> payloads;
                Character character = Character.valueOf(text.charAt(position));
                if (this.trieConfig.isCaseInsensitive()) {
                    character = Character.valueOf(Character.toLowerCase(character.charValue()));
                }
                if ((payloads = (currentState = this.getState(currentState, character)).emit()) == null || payloads.isEmpty()) continue;
                for (Payload<T> payload : payloads) {
                    Emit<T> emit = new Emit<T>(position - payload.getKeyword().length() + 1, position, payload.getKeyword(), payload.getData());
                    if (this.trieConfig.isOnlyWholeWords()) {
                        if (this.isPartialMatch(text, emit)) continue;
                        return emit;
                    }
                    return emit;
                }
            }
        }
        return null;
    }

    private boolean isPartialMatch(CharSequence searchText, Emit<T> emit) {
        return emit.getStart() != 0 && Character.isAlphabetic(searchText.charAt(emit.getStart() - 1)) || emit.getEnd() + 1 != searchText.length() && Character.isAlphabetic(searchText.charAt(emit.getEnd() + 1));
    }

    private void removePartialMatches(final CharSequence searchText, List<Emit<T>> collectedEmits) {
        ListElementRemoval.RemoveElementPredicate predicate = new ListElementRemoval.RemoveElementPredicate<Emit<T>>(){

            @Override
            public boolean remove(Emit<T> emit) {
                return Trie.this.isPartialMatch(searchText, emit);
            }
        };
        ListElementRemoval.removeIf(collectedEmits, predicate);
    }

    private void removePartialMatchesWhiteSpaceSeparated(CharSequence searchText, List<Emit<T>> collectedEmits) {
        long size = searchText.length();
        ArrayList<Emit<T>> removeEmits = new ArrayList<Emit<T>>();
        for (Emit<T> emit : collectedEmits) {
            if (!(emit.getStart() != 0 && !Character.isWhitespace(searchText.charAt(emit.getStart() - 1)) || (long)(emit.getEnd() + 1) != size && !Character.isWhitespace(searchText.charAt(emit.getEnd() + 1)))) continue;
            removeEmits.add(emit);
        }
        for (Emit<Object> emit : removeEmits) {
            collectedEmits.remove(emit);
        }
    }

    private State<T> getState(State<T> currentState, Character character) {
        State<T> newCurrentState = currentState.nextState(character);
        while (newCurrentState == null) {
            currentState = currentState.failure();
            newCurrentState = currentState.nextState(character);
        }
        return newCurrentState;
    }

    @Override
    public Trie<T> build() {
        ArrayDeque queue = new ArrayDeque();
        State<T> startState = this.getRootState();
        for (State<T> depthOneState : startState.getStates()) {
            depthOneState.setFailure(startState);
            queue.add(depthOneState);
        }
        while (!queue.isEmpty()) {
            State currentState = (State)queue.remove();
            for (Character transition : currentState.getTransitions()) {
                State targetState = currentState.nextState(transition);
                queue.add(targetState);
                State traceFailureState = currentState.failure();
                while (traceFailureState.nextState(transition) == null) {
                    traceFailureState = traceFailureState.failure();
                }
                State newFailureState = traceFailureState.nextState(transition);
                targetState.setFailure(newFailureState);
                targetState.addEmit(newFailureState.emit());
            }
        }
        return this;
    }

    private boolean storeEmits(int position, State<T> currentState, EmitHandler<T> emitHandler) {
        boolean emitted;
        block1: {
            Payload<T> payload;
            emitted = false;
            Collection<Payload<T>> payloads = currentState.emit();
            if (payloads == null || payloads.isEmpty()) break block1;
            Iterator<Payload<T>> iterator2 = payloads.iterator();
            while (!(!iterator2.hasNext() || (emitted = emitHandler.emit(new Emit<T>(position - (payload = iterator2.next()).getKeyword().length() + 1, position, payload.getKeyword(), payload.getData())) || emitted) && this.trieConfig.isStopOnHit())) {
            }
        }
        return emitted;
    }

    private boolean isCaseInsensitive() {
        return this.trieConfig.isCaseInsensitive();
    }

    private State<T> getRootState() {
        return this.rootState;
    }
}

