/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.packetlistener;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public abstract class BasePacketListener {
    protected final PacketType packetType;
    protected PacketAdapter packetAdapter;

    protected BasePacketListener(@Nonnull PacketType packetType) {
        this.packetType = packetType;
    }

    protected void register() {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.packetAdapter);
    }

    @Nullable
    protected final PsrUser getEventUser(@Nonnull PacketEvent packetEvent) {
        Validate.notNull((Object)packetEvent, (String)"Packet Event cannot be null");
        Player player = packetEvent.getPlayer();
        if (packetEvent.isPlayerTemporary()) {
            ProtocolStringReplacer.warn("ProtocolLib returns temporary player [" + player.getAddress() + "] for packet " + this.packetType.name() + ". It cannot be processed.");
            return null;
        }
        return ProtocolStringReplacer.getInstance().getUserManager().getUser(player);
    }

    protected boolean canWrite(@Nonnull PacketEvent packetEvent) {
        Validate.notNull((Object)packetEvent, (String)"Packet Event cannot be null");
        if (packetEvent.isReadOnly()) {
            if (ProtocolStringReplacer.getInstance().getConfigManager().forceReplace) {
                packetEvent.setReadOnly(false);
            } else {
                return false;
            }
        }
        return true;
    }

    protected abstract void process(@Nonnull PacketEvent var1);
}

