/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.packetlistener.server;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.api.replacer.ReplacerConfig;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.packetlistener.server.BaseServerPacketListener;
import io.github.rothes.protocolstringreplacer.replacer.ListenType;
import java.util.List;
import java.util.Optional;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class EntityMetadata
extends BaseServerPacketListener {
    public byte exceptionTimes = 0;
    private final boolean shouldDV = ProtocolStringReplacer.getInstance().getServerMajorVersion() >= 20 || ProtocolStringReplacer.getInstance().getServerMajorVersion() == 19 && ProtocolStringReplacer.getInstance().getServerMinorVersion() >= 3;

    public EntityMetadata() {
        super(PacketType.Play.Server.ENTITY_METADATA, ListenType.ENTITY);
    }

    @Override
    protected void process(@NotNull PacketEvent packetEvent) {
        PacketContainer processed;
        PsrUser user = this.getEventUser(packetEvent);
        if (user == null) {
            return;
        }
        PacketContainer packet = packetEvent.getPacket();
        if (packet != (processed = this.processPacket(packetEvent, user, packet, null, -1))) {
            packetEvent.setPacket(processed);
        }
    }

    private PacketContainer processPacket(PacketEvent packetEvent, PsrUser user, PacketContainer packet, Object first, int index) {
        block9: {
            boolean clone;
            block8: {
                boolean bl = clone = first == null;
                if (!this.shouldDV) break block8;
                List dataValueList = (List)packet.getDataValueCollectionModifier().read(0);
                if (!clone) {
                    ((WrappedDataValue)dataValueList.get(index)).setValue(first);
                }
                int dataValueListSize = dataValueList.size();
                for (int i = index + 1; i < dataValueListSize; ++i) {
                    WrappedDataValue wrappedDataValue = (WrappedDataValue)dataValueList.get(i);
                    Object getValue = wrappedDataValue.getValue();
                    Object o = this.processObject(packetEvent, user, getValue);
                    if (o == this) {
                        return packet;
                    }
                    if (o == null || o == getValue) continue;
                    if (clone) {
                        PacketContainer cloned = this.clonePacket(packet);
                        this.processPacket(packetEvent, user, cloned, o, i);
                        return cloned;
                    }
                    wrappedDataValue.setValue(o);
                }
                break block9;
            }
            List metadataList = (List)packet.getWatchableCollectionModifier().read(0);
            if (!clone) {
                ((WrappedWatchableObject)metadataList.get(index)).setValue(first);
            }
            if (metadataList == null) break block9;
            int metadataListSize = metadataList.size();
            for (int i = index + 1; i < metadataListSize; ++i) {
                WrappedWatchableObject watchableObject = (WrappedWatchableObject)metadataList.get(i);
                Object getValue = watchableObject.getValue();
                Object o = this.processObject(packetEvent, user, getValue);
                if (o == this) {
                    return packet;
                }
                if (o == null || o == getValue) continue;
                if (clone) {
                    PacketContainer cloned = this.clonePacket(packet);
                    this.processPacket(packetEvent, user, cloned, o, i);
                    return cloned;
                }
                watchableObject.setValue(o);
            }
        }
        return packet;
    }

    private PacketContainer clonePacket(PacketContainer packet) {
        try {
            return packet.deepClone();
        }
        catch (RuntimeException e) {
            if (this.exceptionTimes < ProtocolStringReplacer.getInstance().getConfigManager().protocolLibSideStackPrintCount) {
                ProtocolStringReplacer.warn("Exception which is a ProtocolLib side problem: " + e);
                ProtocolStringReplacer.warn("Please update your ProtocolLib to the latest (development) version.");
                this.exceptionTimes = (byte)(this.exceptionTimes + 1);
            }
            return null;
        }
    }

    private Object processObject(PacketEvent packetEvent, PsrUser user, Object object) {
        if (object instanceof Optional) {
            Optional value = (Optional)object;
            if (value.isPresent()) {
                Object get = value.get();
                if (!(get instanceof WrappedChatComponent)) {
                    return null;
                }
                WrappedChatComponent wrappedChatComponent = (WrappedChatComponent)get;
                String json = wrappedChatComponent.getJson();
                String replacedJson = EntityMetadata.getReplacedJson(packetEvent, user, this.listenType, json, this.filter);
                if (replacedJson != null) {
                    if (json.equals(replacedJson)) {
                        return null;
                    }
                    wrappedChatComponent.setJson(replacedJson);
                    return Optional.of(wrappedChatComponent.getHandle());
                }
                return this;
            }
        } else {
            if (object instanceof WrappedChatComponent) {
                WrappedChatComponent wrappedChatComponent = (WrappedChatComponent)object;
                String json = wrappedChatComponent.getJson();
                String replacedJson = EntityMetadata.getReplacedJson(packetEvent, user, this.listenType, json, this.filter);
                if (replacedJson != null) {
                    if (json.equals(replacedJson)) {
                        return null;
                    }
                    wrappedChatComponent.setJson(replacedJson);
                    return wrappedChatComponent;
                }
                return this;
            }
            if (object instanceof String) {
                String replacedText = EntityMetadata.getReplacedText(packetEvent, user, this.listenType, (String)object, this.filter);
                return replacedText == null ? this : (replacedText.equals(object) ? null : replacedText);
            }
            if (object instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)object;
                List<ReplacerConfig> replacerConfigs = ProtocolStringReplacer.getInstance().getReplacerManager().getAcceptedReplacers(user, this.filter);
                return EntityMetadata.replaceItemStack(packetEvent, user, this.listenType, itemStack, replacerConfigs, replacerConfigs, replacerConfigs, true);
            }
        }
        return null;
    }
}

