/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.packetlistener.server;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import io.github.rothes.protocolstringreplacer.ProtocolStringReplacer;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.nms.NmsManager;
import io.github.rothes.protocolstringreplacer.packetlistener.server.BaseServerPacketListener;
import io.github.rothes.protocolstringreplacer.replacer.ListenType;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;

public final class OpenWindow
extends BaseServerPacketListener {
    private Field windowTypeField = null;
    private Object anvilType = null;

    public OpenWindow() {
        super(PacketType.Play.Server.OPEN_WINDOW, ListenType.WINDOW_TITLE);
        Class packetClass = PacketType.Play.Server.OPEN_WINDOW.getPacketClass();
        for (Field declaredField : packetClass.getDeclaredFields()) {
            if (declaredField.getType() == String.class) {
                return;
            }
            if (declaredField.getType() == Integer.TYPE || declaredField.getType() == MinecraftReflection.getIChatBaseComponentClass()) continue;
            this.windowTypeField = declaredField;
            this.windowTypeField.setAccessible(true);
        }
        if (ProtocolStringReplacer.getInstance().getServerMajorVersion() <= 19) {
            if (this.windowTypeField != null) {
                try {
                    this.anvilType = this.windowTypeField.getType().getDeclaredField("h").get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.anvilType = NmsManager.INSTANCE.getMenuTypeGetter().getAnvilMenuType();
        }
    }

    @Override
    protected void process(@NotNull PacketEvent packetEvent) {
        PsrUser user = this.getEventUser(packetEvent);
        if (user == null) {
            return;
        }
        PacketContainer packet = packetEvent.getPacket();
        StructureModifier wrappedChatComponentStructureModifier = packet.getChatComponents();
        WrappedChatComponent wrappedChatComponent = (WrappedChatComponent)wrappedChatComponentStructureModifier.read(0);
        String json = wrappedChatComponent.getJson();
        WrappedChatComponent replaced = OpenWindow.getReplacedJsonWrappedComponent(packetEvent, user, this.listenType, json, this.filter);
        if (replaced != null) {
            user.setCurrentWindowTitle(json);
            wrappedChatComponentStructureModifier.write(0, (Object)replaced);
            if (this.windowTypeField != null) {
                try {
                    if (this.windowTypeField.get(packet.getHandle()) == this.anvilType) {
                        user.setInAnvil(true);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            } else {
                StructureModifier strings = packet.getStrings();
                if (strings.size() != 0) {
                    if (((String)strings.read(0)).equals("minecraft:anvil")) {
                        user.setInAnvil(true);
                    }
                    return;
                }
                if ((Integer)packet.getIntegers().read(1) == 7) {
                    user.setInAnvil(true);
                }
            }
        }
    }
}

