/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.protocolstringreplacer.packetlistener.server.actionbar;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import io.github.rothes.protocolstringreplacer.api.user.PsrUser;
import io.github.rothes.protocolstringreplacer.packetlistener.server.BaseServerComponentsPacketListener;
import io.github.rothes.protocolstringreplacer.replacer.ListenType;
import org.jetbrains.annotations.NotNull;

public class ChatActionBar
extends BaseServerComponentsPacketListener {
    public ChatActionBar() {
        super(PacketType.Play.Server.CHAT, ListenType.ACTIONBAR);
    }

    @Override
    protected void process(@NotNull PacketEvent packetEvent) {
        String replaced;
        PacketContainer packet = packetEvent.getPacket();
        if (packet.getChatTypes().read(0) != EnumWrappers.ChatType.GAME_INFO && (packet.getBytes().size() < 1 || (Byte)packet.getBytes().read(0) != 2)) {
            return;
        }
        PsrUser user = this.getEventUser(packetEvent);
        if (user == null) {
            return;
        }
        StructureModifier componentModifier = packet.getChatComponents();
        WrappedChatComponent wrappedChatComponent = (WrappedChatComponent)componentModifier.read(0);
        if (wrappedChatComponent != null) {
            String json = wrappedChatComponent.getJson();
            replaced = ChatActionBar.getReplacedJson(packetEvent, user, this.listenType, json, this.filter);
        } else {
            StructureModifier modifier = packet.getModifier();
            replaced = this.processSpigotComponent((StructureModifier<Object>)modifier, packetEvent, user);
            if (replaced == null) {
                replaced = this.processPaperComponent((StructureModifier<Object>)modifier, packetEvent, user);
            }
        }
        if (replaced != null) {
            componentModifier.write(0, (Object)WrappedChatComponent.fromJson((String)replaced));
        }
    }
}

